/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;

public final class Round
extends SystemFunction {
    @Override
    public int getCardinality(Expression[] arguments) {
        return arguments[0].getCardinality();
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NumericValue val0 = (NumericValue)arguments[0].head();
        if (val0 == null) {
            return EmptySequence.getInstance();
        }
        int scaleRnd = 0;
        if (arguments.length == 2) {
            NumericValue scaleVal = (NumericValue)arguments[1].head();
            scaleRnd = (int)scaleVal.longValue();
        }
        return val0.round(scaleRnd);
    }

    @Override
    public String getCompilerName() {
        return "RoundingCompiler";
    }

    @Override
    public Elaborator getElaborator() {
        return new RoundElaborator();
    }

    public static class RoundElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            ItemEvaluator argEval = fnc.getArg(0).makeElaborator().elaborateForItem();
            boolean nullable = Cardinality.allowsZero(fnc.getArg(0).getCardinality());
            if (fnc.getArity() == 1) {
                if (nullable) {
                    return context -> {
                        NumericValue result = (NumericValue)argEval.eval(context);
                        if (result == null) {
                            return null;
                        }
                        return result.round(0);
                    };
                }
                return context -> ((NumericValue)argEval.eval(context)).round(0);
            }
            ItemEvaluator scaleArg = fnc.getArg(1).makeElaborator().elaborateForItem();
            return context -> {
                NumericValue result = (NumericValue)argEval.eval(context);
                if (result == null) {
                    return null;
                }
                int scale = (int)((NumericValue)scaleArg.eval(context)).longValue();
                return result.round(scale);
            };
        }
    }
}

