/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class StartsWith
extends CollatingFunctionFixed {
    @Override
    public boolean isSubstringMatchingFunction() {
        return true;
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        if (this.getStringCollator() == CodepointCollator.getInstance()) {
            return new SystemFunctionCall.Optimized(this, arguments){

                @Override
                public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
                    String s0 = this.getArg(0).evaluateAsString(context).toString();
                    String s1 = this.getArg(1).evaluateAsString(context).toString();
                    return s0.startsWith(s1);
                }
            };
        }
        return super.makeOptimizedFunctionCall(visitor, contextInfo, arguments);
    }

    public static boolean startsWith(UnicodeString arg0, UnicodeString arg1, SubstringMatcher collator) {
        if (arg1 == null || arg1.isEmpty() || collator.isEqualToEmpty(arg1)) {
            return true;
        }
        if (arg0 == null || arg0.isEmpty()) {
            return false;
        }
        return collator.startsWith(arg0, arg1);
    }

    @Override
    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        UnicodeString s0 = this.getUniStringArg(arguments[0]);
        UnicodeString s1 = this.getUniStringArg(arguments[1]);
        return BooleanValue.get(StartsWith.startsWith(s0, s1, (SubstringMatcher)this.getStringCollator()));
    }

    @Override
    public String getCompilerName() {
        return "StartsWithCompiler";
    }
}

