/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.StringElaborator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.ToUpper;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class UpperCase
extends ScalarSystemFunction {
    @Override
    public AtomicValue evaluate(Item arg, XPathContext context) {
        return StringValue.makeUStringValue(ToUpper.toUpper(arg.getUnicodeStringValue()));
    }

    @Override
    public Sequence resultWhenEmpty() {
        return StringValue.EMPTY_STRING;
    }

    @Override
    public String getCompilerName() {
        return "ForceCaseCompiler";
    }

    @Override
    public Elaborator getElaborator() {
        return new UpperCaseFnElaborator();
    }

    public static class UpperCaseFnElaborator
    extends StringElaborator {
        @Override
        public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            UnicodeStringEvaluator argEval = arg.makeElaborator().elaborateForUnicodeString(false);
            return context -> {
                UnicodeString s0 = argEval.eval(context);
                if (s0 == null) {
                    return this.handleNullUnicodeString(zeroLengthWhenAbsent);
                }
                return ToUpper.toUpper(s0);
            };
        }

        @Override
        public StringEvaluator elaborateForString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            StringEvaluator argEval = arg.makeElaborator().elaborateForString(false);
            return context -> {
                String s0 = argEval.eval(context);
                if (s0 == null) {
                    return this.handleNullString(zeroLengthWhenAbsent);
                }
                return s0.toUpperCase();
            };
        }
    }
}

