/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.SingleEntryMap;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.SequenceIteratorOverJavaIterator;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public abstract class MapItem
implements FunctionItem {
    public abstract GroundedValue get(AtomicValue var1);

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract AtomicIterator keys();

    public abstract Iterable<KeyValuePair> keyValuePairs();

    public SequenceIterator entries() {
        return new SequenceIteratorOverJavaIterator<KeyValuePair>(this.keyValuePairs().iterator(), entry -> new SingleEntryMap(entry.key, entry.value));
    }

    public abstract MapItem addEntry(AtomicValue var1, GroundedValue var2);

    public abstract MapItem remove(AtomicValue var1);

    public abstract boolean conforms(AtomicType var1, SequenceType var2, TypeHierarchy var3);

    public abstract ItemType getItemType(TypeHierarchy var1);

    public abstract UType getKeyUType();

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append("map{");
        int count = this.size();
        if (count == 0) {
            sb.append("}");
        } else if (count <= 5) {
            int pos = 0;
            for (KeyValuePair pair : this.keyValuePairs()) {
                if (pos++ > 0) {
                    sb.append(",");
                }
                sb.append(Err.depict(pair.key)).append(":").append(Err.depictSequence(pair.value));
            }
            sb.append("}");
        } else {
            sb.append("(:size ").append(count).append(":)}");
        }
        return sb.toString();
    }

    @Override
    public Genre getGenre() {
        return Genre.MAP;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public AnnotationList getAnnotations() {
        return AnnotationList.EMPTY;
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        throw new XPathException("Cannot atomize a map (" + this.toShortString() + ")", "FOTY0013");
    }

    public static boolean isKnownToConform(Sequence value, ItemType itemType) {
        if (itemType == AnyItemType.getInstance()) {
            return true;
        }
        try {
            Item item;
            SequenceIterator iter = value.iterate();
            while ((item = iter.next()) != null) {
                if (item instanceof AtomicValue) {
                    if (itemType instanceof AtomicType) {
                        if (Type.isSubType(((AtomicValue)item).getItemType(), (AtomicType)itemType)) continue;
                        return false;
                    }
                    return false;
                }
                if (item instanceof NodeInfo) {
                    if (itemType instanceof NodeTest) {
                        if (((NodeTest)itemType).test((NodeInfo)item)) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        catch (UncheckedXPathException e) {
            return false;
        }
    }

    public static ItemType getItemTypeOfSequence(Sequence val) {
        try {
            Item first = val.head();
            if (first == null) {
                return AnyItemType.getInstance();
            }
            ItemType type = first instanceof AtomicValue ? ((AtomicValue)first).getItemType() : (first instanceof NodeInfo ? NodeKindTest.makeNodeKindTest(((NodeInfo)first).getNodeKind()) : AnyFunctionType.getInstance());
            if (MapItem.isKnownToConform(val, type)) {
                return type;
            }
            return AnyItemType.getInstance();
        }
        catch (XPathException e) {
            return AnyItemType.getInstance();
        }
    }

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        return MapType.ANY_MAP_TYPE;
    }

    @Override
    public StructuredQName getFunctionName() {
        return null;
    }

    @Override
    public String getDescription() {
        return "map";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public XPathContext makeNewContext(XPathContext callingContext, ContextOriginator originator) {
        return callingContext;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        AtomicValue key = (AtomicValue)args[0].head();
        GroundedValue value = this.get(key);
        if (value == null) {
            return EmptySequence.getInstance();
        }
        return value;
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        throw new UncheckedXPathException(new XPathException("A map has no string value", "FOTY0014"));
    }

    public SequenceIterator getTypedValue() throws XPathException {
        throw new XPathException("A map has no typed value");
    }

    @Override
    public boolean deepEquals(FunctionItem other, XPathContext context, AtomicComparer comparer, int flags) throws XPathException {
        if (other instanceof MapItem && ((MapItem)other).size() == this.size()) {
            AtomicValue key;
            AtomicIterator keyIter = this.keys();
            while ((key = keyIter.next()) != null) {
                GroundedValue thisValue = this.get(key);
                assert (thisValue != null);
                GroundedValue otherValue = ((MapItem)other).get(key);
                if (otherValue == null) {
                    return false;
                }
                if (DeepEqual.deepEqual(otherValue.iterate(), thisValue.iterate(), comparer, context, flags)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public MapItem itemAt(int n) {
        return n == 0 ? this : null;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("A map item has no effective boolean value");
    }

    public static String mapToString(MapItem map) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("map{");
        for (KeyValuePair pair : map.keyValuePairs()) {
            if (buffer.length() > 4) {
                buffer.append(",");
            }
            buffer.append(pair.key.toString());
            buffer.append(":");
            buffer.append(pair.value.toString());
        }
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("map");
        out.emitAttribute("size", "" + this.size());
        for (KeyValuePair kvp : this.keyValuePairs()) {
            Literal.exportAtomicValue(kvp.key, out);
            Literal.exportValue(kvp.value, out);
        }
        out.endElement();
    }

    @Override
    public boolean isTrustedResultType() {
        return true;
    }
}

