/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLChooseOrSwitch;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class XSLSwitch
extends XSLChooseOrSwitch {
    private Expression select;
    private LetExpression switchVar;

    @Override
    protected void prepareAttributes() {
        for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            if (f.equals("select")) {
                this.select = this.makeExpression(value, att);
                continue;
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.select == null) {
            this.reportAbsence("select");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.requireXslt40("switch");
        this.select = this.typeCheck("select", this.select);
        super.validate(decl);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        LetExpression var = new LetExpression();
        var.setVariableQName(new StructuredQName("vv", NamespaceUri.SAXON_GENERATED_VARIABLE, "v" + this.hashCode()));
        var.setSequence(this.select);
        var.setRequiredType(SequenceType.SINGLE_ATOMIC);
        this.switchVar = var;
        Expression choose = super.compile(exec, decl);
        this.switchVar.setAction(choose);
        return this.switchVar;
    }

    @Override
    protected void compileConditions(Compilation exec, ComponentDeclaration decl, Expression[] conditions) {
        int w = 0;
        for (NodeInfo nodeInfo : this.children()) {
            if (nodeInfo instanceof XSLWhen) {
                Expression values = ((XSLWhen)nodeInfo).getCondition();
                conditions[w] = new GeneralComparison20(new LocalVariableReference(this.switchVar), 6, values);
                ++w;
                continue;
            }
            if (!(nodeInfo instanceof XSLOtherwise)) continue;
            Literal otherwise = Literal.makeLiteral(BooleanValue.TRUE);
            otherwise.setRetainedStaticContext(this.makeRetainedStaticContext());
            conditions[w] = otherwise;
            ++w;
        }
    }
}

