/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GYearMonthValue
extends GDateValue {
    private static final Pattern regex = Pattern.compile("(-?[0-9]+-[0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GYearMonthValue(GDateValue.MutableGDateValue m) {
        super(m);
    }

    public static ConversionResult makeGYearMonthValue(UnicodeString value, ConversionRules rules) {
        UnicodeString trimmed = Whitespace.trim(value);
        Matcher m = regex.matcher(trimmed.toString());
        if (!m.matches()) {
            return new ValidationFailure("Cannot convert '" + value + "' to a gYearMonth");
        }
        GDateValue.MutableGDateValue g = new GDateValue.MutableGDateValue();
        String base = m.group(1);
        String tz = m.group(2);
        String date = base + "-01" + (tz == null ? "" : tz);
        g.typeLabel = BuiltInAtomicType.G_YEAR_MONTH;
        GYearMonthValue.setLexicalValue(g, BMPString.of(date), rules.isAllowYearZero());
        return g.error == null ? new GYearMonthValue(g) : g.error;
    }

    public GYearMonthValue(int year, byte month, int tz, boolean xsd10) {
        this(new GDateValue.MutableGDateValue(year, month, 1, xsd10, tz, BuiltInAtomicType.G_YEAR_MONTH));
    }

    public GYearMonthValue(int year, byte month, int tz, AtomicType type) {
        this(new GDateValue.MutableGDateValue(year, month, 1, false, tz, type));
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        GDateValue.MutableGDateValue m = this.makeMutableCopy();
        m.typeLabel = typeLabel;
        return new GYearMonthValue(m);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_YEAR_MONTH;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        UnicodeBuilder sb = new UnicodeBuilder(16);
        int yr = this.year;
        if (this.year <= 0 && (yr = -yr + (this.hasNoYearZero ? 1 : 0)) != 0) {
            sb.append('-');
        }
        GYearMonthValue.appendString(sb, yr, yr > 9999 ? ("" + yr).length() : 4);
        sb.append('-');
        GYearMonthValue.appendTwoDigits(sb, this.month);
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb.toUnicodeString();
    }

    @Override
    public CalendarValue add(DurationValue duration) throws XPathException {
        XPathException err = new XPathException("Cannot add a duration to an xs:gYearMonth");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public CalendarValue adjustTimezone(int tz) {
        DateTimeValue dt = this.toDateTime().adjustTimezone(tz);
        return new GYearMonthValue(dt.getYear(), dt.getMonth(), dt.getTimezoneInMinutes(), this.hasNoYearZero);
    }
}

