/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.HTMLEmitter;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class HTML50Emitter
extends HTMLEmitter {
    private static final byte[] DOCTYPE;

    public HTML50Emitter() {
        this.version = 5;
    }

    @Override
    protected boolean isHTMLElement(NodeName name) {
        NamespaceUri uri = name.getNamespaceUri();
        return uri.isEmpty() || uri.equals(NamespaceUri.XHTML);
    }

    @Override
    protected void openDocument() throws XPathException {
        this.version = 5;
        super.openDocument();
    }

    @Override
    protected void writeDocType(NodeName name, String displayName, String systemId, String publicId) throws XPathException {
        try {
            if (systemId == null && publicId == null) {
                if (name.getLocalPart().equalsIgnoreCase("html")) {
                    this.writer.writeAscii(DOCTYPE);
                }
            } else {
                super.writeDocType(name, displayName, systemId, publicId);
            }
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    @Override
    protected boolean writeDocTypeWithNullSystemId() {
        return true;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (!this.started) {
            this.openDocument();
            String systemId = this.outputProperties.getProperty("doctype-system");
            String publicId = this.outputProperties.getProperty("doctype-public");
            if ("".equals(systemId)) {
                systemId = null;
            }
            if ("".equals(publicId)) {
                publicId = null;
            }
            this.writeDocType(elemName, "html", systemId, publicId);
            this.started = true;
        }
        super.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    protected boolean rejectControlCharacters() {
        return false;
    }

    static {
        HTML50Emitter.setEmptyTag("area");
        HTML50Emitter.setEmptyTag("base");
        HTML50Emitter.setEmptyTag("base");
        HTML50Emitter.setEmptyTag("basefont");
        HTML50Emitter.setEmptyTag("br");
        HTML50Emitter.setEmptyTag("col");
        HTML50Emitter.setEmptyTag("embed");
        HTML50Emitter.setEmptyTag("frame");
        HTML50Emitter.setEmptyTag("hr");
        HTML50Emitter.setEmptyTag("img");
        HTML50Emitter.setEmptyTag("input");
        HTML50Emitter.setEmptyTag("isindex");
        HTML50Emitter.setEmptyTag("keygen");
        HTML50Emitter.setEmptyTag("link");
        HTML50Emitter.setEmptyTag("meta");
        HTML50Emitter.setEmptyTag("param");
        HTML50Emitter.setEmptyTag("source");
        HTML50Emitter.setEmptyTag("track");
        HTML50Emitter.setEmptyTag("wbr");
        DOCTYPE = StringConstants.bytes("<!DOCTYPE HTML>");
    }
}

