/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.UnprefixedElementMatchingPolicy;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class ExpressionContext
implements StaticContext {
    private final StyleElement element;
    private final StructuredQName attributeName;
    private Location containingLocation = null;
    private RetainedStaticContext retainedStaticContext = null;

    public ExpressionContext(StyleElement styleElement, StructuredQName attributeName) {
        this.element = styleElement;
        this.attributeName = attributeName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.element.getConfiguration();
    }

    @Override
    public StylesheetPackage getPackageData() {
        return this.element.getPackageData();
    }

    public boolean isSchemaAware() {
        return this.element.isSchemaAware();
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration());
    }

    @Override
    public RetainedStaticContext makeRetainedStaticContext() {
        if (this.retainedStaticContext == null) {
            this.retainedStaticContext = this.element.changesRetainedStaticContext() || !(this.element.getParent() instanceof StyleElement) ? new RetainedStaticContext(this) : ((StyleElement)this.element.getParent()).getStaticContext().makeRetainedStaticContext();
        }
        return this.retainedStaticContext;
    }

    @Override
    public Location getContainingLocation() {
        if (this.containingLocation == null) {
            this.containingLocation = this.attributeName == null ? this.element : new AttributeLocation(this.element, this.attributeName);
        }
        return this.containingLocation;
    }

    @Override
    public void issueWarning(String s, String errorCode, Location locator) {
        this.element.issueWarning(s, errorCode, locator);
    }

    @Override
    public String getSystemId() {
        return this.element.getSystemId();
    }

    @Override
    public String getStaticBaseURI() {
        return this.element.getBaseURI();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.element.getAllNamespaces();
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        return this.element.getCompilation().getPrincipalStylesheetModule().getDecimalFormatManager();
    }

    @Override
    public OptimizerOptions getOptimizerOptions() {
        return this.element.getCompilation().getCompilerInfo().getOptimizerOptions();
    }

    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        SourceBinding sourceBinding = this.element.bindVariable(qName);
        if (sourceBinding == null) {
            AxisIterator catchers;
            StyleElement catcher;
            if (qName.hasURI(NamespaceUri.XSLT) && qName.getLocalPart().equals("original")) {
                this.element.getXslOriginal(218);
                return new GlobalVariableReference(qName);
            }
            SymbolicName sn = new SymbolicName(218, qName);
            Component comp = this.element.getCompilation().getPrincipalStylesheetModule().getComponent(sn);
            if (comp != null) {
                SequenceTool.supply(this.element.iterateAxis(1), parent -> {
                    if (parent instanceof XSLGlobalVariable && ((XSLGlobalVariable)parent).getVariableQName().equals(qName)) {
                        XPathException err = new XPathException("Variable " + qName.getDisplayName() + " cannot be used within its own declaration", "XPST0008");
                        err.setIsStaticError(true);
                        throw err;
                    }
                });
                GlobalVariable globalVar = (GlobalVariable)comp.getActor();
                GlobalVariableReference vref = new GlobalVariableReference(globalVar);
                vref.setStaticType(globalVar.getRequiredType(), null, 0);
                return vref;
            }
            if (this.getXPathVersion() >= 30 && qName.hasURI(NamespaceUri.ERR) && (catcher = (StyleElement)(catchers = this.element.iterateAxis(1, new NameTest(1, 141, this.element.getNamePool()))).next()) != null) {
                for (StructuredQName errorVariable : StandardNames.errorVariables) {
                    if (!errorVariable.getLocalPart().equals(qName.getLocalPart())) continue;
                    SystemFunction f = VendorFunctionSetHE.getInstance().makeFunction("dynamic-error-info", 1);
                    return f.makeFunctionCall(new StringLiteral(qName.getLocalPart()));
                }
            }
            XPathException error = new XPathException("Variable " + qName.getDisplayName() + " has not been declared (or its declaration is not in scope)", "XPST0008");
            error.setIsStaticError(true);
            throw error;
        }
        if (sourceBinding.hasProperty(SourceBinding.BindingProperty.IMPLICITLY_DECLARED)) {
            SuppliedParameterReference supRef = new SuppliedParameterReference(0);
            supRef.setSuppliedType(sourceBinding.getDeclaredType());
            return supRef;
        }
        if (sourceBinding.hasProperty(SourceBinding.BindingProperty.GLOBAL)) {
            GlobalVariableReference var = new GlobalVariableReference(qName);
            GlobalVariable compiledVar = ((XSLGlobalVariable)sourceBinding.getSourceElement()).getCompiledVariable();
            if (compiledVar != null && this.element.getCompilation().getCompilerInfo().isJustInTimeCompilation()) {
                var.fixup(compiledVar);
                var.setStaticType(compiledVar.getRequiredType(), sourceBinding.getConstantValue(), 0);
            } else {
                sourceBinding.registerReference(var);
            }
            return var;
        }
        LocalVariableReference var = new LocalVariableReference(qName);
        sourceBinding.registerReference(var);
        return var;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.element.getContainingPackage().getFunctionLibrary();
    }

    @Override
    public String getDefaultCollationName() {
        return this.element.getDefaultCollationName();
    }

    @Override
    public NamespaceUri getDefaultElementNamespace() {
        return this.element.getDefaultXPathNamespace();
    }

    @Override
    public NamespaceUri getDefaultFunctionNamespace() {
        return NamespaceUri.FN;
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return this.element.xPath10ModeIsEnabled();
    }

    @Override
    public int getXPathVersion() {
        if (this.element.getEffectiveVersion() == 40 || this.element.getCompilation().getCompilerInfo().getXsltVersion() == 40 || this.attributeName != null && this.attributeName.hasURI(NamespaceUri.SAXON)) {
            return 40;
        }
        return this.getConfiguration().getConfigurationProperty(Feature.XPATH_VERSION_FOR_XSLT);
    }

    @Override
    public boolean isImportedSchema(NamespaceUri namespace) {
        return this.element.getPrincipalStylesheetModule().isImportedSchema(namespace);
    }

    @Override
    public Set<NamespaceUri> getImportedSchemaNamespaces() {
        return this.element.getPrincipalStylesheetModule().getImportedSchemaTable();
    }

    @Override
    public KeyManager getKeyManager() {
        return this.element.getCompilation().getPrincipalStylesheetModule().getKeyManager();
    }

    public StyleElement getStyleElement() {
        return this.element;
    }

    @Override
    public ItemType resolveTypeAlias(StructuredQName typeName) {
        return this.getPackageData().obtainTypeAliasManager().getItemType(typeName);
    }

    @Override
    public UnprefixedElementMatchingPolicy getUnprefixedElementMatchingPolicy() {
        return this.element.getCompilation().getCompilerInfo().getUnprefixedElementMatchingPolicy();
    }
}

