/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj;

import com.saxonica.xqj.Closable;
import com.saxonica.xqj.SaxonXQDataFactory;
import com.saxonica.xqj.SaxonXQItem;
import com.saxonica.xqj.SaxonXQItemAccessor;
import com.saxonica.xqj.SaxonXQPreparedExpression;
import com.saxonica.xqj.pull.PullFromIterator;
import com.saxonica.xqj.pull.PullToStax;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQResultSequence;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQSequence
extends Closable
implements XQResultSequence,
SaxonXQItemAccessor {
    private final GroundedValue value;
    private int position;
    private SaxonXQPreparedExpression expression;
    private final SaxonXQDataFactory factory;

    SaxonXQSequence(GroundedValue value, SaxonXQDataFactory factory) {
        this.value = value;
        this.factory = factory;
        this.setClosableContainer(factory);
    }

    SaxonXQSequence(GroundedValue value, SaxonXQPreparedExpression expression) {
        this.value = value;
        this.expression = expression;
        this.factory = expression.getConnection();
        this.setClosableContainer(expression);
    }

    GroundedValue getValue() {
        return this.value;
    }

    Configuration getConfiguration() {
        return this.factory.getConfiguration();
    }

    @Override
    public boolean absolute(int itempos) throws XQException {
        this.checkNotClosed();
        if (itempos > 0) {
            if (itempos <= this.value.getLength()) {
                this.position = itempos;
                return true;
            }
            this.position = -1;
            return false;
        }
        if (itempos < 0) {
            if (-itempos <= this.value.getLength()) {
                this.position = this.value.getLength() + itempos + 1;
                return true;
            }
            this.position = 0;
            return false;
        }
        this.position = 0;
        return false;
    }

    @Override
    public void afterLast() throws XQException {
        this.checkNotClosed();
        this.position = -1;
    }

    @Override
    public void beforeFirst() throws XQException {
        this.checkNotClosed();
        this.position = 0;
    }

    @Override
    public int count() throws XQException {
        this.checkNotClosed();
        return this.value.getLength();
    }

    @Override
    public boolean first() throws XQException {
        this.checkNotClosed();
        if (this.value.getLength() == 0) {
            this.position = 0;
            return false;
        }
        this.position = 1;
        return true;
    }

    @Override
    public XQItem getItem() throws XQException {
        this.checkNotClosed();
        SaxonXQItem item = new SaxonXQItem(this.value.itemAt(this.position - 1), this.factory);
        item.setClosableContainer(this);
        return item;
    }

    @Override
    public Item getSaxonItem() {
        return this.value.itemAt(this.position - 1);
    }

    @Override
    public int getPosition() throws XQException {
        this.checkNotClosed();
        if (this.position >= 0) {
            return this.position;
        }
        return this.value.getLength() + 1;
    }

    @Override
    public XMLStreamReader getSequenceAsStream() throws XQException {
        this.checkNotClosed();
        PullFromIterator provider = new PullFromIterator(this.iterateRemainder());
        provider.setPipelineConfiguration(this.getConfiguration().makePipelineConfiguration());
        return new PullToStax((PullProvider)provider);
    }

    @Override
    public String getSequenceAsString(Properties props) throws XQException {
        this.checkNotClosed();
        StringWriter sw = new StringWriter();
        this.writeSequence(sw, props);
        return sw.toString();
    }

    @Override
    public boolean isAfterLast() throws XQException {
        this.checkNotClosed();
        return this.position < 0;
    }

    @Override
    public boolean isBeforeFirst() throws XQException {
        this.checkNotClosed();
        return this.position == 0 && this.value.getLength() != 0;
    }

    @Override
    public boolean isFirst() throws XQException {
        this.checkNotClosed();
        return this.position == 1;
    }

    @Override
    public boolean isLast() throws XQException {
        this.checkNotClosed();
        return this.position == this.value.getLength();
    }

    @Override
    public boolean isOnItem() throws XQException {
        this.checkNotClosed();
        return this.position >= 1;
    }

    @Override
    public boolean isScrollable() throws XQException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public boolean last() throws XQException {
        this.checkNotClosed();
        int n = this.value.getLength();
        if (n == 0) {
            this.position = -1;
            return false;
        }
        this.position = n;
        return true;
    }

    @Override
    public boolean next() throws XQException {
        this.checkNotClosed();
        if (this.position == this.value.getLength()) {
            this.position = -1;
            return false;
        }
        ++this.position;
        return true;
    }

    @Override
    public boolean previous() throws XQException {
        this.checkNotClosed();
        if (this.position == -1) {
            return this.last();
        }
        --this.position;
        return this.position != 0;
    }

    @Override
    public boolean relative(int itempos) throws XQException {
        this.checkNotClosed();
        if (this.position == -1) {
            this.position = this.value.getLength() + 1;
        }
        this.position += itempos;
        if (this.position <= 0) {
            this.position = 0;
            return false;
        }
        if (this.position > this.value.getLength()) {
            this.position = -1;
            return false;
        }
        return true;
    }

    @Override
    public void writeSequence(OutputStream os, Properties props) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(os);
        if (props == null) {
            props = new Properties();
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        try {
            QueryResult.serializeSequence((SequenceIterator)this.iterateRemainder(), (Configuration)this.getConfiguration(), (OutputStream)os, (Properties)props);
            this.position = -1;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    @Override
    public void writeSequence(Writer ow, Properties props) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(ow);
        if (props == null) {
            props = new Properties();
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        try {
            PrintWriter pw = ow instanceof PrintWriter ? (PrintWriter)ow : new PrintWriter(ow);
            QueryResult.serializeSequence((SequenceIterator)this.iterateRemainder(), (Configuration)this.getConfiguration(), (Writer)pw, (Properties)props);
            this.position = -1;
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    @Override
    public void writeSequenceToResult(Result result) throws XQException {
        this.checkNotClosed();
        Properties props = SaxonXQSequence.setDefaultProperties(null);
        try {
            QueryResult.serializeSequence((SequenceIterator)this.iterateRemainder(), (Configuration)this.getConfiguration(), (Result)result, (Properties)props);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    @Override
    public void writeSequenceToSAX(ContentHandler saxHandler) throws XQException {
        this.checkNotClosed();
        this.writeSequenceToResult(new SAXResult(saxHandler));
    }

    @Override
    public String getAtomicValue() throws XQException {
        return this.getCurrentItem().getAtomicValue();
    }

    @Override
    public boolean getBoolean() throws XQException {
        return this.getCurrentItem().getBoolean();
    }

    @Override
    public byte getByte() throws XQException {
        return this.getCurrentItem().getByte();
    }

    @Override
    public double getDouble() throws XQException {
        return this.getCurrentItem().getDouble();
    }

    @Override
    public float getFloat() throws XQException {
        return this.getCurrentItem().getFloat();
    }

    @Override
    public int getInt() throws XQException {
        return this.getCurrentItem().getInt();
    }

    @Override
    public XMLStreamReader getItemAsStream() throws XQException {
        return this.getCurrentItem().getItemAsStream();
    }

    @Override
    public String getItemAsString(Properties props) throws XQException {
        return this.getCurrentItem().getItemAsString(props);
    }

    @Override
    public XQItemType getItemType() throws XQException {
        return this.getCurrentItem().getItemType();
    }

    @Override
    public long getLong() throws XQException {
        return this.getCurrentItem().getLong();
    }

    @Override
    public Node getNode() throws XQException {
        return this.getCurrentItem().getNode();
    }

    @Override
    public URI getNodeUri() throws XQException {
        return this.getCurrentItem().getNodeUri();
    }

    @Override
    public Object getObject() throws XQException {
        return this.getCurrentItem().getObject();
    }

    @Override
    public short getShort() throws XQException {
        return this.getCurrentItem().getShort();
    }

    @Override
    public boolean instanceOf(XQItemType type) throws XQException {
        return this.getCurrentItem().instanceOf(type);
    }

    @Override
    public void writeItem(OutputStream os, Properties props) throws XQException {
        this.getCurrentItem().writeItem(os, props);
    }

    @Override
    public void writeItem(Writer ow, Properties props) throws XQException {
        this.getCurrentItem().writeItem(ow, props);
    }

    @Override
    public void writeItemToResult(Result result) throws XQException {
        this.getCurrentItem().writeItemToResult(result);
    }

    @Override
    public void writeItemToSAX(ContentHandler saxHandler) throws XQException {
        this.getCurrentItem().writeItemToSAX(saxHandler);
    }

    private SaxonXQItem getCurrentItem() throws XQException {
        this.checkNotClosed();
        if (this.position == 0) {
            throw new XQException("Sequence is positioned before first item");
        }
        if (this.position < 0) {
            throw new XQException("Sequence is positioned after last item");
        }
        SaxonXQItem item = new SaxonXQItem(this.value.itemAt(this.position - 1), this.factory);
        item.setClosableContainer(this);
        return item;
    }

    @Override
    public XQConnection getConnection() throws XQException {
        this.checkNotClosed();
        if (this.expression == null) {
            throw new IllegalStateException("Connection not available");
        }
        return this.expression.getConnection();
    }

    private SequenceIterator iterateRemainder() throws XQException {
        try {
            if (this.position == 0) {
                return this.value.iterate();
            }
            if (this.position < 0) {
                return EmptyIterator.getInstance();
            }
            return TailIterator.make((SequenceIterator)this.value.iterate(), (int)this.position);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    private void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }

    private XQException newXQException(Exception err) {
        XQException xqe = new XQException(err.getMessage());
        xqe.initCause(err);
        return xqe;
    }

    static Properties setDefaultProperties(Properties props) {
        Properties newProps = props == null ? new Properties() : new Properties(props);
        boolean changed = false;
        if (newProps.getProperty("method") == null) {
            newProps.setProperty("method", "xml");
            changed = true;
        }
        if (newProps.getProperty("indent") == null) {
            newProps.setProperty("indent", "yes");
            changed = true;
        }
        if (newProps.getProperty("omit-xml-declaration") == null) {
            newProps.setProperty("omit-xml-declaration", "yes");
            changed = true;
        }
        return changed || props == null ? newProps : props;
    }
}

