/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.DigestMaker;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class CheckSumFilter
extends ProxyReceiver {
    private static final boolean DEBUG = false;
    private DigestMaker digest = new DigestMaker();
    private int checksum = 0;
    private int sequence = 0;
    private boolean checkExistingChecksum = false;
    private boolean checksumCorrect = false;
    private boolean checksumFound = false;
    private boolean digestCorrect = false;
    private boolean digestFound = false;
    private boolean requireDigest = false;
    private boolean rootElement = true;
    private int depth = 0;
    private String target = "unknown";
    public static final String SIGMA = "\u03a3";
    public static final String SIGMA2 = "\u03a32";

    public CheckSumFilter(Receiver nextReceiver) {
        super(nextReceiver);
    }

    public void setCheckExistingChecksum(boolean check) {
        this.checkExistingChecksum = check;
    }

    private static void trace(String message) {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        CheckSumFilter.trace("CHECKSUM - START DOC");
        super.startDocument(properties);
    }

    @Override
    public void endDocument() throws XPathException {
        CheckSumFilter.trace("\u03a3 ::= " + Integer.toHexString(this.checksum));
        this.nextReceiver.endDocument();
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        this.checksum ^= this.hash(item.toString(), this.sequence++);
        CheckSumFilter.trace("After append: " + Integer.toHexString(this.checksum));
        super.append(item, locationId, copyNamespaces);
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (!Whitespace.isAllWhite(chars)) {
            this.checksum ^= this.hash(chars.toString(), this.sequence++);
            CheckSumFilter.trace("After characters " + String.valueOf(chars) + ": " + Integer.toHexString(this.checksum));
        }
        super.characters(chars, locationId, properties);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.checksum ^= this.hash(elemName, this.sequence++);
        CheckSumFilter.trace("After startElement " + elemName.getDisplayName() + ": " + this.checksum);
        this.checksumCorrect = false;
        ++this.depth;
        if (this.rootElement) {
            this.rootElement = false;
            boolean scm_schema = elemName.getNamespaceUri() == NamespaceUri.of("http://ns.saxonica.com/schema-component-model") && "schema".equals(elemName.getLocalPart());
            String version = attributes.getValue("saxonVersion");
            boolean bl = this.requireDigest = version == null && !scm_schema;
            if (version != null) {
                String minorVersion = "x";
                int dpos = version.indexOf(46);
                if (dpos > 0) {
                    minorVersion = version.substring(dpos + 1);
                    version = version.substring(0, dpos);
                }
                try {
                    int majorVersion = Integer.parseInt(version);
                    if (majorVersion > 12) {
                        this.requireDigest = true;
                    } else if (majorVersion == 12) {
                        this.requireDigest = Integer.parseInt(minorVersion) >= 5;
                    }
                }
                catch (NumberFormatException e) {
                    this.requireDigest = true;
                }
            }
            this.target = attributes.getValue("target");
            if (this.target == null) {
                this.target = "unknown";
            }
        }
        HashMap<CallSite, NodeName> namemap = new HashMap<CallSite, NodeName>();
        HashMap<CallSite, String> attrmap = new HashMap<CallSite, String>();
        Object[] names = new String[attributes.size()];
        int index = 0;
        for (AttributeInfo att : attributes) {
            String key = att.getNodeName().getLocalPart() + String.valueOf(att.getNodeName().getNamespaceUri());
            attrmap.put((CallSite)((Object)key), att.getValue());
            namemap.put((CallSite)((Object)key), att.getNodeName());
            names[index++] = key;
        }
        Arrays.sort(names);
        for (Object key : names) {
            NodeName name = (NodeName)namemap.get(key);
            String value = (String)attrmap.get(key);
            this.checksum ^= this.hash(name, this.sequence);
            CheckSumFilter.trace("After attribute name " + name.getDisplayName() + ": " + this.checksum);
            this.checksum ^= this.hash(value, this.sequence);
            CheckSumFilter.trace("After attribute value " + name.getDisplayName() + ": " + this.checksum);
        }
        super.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    public void endElement() throws XPathException {
        --this.depth;
        if (this.depth == 0 && this.target.startsWith("JS")) {
            String sigma2Hash = this.getDigest();
            this.checksum ^= this.hash(SIGMA2, 1);
            this.checksum ^= this.hash("", 1);
            this.checksum ^= this.hash(sigma2Hash, 1);
            CheckSumFilter.trace("After SIGMA2: " + this.checksum);
        }
        this.checksum ^= 1;
        CheckSumFilter.trace("After endElement: " + this.checksum);
        super.endElement();
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        if (target.equals(SIGMA)) {
            this.checksumFound = true;
            if (this.checkExistingChecksum) {
                try {
                    int found = (int)Long.parseLong("0" + String.valueOf(data), 16);
                    this.checksumCorrect = found == this.checksum;
                }
                catch (NumberFormatException e) {
                    this.checksumCorrect = false;
                }
                if (data.toString().equals(this.getDigest())) {
                    this.digestFound = true;
                    this.digestCorrect = true;
                    this.checksumCorrect = true;
                }
            }
        }
        if (target.equals(SIGMA2)) {
            this.digestFound = true;
            if (this.checkExistingChecksum) {
                this.digestCorrect = data.toString().equals(this.getDigest());
            }
        }
        super.processingInstruction(target, data, locationId, properties);
    }

    public boolean isChecksumFound() {
        return this.checksumFound;
    }

    public boolean isDigestFound() {
        return this.digestFound;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public String getDigest() {
        return this.digest.getDigest();
    }

    public boolean isChecksumCorrect() {
        if (this.requireDigest && !this.digestCorrect) {
            return false;
        }
        return this.checksumCorrect || "skip".equals(System.getProperty("saxon-checksum"));
    }

    private int hash(String s, int sequence) {
        this.digest.update(sequence);
        this.digest.update(s);
        int h = sequence << 8;
        for (int i = 0; i < s.length(); ++i) {
            h = (h << 1) + s.charAt(i);
        }
        return h;
    }

    private int hash(NodeName n, int sequence) {
        return this.hash(n.getLocalPart(), sequence) ^ this.hash(n.getNamespaceUri().toString(), sequence);
    }
}

