/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.function.Supplier;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.ComplexNodePushElaborator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class ComputedElement
extends ElementCreator {
    private final Operand nameOp;
    private Operand namespaceOp;
    private final boolean allowNameAsQName;
    private ItemType itemType;

    public ComputedElement(Expression elementName, Expression namespace, SchemaType schemaType, int validation, boolean inheritNamespaces, boolean allowQName) {
        this.nameOp = new Operand(this, elementName, OperandRole.SINGLE_ATOMIC);
        if (namespace != null) {
            this.namespaceOp = new Operand(this, namespace, OperandRole.SINGLE_ATOMIC);
        }
        this.setValidationAction(validation, schemaType);
        this.preservingTypes = schemaType == null && validation == 3;
        this.bequeathNamespacesToChildren = inheritNamespaces;
        this.allowNameAsQName = allowQName;
    }

    public Expression getNameExp() {
        return this.nameOp.getChildExpression();
    }

    public Expression getNamespaceExp() {
        return this.namespaceOp == null ? null : this.namespaceOp.getChildExpression();
    }

    protected void setNameExp(Expression elementName) {
        this.nameOp.setChildExpression(elementName);
    }

    protected void setNamespaceExp(Expression namespace) {
        if (this.namespaceOp == null) {
            this.namespaceOp = new Operand(this, namespace, OperandRole.SINGLE_ATOMIC);
        } else {
            this.namespaceOp.setChildExpression(namespace);
        }
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandSparseList(this.contentOp, this.nameOp, this.namespaceOp);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    @Override
    public Expression simplify() throws XPathException {
        this.setNameExp(this.getNameExp().simplify());
        if (this.getNamespaceExp() != null) {
            this.setNamespaceExp(this.getNamespaceExp().simplify());
        }
        Configuration config = this.getConfiguration();
        boolean schemaAware = this.getPackageData().isSchemaAware();
        this.preservingTypes |= !schemaAware;
        SchemaType schemaType = this.getSchemaType();
        if (schemaType != null) {
            this.itemType = new ContentTypeTest(1, schemaType, config, false);
            schemaType.analyzeContentExpression(this.getContentExpression(), 1);
        } else {
            this.itemType = this.getValidationAction() == 4 || !schemaAware ? new ContentTypeTest(1, Untyped.getInstance(), config, false) : NodeKindTest.ELEMENT;
        }
        return super.simplify();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        super.typeCheck(visitor, contextInfo);
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (this.allowNameAsQName) {
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(4, "element/name", 0);
            this.setNameExp(config.getTypeChecker(false).staticTypeCheck(this.getNameExp(), SequenceType.SINGLE_ATOMIC, role, visitor));
            ItemType supplied = this.getNameExp().getItemType();
            if (th.relationship(supplied, BuiltInAtomicType.STRING) == Affinity.DISJOINT && th.relationship(supplied, BuiltInAtomicType.UNTYPED_ATOMIC) == Affinity.DISJOINT && th.relationship(supplied, BuiltInAtomicType.QNAME) == Affinity.DISJOINT) {
                throw new XPathException("The name of a constructed element must be a string, QName, or untypedAtomic").withErrorCode("XPTY0004").asTypeError().withLocation(this.getLocation());
            }
        } else if (!th.isSubType(this.getNameExp().getItemType(), BuiltInAtomicType.STRING)) {
            this.setNameExp(SystemFunction.makeCall("string", this.getRetainedStaticContext(), this.getNameExp()));
        }
        if (Literal.isAtomic(this.getNameExp())) {
            try {
                AtomicValue val = (AtomicValue)((Literal)this.getNameExp()).getGroundedValue();
                if (val instanceof StringValue) {
                    String[] parts = NameChecker.checkQNameParts(val.getStringValue());
                    if (this.getNamespaceExp() == null) {
                        String prefix = parts[0];
                        NamespaceUri uri = this.getNamespaceResolver().getURIForPrefix(prefix, true);
                        if (uri == null) {
                            throw new XPathException("Prefix " + prefix + " has not been declared").withErrorCode("XPST0081").asStaticError();
                        }
                        this.setNamespaceExp(new StringLiteral(uri.toString()));
                    }
                }
            }
            catch (XPathException e) {
                throw e.maybeWithErrorCode(this.isXSLT() ? "XTDE0820" : "XQDY0074").replacingErrorCode("FORG0001", this.isXSLT() ? "XTDE0820" : "XQDY0074").replacingErrorCode("XPST0081", this.isXSLT() ? "XTDE0830" : "XQDY0074").maybeWithLocation(this.getLocation()).asStaticError();
            }
        }
        return super.typeCheck(visitor, contextInfo);
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ComputedElement ce = new ComputedElement(this.getNameExp().copy(rebindings), this.getNamespaceExp() == null ? null : this.getNamespaceExp().copy(rebindings), this.getSchemaType(), this.getValidationAction(), this.bequeathNamespacesToChildren, this.allowNameAsQName);
        ExpressionTool.copyLocationInfo(this, ce);
        ce.setContentExpression(this.getContentExpression().copy(rebindings));
        return ce;
    }

    @Override
    public ItemType getItemType() {
        if (this.itemType == null) {
            return super.getItemType();
        }
        return this.itemType;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        if (parentType instanceof SimpleType || ((ComplexType)parentType).isSimpleContent()) {
            Object msg = "Elements are not permitted here: the containing element ";
            msg = parentType instanceof SimpleType ? (parentType.isAnonymousType() ? (String)msg + "is defined to have a simple type" : (String)msg + "is of simple type " + parentType.getDescription()) : (String)msg + "has a complex type with simple content";
            throw new XPathException((String)msg).asTypeError().withLocation(this.getLocation());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NodeName getElementName(XPathContext context) throws XPathException {
        XPathException err;
        String errorCode;
        String localName;
        String prefix;
        NamespaceUri uri;
        block25: {
            AtomicValue nameValue;
            block24: {
                Controller controller = context.getController();
                assert (controller != null);
                uri = null;
                nameValue = (AtomicValue)this.getNameExp().evaluateItem(context);
                if (nameValue == null) {
                    String errorCode2 = this.isXSLT() ? "XTDE0820" : "XPTY0004";
                    XPathException err1 = new XPathException("Invalid element name (empty sequence)", errorCode2, this.getLocation());
                    throw ComputedElement.dynamicError(this.getLocation(), err1, context);
                }
                if (!(nameValue instanceof StringValue)) break block24;
                String rawName = nameValue.getStringValue();
                if ((rawName = Whitespace.trim(rawName)).startsWith("Q{") && this.allowNameAsQName) {
                    try {
                        StructuredQName qn = StructuredQName.fromEQName(rawName);
                        prefix = "";
                        localName = qn.getLocalPart();
                        uri = qn.getNamespaceUri();
                    }
                    catch (IllegalArgumentException e) {
                        throw new XPathException("Invalid EQName in computed element constructor: " + e.getMessage(), "XQDY0074");
                    }
                    if (!NameChecker.isValidNCName(localName)) {
                        throw new XPathException("Local part of EQName in computed element constructor is invalid", "XQDY0074");
                    }
                    break block25;
                } else {
                    try {
                        String[] parts = NameChecker.getQNameParts(rawName);
                        prefix = parts[0];
                        localName = parts[1];
                    }
                    catch (QNameException err2) {
                        Object message = "Invalid element name. " + err2.getMessage();
                        if (rawName.length() == 0) {
                            message = "Supplied element name is a zero-length string";
                        }
                        String errorCode3 = this.isXSLT() ? "XTDE0820" : "XQDY0074";
                        XPathException err1 = new XPathException((String)message, errorCode3, this.getLocation());
                        throw ComputedElement.dynamicError(this.getLocation(), err1, context);
                    }
                }
            }
            if (nameValue instanceof QNameValue && this.allowNameAsQName) {
                localName = ((QNameValue)nameValue).getLocalName();
                uri = ((QNameValue)nameValue).getNamespaceURI();
                prefix = ((QNameValue)nameValue).getPrefix();
                if (prefix.equals("xmlns")) {
                    XPathException err3 = new XPathException("Computed element name has prefix xmlns", "XQDY0096", this.getLocation());
                    throw ComputedElement.dynamicError(this.getLocation(), err3, context);
                }
            } else {
                String errorCode4 = this.isXSLT() ? "XTDE0820" : "XPTY0004";
                XPathException err4 = new XPathException("Computed element name has incorrect type", errorCode4, this.getLocation());
                err4.setIsTypeError(true);
                throw ComputedElement.dynamicError(this.getLocation(), err4, context);
            }
        }
        if (this.getNamespaceExp() == null && uri == null) {
            uri = this.getRetainedStaticContext().getURIForPrefix(prefix, true);
            if (uri == null) {
                errorCode = this.isXSLT() ? "XTDE0830" : (prefix.equals("xmlns") ? "XQDY0096" : "XQDY0074");
                err = new XPathException("Undeclared prefix in element name: " + prefix, errorCode, this.getLocation());
                throw ComputedElement.dynamicError(this.getLocation(), err, context);
            }
        } else {
            if (uri == null) {
                if (this.getNamespaceExp() instanceof StringLiteral) {
                    uri = NamespaceUri.of(((StringLiteral)this.getNamespaceExp()).stringify());
                } else {
                    uri = NamespaceUri.of(this.getNamespaceExp().evaluateAsString(context).toString());
                    if (!StandardURIChecker.getInstance().isValidURI(uri.toString())) {
                        XPathException de = new XPathException("The value of the namespace attribute must be a valid URI", "XTDE0835", this.getLocation());
                        throw ComputedElement.dynamicError(this.getLocation(), de, context);
                    }
                }
            }
            if (uri.isEmpty()) {
                prefix = "";
            }
            if (prefix.equals("xmlns")) {
                prefix = "x-xmlns";
            }
        }
        if (uri.equals(NamespaceUri.XMLNS)) {
            errorCode = this.isXSLT() ? "XTDE0835" : "XQDY0096";
            err = new XPathException("Cannot create element in namespace " + String.valueOf(uri), errorCode, this.getLocation());
            throw ComputedElement.dynamicError(this.getLocation(), err, context);
        }
        if (uri.equals(NamespaceUri.XML) == prefix.equals("xml")) {
            return new FingerprintedQName(prefix, uri, localName);
        }
        String message = prefix.equals("xml") ? "When the prefix is 'xml', the namespace URI must be http://www.w3.org/XML/1998/namespace" : "When the namespace URI is http://www.w3.org/XML/1998/namespace, the prefix must be 'xml'";
        String errorCode5 = this.isXSLT() ? "XTDE0835" : "XQDY0096";
        XPathException err5 = new XPathException(message, errorCode5, this.getLocation());
        throw ComputedElement.dynamicError(this.getLocation(), err5, context);
    }

    public boolean isAllowNameAsQName() {
        return this.allowNameAsQName;
    }

    @Override
    public ElementCreator.ElementCreationDetails makeElementCreationDetails() {
        return new ElementCreator.ElementCreationDetails(){

            @Override
            public NodeName getNodeName(XPathContext context) throws XPathException {
                return ComputedElement.this.getElementName(context);
            }

            @Override
            public String getSystemId(XPathContext context) {
                return ComputedElement.this.getStaticBaseURIString();
            }

            @Override
            public void processContent(Outputter outputter, XPathContext context) throws XPathException {
                ComputedElement.this.getContentExpression().process(outputter, context);
            }
        };
    }

    @Override
    public void outputNamespaceNodes(Outputter out, NodeName nodeName, ElementCreator.ElementCreationDetails details) throws XPathException {
    }

    @Override
    public int getInstructionNameCode() {
        return 151;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("compElem", this);
        Object flags = this.getInheritanceFlags();
        if (this.isLocal()) {
            flags = (String)flags + "l";
        }
        if (!((String)flags).isEmpty()) {
            out.emitAttribute("flags", (String)flags);
        }
        this.exportValidationAndType(out);
        out.setChildRole("name");
        this.getNameExp().export(out);
        if (this.getNamespaceExp() != null) {
            out.setChildRole("namespace");
            this.getNamespaceExp().export(out);
        }
        out.setChildRole("content");
        this.getContentExpression().export(out);
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new ComputedElementElaborator();
    }

    public static class ComputedElementElaborator
    extends ComplexNodePushElaborator {
        @Override
        public PushEvaluator elaborateForPush() {
            ComputedElement expr = (ComputedElement)this.getExpression();
            boolean isXsltInstruction = expr.isXSLT();
            PushEvaluator contentPusher = expr.getContentExpression().makeElaborator().elaborateForPush();
            StringEvaluator namespaceEvaluator = expr.getNamespaceExp() == null ? null : expr.getNamespaceExp().makeElaborator().elaborateForString(true);
            ItemEvaluator localNameEvaluator = expr.getNameExp().makeElaborator().elaborateForItem();
            ItemEvaluator nodeNameEvaluator = context -> {
                XPathException err;
                String errorCode;
                String localName;
                String prefix;
                NamespaceUri uri;
                block23: {
                    AtomicValue nameValue;
                    block22: {
                        Controller controller = context.getController();
                        assert (controller != null);
                        uri = null;
                        nameValue = (AtomicValue)localNameEvaluator.eval(context);
                        if (nameValue == null) {
                            String errorCode2 = isXsltInstruction ? "XTDE0820" : "XPTY0004";
                            XPathException err1 = new XPathException("Invalid element name (empty sequence)", errorCode2, expr.getLocation());
                            throw Instruction.dynamicError(expr.getLocation(), err1, context);
                        }
                        if (!(nameValue instanceof StringValue)) break block22;
                        String rawName = nameValue.getStringValue();
                        if ((rawName = Whitespace.trim(rawName)).startsWith("Q{") && expr.allowNameAsQName) {
                            try {
                                StructuredQName qn = StructuredQName.fromEQName(rawName);
                                prefix = "";
                                localName = qn.getLocalPart();
                                uri = qn.getNamespaceUri();
                            }
                            catch (IllegalArgumentException e) {
                                throw new XPathException("Invalid EQName in computed element constructor: " + e.getMessage(), "XQDY0074");
                            }
                            if (!NameChecker.isValidNCName(localName)) {
                                throw new XPathException("Local part of EQName in computed element constructor is invalid", "XQDY0074");
                            }
                            break block23;
                        } else {
                            try {
                                String[] parts = NameChecker.getQNameParts(rawName);
                                prefix = parts[0];
                                localName = parts[1];
                            }
                            catch (QNameException err2) {
                                Object message = "Invalid element name. " + err2.getMessage();
                                if (rawName.length() == 0) {
                                    message = "Supplied element name is a zero-length string";
                                }
                                String errorCode3 = isXsltInstruction ? "XTDE0820" : "XQDY0074";
                                XPathException err1 = new XPathException((String)message, errorCode3, expr.getLocation());
                                throw Instruction.dynamicError(expr.getLocation(), err1, context);
                            }
                        }
                    }
                    if (nameValue instanceof QNameValue && expr.allowNameAsQName) {
                        localName = ((QNameValue)nameValue).getLocalName();
                        uri = ((QNameValue)nameValue).getNamespaceURI();
                        prefix = ((QNameValue)nameValue).getPrefix();
                        if (prefix.equals("xmlns")) {
                            XPathException err3 = new XPathException("Computed element name has prefix xmlns", "XQDY0096", expr.getLocation());
                            throw Instruction.dynamicError(expr.getLocation(), err3, context);
                        }
                    } else {
                        String errorCode4 = isXsltInstruction ? "XTDE0820" : "XPTY0004";
                        XPathException err4 = new XPathException("Computed element name has incorrect type", errorCode4, expr.getLocation());
                        err4.setIsTypeError(true);
                        throw Instruction.dynamicError(expr.getLocation(), err4, context);
                    }
                }
                if (namespaceEvaluator == null && uri == null) {
                    uri = expr.getRetainedStaticContext().getURIForPrefix(prefix, true);
                    if (uri == null) {
                        errorCode = isXsltInstruction ? "XTDE0830" : (prefix.equals("xmlns") ? "XQDY0096" : "XQDY0074");
                        err = new XPathException("Undeclared prefix in element name: " + prefix, errorCode, expr.getLocation());
                        throw Instruction.dynamicError(expr.getLocation(), err, context);
                    }
                } else {
                    if (uri == null) {
                        String nsUri = namespaceEvaluator.eval(context);
                        uri = NamespaceUri.of(nsUri);
                        if (!StandardURIChecker.getInstance().isValidURI(uri.toString())) {
                            XPathException de = new XPathException("The value of the namespace attribute must be a valid URI", "XTDE0835", expr.getLocation());
                            throw Instruction.dynamicError(expr.getLocation(), de, context);
                        }
                    }
                    if (uri.isEmpty()) {
                        prefix = "";
                    }
                    if (prefix.equals("xmlns")) {
                        prefix = "x-xmlns";
                    }
                }
                if (uri.equals(NamespaceUri.XMLNS)) {
                    errorCode = isXsltInstruction ? "XTDE0835" : "XQDY0096";
                    err = new XPathException("Cannot create element in namespace " + String.valueOf(uri), errorCode, expr.getLocation());
                    throw Instruction.dynamicError(expr.getLocation(), err, context);
                }
                if (uri.equals(NamespaceUri.XML) == prefix.equals("xml")) {
                    return new QNameValue(prefix, uri, localName);
                }
                String message = prefix.equals("xml") ? "When the prefix is 'xml', the namespace URI must be http://www.w3.org/XML/1998/namespace" : "When the namespace URI is http://www.w3.org/XML/1998/namespace, the prefix must be 'xml'";
                String errorCode5 = isXsltInstruction ? "XTDE0835" : "XQDY0096";
                XPathException err5 = new XPathException(message, errorCode5, expr.getLocation());
                throw Instruction.dynamicError(expr.getLocation(), err5, context);
            };
            Enum typeCode = expr.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
            return (arg_0, arg_1) -> ComputedElementElaborator.lambda$elaborateForPush$1(nodeNameEvaluator, expr, (SchemaType)((Object)typeCode), contentPusher, arg_0, arg_1);
        }

        private static /* synthetic */ TailCall lambda$elaborateForPush$1(ItemEvaluator nodeNameEvaluator, ComputedElement expr, SchemaType typeCode, PushEvaluator contentPusher, Outputter out, XPathContext context) throws XPathException {
            try {
                QNameValue elemName = (QNameValue)nodeNameEvaluator.eval(context);
                Outputter elemOut = out;
                if (!expr.preservingTypes) {
                    ParseOptions options = expr.getValidationOptions().withTopLevelElement(elemName.getStructuredQName());
                    context.getConfiguration().prepareValidationReporting(context, options);
                    Receiver validator = context.getConfiguration().getElementValidator(elemOut, options, expr.getLocation());
                    if (validator != elemOut) {
                        out = new ComplexContentOutputter(validator);
                    }
                }
                if (out.getSystemId() == null) {
                    out.setSystemId(expr.getStaticBaseURIString());
                }
                int properties = 0;
                if (!expr.bequeathNamespacesToChildren) {
                    properties |= 0x80;
                }
                if (!expr.inheritNamespacesFromParent) {
                    properties |= 0x10000;
                }
                out.startElement(new FingerprintedQName(elemName.getStructuredQName()), typeCode, expr.getLocation(), properties |= 0x80000);
                TailCall tc = contentPusher.processLeavingTail(out, context);
                Expression.dispatchTailCall(tc);
                out.endElement();
            }
            catch (XPathException e) {
                throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
            }
            return null;
        }
    }
}

