/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyBuilder;

public class Doctype
extends Instruction {
    private final Operand contentOp;

    public Doctype(Expression content) {
        this.contentOp = new Operand(this, content, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getContent() {
        return this.contentOp.getChildExpression();
    }

    public void setContent(Expression content) {
        this.contentOp.setChildExpression(content);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.contentOp;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        throw new UnsupportedOperationException("Doctype.copy()");
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return true;
    }

    @Override
    public int getInstructionNameCode() {
        return 263;
    }

    private void write(Outputter out, String s) throws XPathException {
        out.characters(StringView.of(s), this.getLocation(), 1);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("saxonDoctype", this);
        this.getContent().export(out);
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new DoctypeElaborator();
    }

    private static class DoctypeElaborator
    extends PushElaborator {
        private DoctypeElaborator() {
        }

        private void write(Outputter out, String s) throws XPathException {
            out.characters(StringView.of(s), this.getExpression().getLocation(), 1);
        }

        @Override
        public PushEvaluator elaborateForPush() {
            Doctype expr = (Doctype)this.getExpression();
            PushEvaluator contentPush = expr.getContent().makeElaborator().elaborateForPush();
            return (output, context) -> {
                Controller controller = context.getController();
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setXPathContext(context);
                pipe.setHostLanguage(expr.getPackageData().getHostLanguage());
                TinyBuilder builder = new TinyBuilder(pipe);
                builder.setStatistics(pipe.getConfiguration().getTreeStatistics().RESULT_TREE_STATISTICS);
                builder.open();
                builder.startDocument(0);
                TailCall tc = contentPush.processLeavingTail(ComplexContentOutputter.makeComplexContentReceiver(builder, null), context);
                Expression.dispatchTailCall(tc);
                builder.endDocument();
                builder.close();
                NodeInfo dtdRoot = builder.getCurrentRoot();
                AxisIterator children = dtdRoot.iterateAxis(3);
                NodeInfo docType = (NodeInfo)children.next();
                if (docType == null || !"doctype".equals(docType.getLocalPart())) {
                    throw new XPathException("saxon:doctype instruction must contain dtd:doctype").withXPathContext(context);
                }
                String name = docType.getAttributeValue("", "name");
                String system = docType.getAttributeValue("", "system");
                String publicid = docType.getAttributeValue("", "public");
                if (name == null) {
                    throw new XPathException("dtd:doctype must have a name attribute").withXPathContext(context);
                }
                this.write(output, "<!DOCTYPE " + name + " ");
                if (system != null) {
                    if (publicid != null) {
                        this.write(output, "PUBLIC \"" + publicid + "\" \"" + system + "\"");
                    } else {
                        this.write(output, "SYSTEM \"" + system + "\"");
                    }
                }
                boolean openSquare = false;
                children = docType.iterateAxis(3);
                NodeInfo child = (NodeInfo)children.next();
                if (child != null) {
                    this.write(output, " [");
                    openSquare = true;
                }
                while (child != null) {
                    String elname;
                    String localname = child.getLocalPart();
                    if ("element".equals(localname)) {
                        elname = child.getAttributeValue("", "name");
                        String content = child.getAttributeValue("", "content");
                        if (elname == null) {
                            throw new XPathException("dtd:element must have a name attribute").withXPathContext(context);
                        }
                        if (content == null) {
                            throw new XPathException("dtd:element must have a content attribute").withXPathContext(context);
                        }
                        this.write(output, "\n  <!ELEMENT " + elname + " " + content + ">");
                    } else if (localname.equals("attlist")) {
                        NodeInfo attDef;
                        elname = child.getAttributeValue("", "element");
                        if (elname == null) {
                            throw new XPathException("dtd:attlist must have an attribute named 'element'").withXPathContext(context);
                        }
                        this.write(output, "\n  <!ATTLIST " + elname + " ");
                        AxisIterator attributes = child.iterateAxis(3);
                        while ((attDef = (NodeInfo)attributes.next()) != null) {
                            if ("attribute".equals(attDef.getLocalPart())) {
                                String atname = attDef.getAttributeValue("", "name");
                                String type = attDef.getAttributeValue("", "type");
                                String value = attDef.getAttributeValue("", "value");
                                if (atname == null) {
                                    throw new XPathException("dtd:attribute must have a name attribute").withXPathContext(context);
                                }
                                if (type == null) {
                                    throw new XPathException("dtd:attribute must have a type attribute").withXPathContext(context);
                                }
                                if (value == null) {
                                    throw new XPathException("dtd:attribute must have a value attribute").withXPathContext(context);
                                }
                                this.write(output, "\n    " + atname + " " + type + " " + value);
                                continue;
                            }
                            throw new XPathException("Unrecognized element within dtd:attlist").withXPathContext(context);
                        }
                        this.write(output, ">");
                    } else if (localname.equals("entity")) {
                        String entname = child.getAttributeValue("", "name");
                        String parameter = child.getAttributeValue("", "parameter");
                        String esystem = child.getAttributeValue("", "system");
                        String epublicid = child.getAttributeValue("", "public");
                        String notation = child.getAttributeValue("", "notation");
                        if (entname == null) {
                            throw new XPathException("dtd:entity must have a name attribute").withXPathContext(context);
                        }
                        this.write(output, "\n  <!ENTITY ");
                        if ("yes".equals(parameter)) {
                            this.write(output, "% ");
                        }
                        this.write(output, entname + " ");
                        if (esystem != null) {
                            if (epublicid != null) {
                                this.write(output, "PUBLIC \"" + epublicid + "\" \"" + esystem + "\" ");
                            } else {
                                this.write(output, "SYSTEM \"" + esystem + "\" ");
                            }
                        }
                        if (notation != null) {
                            this.write(output, "NDATA " + notation + " ");
                        }
                        for (NodeInfo nodeInfo : child.children()) {
                            nodeInfo.copy(output, 0, expr.getLocation());
                        }
                        this.write(output, ">");
                    } else if (localname.equals("notation")) {
                        String notname = child.getAttributeValue("", "name");
                        String nsystem = child.getAttributeValue("", "system");
                        String npublicid = child.getAttributeValue("", "public");
                        if (notname == null) {
                            throw new XPathException("dtd:notation must have a name attribute").withXPathContext(context);
                        }
                        if (nsystem == null && npublicid == null) {
                            throw new XPathException("dtd:notation must have a system attribute or a public attribute").withXPathContext(context);
                        }
                        this.write(output, "\n  <!NOTATION " + notname);
                        if (npublicid != null) {
                            this.write(output, " PUBLIC \"" + npublicid + "\" ");
                            if (nsystem != null) {
                                this.write(output, "\"" + nsystem + "\" ");
                            }
                        } else {
                            this.write(output, " SYSTEM \"" + nsystem + "\" ");
                        }
                        this.write(output, ">");
                    } else if (child.getNodeKind() == 3) {
                        this.write(output, child.getStringValue());
                    } else {
                        throw new XPathException("Unrecognized element " + localname + " in DTD output").withXPathContext(context);
                    }
                    child = (NodeInfo)children.next();
                }
                if (openSquare) {
                    this.write(output, "\n]");
                }
                this.write(output, ">\n");
                return null;
            };
        }
    }
}

