/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TextFragmentValue;

public class DocumentInstr
extends ParentNodeConstructor {
    private final boolean textOnly;
    private final UnicodeString constantText;
    private Statistics treeStatistics = new Statistics();

    public DocumentInstr(boolean textOnly, UnicodeString constantText) {
        this.textOnly = textOnly;
        this.constantText = constantText;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.contentOp;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    public UnicodeString getConstantText() {
        return this.constantText;
    }

    @Override
    protected void checkContentSequence(StaticContext env) throws XPathException {
        DocumentInstr.checkContentSequence(env, this.getContentOperand(), this.getValidationOptions());
    }

    protected static void checkContentSequence(StaticContext env, Operand content, ParseOptions validationOptions) throws XPathException {
        Operand[] components = content.getChildExpression() instanceof Block ? ((Block)content.getChildExpression()).getOperanda() : new Operand[]{content};
        int validation = validationOptions == null ? 3 : validationOptions.getSchemaValidationMode();
        SchemaType type = validationOptions == null ? null : validationOptions.getTopLevelType();
        int elementCount = 0;
        boolean isXSLT = content.getChildExpression().getPackageData().isXSLT();
        for (Operand o : components) {
            SchemaDeclaration decl;
            XPathException de;
            Expression component = o.getChildExpression();
            ItemType it = component.getItemType();
            if (!(it instanceof NodeTest)) continue;
            UType possibleNodeKinds = it.getUType();
            if (possibleNodeKinds.equals(UType.ATTRIBUTE)) {
                de = new XPathException("Cannot create an attribute node whose parent is a document node");
                de.setErrorCode(isXSLT ? "XTDE0420" : "XPTY0004");
                de.setLocator(component.getLocation());
                throw de;
            }
            if (possibleNodeKinds.equals(UType.NAMESPACE)) {
                de = new XPathException("Cannot create a namespace node whose parent is a document node");
                de.setErrorCode(isXSLT ? "XTDE0420" : "XQTY0024");
                de.setLocator(component.getLocation());
                throw de;
            }
            if (!possibleNodeKinds.equals(UType.ELEMENT)) continue;
            if (++elementCount > 1 && (validation == 1 || validation == 2 || type != null)) {
                de = new XPathException("A valid document must have only one child element");
                if (isXSLT) {
                    de.setErrorCode("XTTE1550");
                } else {
                    de.setErrorCode("XQDY0061");
                }
                de.setLocator(component.getLocation());
                throw de;
            }
            if (validation != 1 || !(component instanceof FixedElement) || (decl = env.getConfiguration().getElementDeclaration(((FixedElement)component).getFixedElementName().getFingerprint())) == null) continue;
            ((FixedElement)component).getContentExpression().checkPermittedContents(decl.getType(), true);
        }
    }

    @Override
    protected int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        p |= 0x1000000;
        if (this.getValidationAction() == 4) {
            p |= 0x8000000;
        }
        return p;
    }

    public Expression getStringValueExpression() {
        if (this.textOnly) {
            if (this.constantText != null) {
                return new StringLiteral(StringValue.makeUntypedAtomic(this.constantText));
            }
            if (this.getContentExpression() instanceof ValueOf) {
                return ((ValueOf)this.getContentExpression()).convertToCastAsString();
            }
            Expression fn = SystemFunction.makeCall("string-join", this.getRetainedStaticContext(), this.getContentExpression(), new StringLiteral(StringValue.EMPTY_STRING));
            CastExpression cast = new CastExpression(fn, BuiltInAtomicType.UNTYPED_ATOMIC, false);
            ExpressionTool.copyLocationInfo(this, cast);
            return cast;
        }
        throw new AssertionError((Object)"getStringValueExpression() called on non-text-only document instruction");
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        DocumentInstr doc = new DocumentInstr(this.textOnly, this.constantText);
        ExpressionTool.copyLocationInfo(this, doc);
        doc.setContentExpression(this.getContentExpression().copy(rebindings));
        doc.setValidationAction(this.getValidationAction(), this.getSchemaType());
        return doc;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.DOCUMENT;
    }

    @Override
    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        return (NodeInfo)this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public int getInstructionNameCode() {
        return 150;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        SchemaType schemaType;
        out.startElement("doc", this);
        if (!out.getOptions().relocatable) {
            out.emitAttribute("base", this.getStaticBaseURIString());
        }
        Object flags = "";
        if (this.textOnly) {
            flags = (String)flags + "t";
        }
        if (this.isLocal()) {
            flags = (String)flags + "l";
        }
        if (!((String)flags).isEmpty()) {
            out.emitAttribute("flags", (String)flags);
        }
        if (this.constantText != null) {
            out.emitAttribute("text", this.constantText.toString());
        }
        if (this.getValidationAction() != 4 && this.getValidationAction() != 8) {
            out.emitAttribute("validation", Validation.describe(this.getValidationAction()));
        }
        if ((schemaType = this.getSchemaType()) != null) {
            out.emitAttribute("type", schemaType.getStructuredQName());
        }
        this.getContentExpression().export(out);
        out.endElement();
    }

    @Override
    public String getStreamerName() {
        return "DocumentInstr";
    }

    @Override
    public Elaborator getElaborator() {
        return new DocumentInstrElaborator();
    }

    public static class DocumentInstrElaborator
    extends PushElaborator {
        @Override
        public PushEvaluator elaborateForPush() {
            DocumentInstr expr = (DocumentInstr)this.getExpression();
            PushEvaluator content = expr.getContentExpression().makeElaborator().elaborateForPush();
            if (!expr.textOnly) {
                if (expr.preservingTypes) {
                    return (output, context) -> {
                        output.setSystemId(expr.getStaticBaseURIString());
                        output.startDocument(0);
                        TailCall tc = content.processLeavingTail(output, context);
                        Expression.dispatchTailCall(tc);
                        output.endDocument();
                        return null;
                    };
                }
                return (output, context) -> {
                    ParseOptions options = expr.getValidationOptions();
                    context.getConfiguration().prepareValidationReporting(context, options);
                    Receiver validator = context.getConfiguration().getDocumentValidator(output, expr.getStaticBaseURIString(), options, expr.getLocation());
                    ComplexContentOutputter outputter = new ComplexContentOutputter(validator);
                    outputter.startDocument(0);
                    TailCall tc = content.processLeavingTail(outputter, context);
                    Expression.dispatchTailCall(tc);
                    outputter.endDocument();
                    return null;
                };
            }
            ItemEvaluator evalAsItem = this.elaborateForItem();
            Location loc = expr.getLocation();
            return (output, context) -> {
                Item item = evalAsItem.eval(context);
                if (item != null) {
                    output.append(item, loc, 524288);
                }
                return null;
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            DocumentInstr expr = (DocumentInstr)this.getExpression();
            String staticBaseUri = expr.getStaticBaseURIString();
            if (expr.textOnly) {
                if (expr.constantText != null) {
                    UnicodeString text = expr.constantText;
                    return context -> TextFragmentValue.makeTextFragment(context.getConfiguration(), text, staticBaseUri);
                }
                PullEvaluator contentEval = expr.getContentExpression().makeElaborator().elaborateForPull();
                return context -> {
                    Item item;
                    UnicodeBuilder sb = new UnicodeBuilder();
                    SequenceIterator iter = contentEval.iterate(context);
                    while ((item = iter.next()) != null) {
                        sb.accept(item.getUnicodeStringValue());
                    }
                    return TextFragmentValue.makeTextFragment(context.getConfiguration(), sb.toUnicodeString(), staticBaseUri);
                };
            }
            PushEvaluator contentEval = expr.getContentExpression().makeElaborator().elaborateForPush();
            HostLanguage hostLanguage = expr.getPackageData().getHostLanguage();
            return context -> {
                try {
                    Controller controller = context.getController();
                    PipelineConfiguration pipe = controller.makePipelineConfiguration();
                    pipe.setXPathContext(context);
                    Builder builder = controller.makeBuilder();
                    builder.setUseEventLocation(false);
                    builder.setDurability(Durability.TEMPORARY);
                    if (builder instanceof TinyBuilder) {
                        ((TinyBuilder)builder).setStatistics(expr.treeStatistics);
                    }
                    builder.setBaseURI(staticBaseUri);
                    builder.setTiming(false);
                    pipe.setHostLanguage(hostLanguage);
                    builder.setPipelineConfiguration(pipe);
                    ComplexContentOutputter out = ComplexContentOutputter.makeComplexContentReceiver(builder, expr.getValidationOptions());
                    out.open();
                    out.startDocument(0);
                    TailCall tc = contentEval.processLeavingTail(out, context);
                    Expression.dispatchTailCall(tc);
                    out.endDocument();
                    out.close();
                    return builder.getCurrentRoot();
                }
                catch (XPathException e) {
                    throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                }
            };
        }
    }
}

