/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.function.BiConsumer;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.ProxyOutputter;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SimpleNodePushElaborator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UniStringConsumer;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Whitespace;

public final class ValueOf
extends SimpleNodeConstructor {
    private int options;
    private boolean numberingInstruction = false;
    private final boolean noNodeIfEmpty;

    public ValueOf(Expression select, boolean disable, boolean noNodeIfEmpty) {
        this.setSelect(select);
        this.options = disable ? 1 : 0;
        this.noNodeIfEmpty = noNodeIfEmpty;
        this.adoptChildExpression(select);
        if (select instanceof StringLiteral) {
            boolean special;
            UnicodeString val = ((StringLiteral)select).getString();
            boolean bl = special = val.indexWhere(c -> c < 33 || c > 126 || c == 60 || c == 62 || c == 38, 0L) >= 0L;
            if (!special) {
                this.options |= 4;
            }
        }
    }

    public void setIsNumberingInstruction() {
        this.numberingInstruction = true;
    }

    public boolean isNumberingInstruction() {
        return this.numberingInstruction;
    }

    public boolean isNoNodeIfEmpty() {
        return this.noNodeIfEmpty;
    }

    @Override
    public String toShortString() {
        if (this.getSelect() instanceof StringLiteral) {
            return "text{" + Err.depict(((StringLiteral)this.getSelect()).getGroundedValue()) + "}";
        }
        return super.toShortString();
    }

    @Override
    public void gatherProperties(BiConsumer<String, Object> consumer) {
        if (this.getSelect() instanceof StringLiteral) {
            consumer.accept("text", ((StringLiteral)this.getSelect()).getGroundedValue().getUnicodeStringValue());
        }
    }

    @Override
    public int getInstructionNameCode() {
        if (this.numberingInstruction) {
            return 186;
        }
        if (this.getSelect() instanceof StringLiteral) {
            return 211;
        }
        return 215;
    }

    public int getOptions() {
        return this.options;
    }

    public boolean isDisableOutputEscaping() {
        return ReceiverOption.contains(this.options, 1);
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.TEXT;
    }

    @Override
    protected int computeCardinality() {
        if (this.noNodeIfEmpty) {
            return 24576;
        }
        return 16384;
    }

    @Override
    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) {
    }

    @Override
    public int getIntrinsicDependencies() {
        int d = super.getIntrinsicDependencies();
        if (this.isDisableOutputEscaping()) {
            d |= 0x200;
        }
        return d;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ValueOf exp = new ValueOf(this.getSelect().copy(rebindings), ReceiverOption.contains(this.options, 1), this.noNodeIfEmpty);
        ExpressionTool.copyLocationInfo(this, exp);
        if (this.numberingInstruction) {
            exp.setIsNumberingInstruction();
        }
        return exp;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, boolean whole) throws XPathException {
        if (this.getSelect() instanceof Literal) {
            GroundedValue selectValue = ((Literal)this.getSelect()).getGroundedValue();
            SimpleType stype = null;
            if (parentType instanceof SimpleType && whole) {
                stype = (SimpleType)parentType;
            } else if (parentType instanceof ComplexType && ((ComplexType)parentType).isSimpleContent()) {
                stype = ((ComplexType)parentType).getSimpleContentType();
            }
            if (whole && stype != null && !stype.isNamespaceSensitive()) {
                ValidationFailure err = stype.validateContent(selectValue.getUnicodeStringValue(), null, this.getConfiguration().getConversionRules());
                if (err != null) {
                    err.setLocator(this.getLocation());
                    err.setErrorCode(this.isXSLT() ? "XTTE1540" : "XQDY0027");
                    throw err.makeException();
                }
                return;
            }
            if (parentType instanceof ComplexType && !((ComplexType)parentType).isSimpleContent() && !((ComplexType)parentType).isMixedContent() && !Whitespace.isAllWhite(selectValue.getUnicodeStringValue())) {
                throw new XPathException("The containing element must be of type " + parentType.getDescription() + ", which does not allow text content " + Err.wrap(selectValue.getUnicodeStringValue())).withLocation(this.getLocation()).asTypeError();
            }
        }
    }

    public Expression convertToCastAsString() {
        if (this.noNodeIfEmpty || !Cardinality.allowsZero(this.getSelect().getCardinality())) {
            return new CastExpression(this.getSelect(), BuiltInAtomicType.UNTYPED_ATOMIC, true);
        }
        Expression sf = SystemFunction.makeCall("string", this.getRetainedStaticContext(), this.getSelect());
        return new CastExpression(sf, BuiltInAtomicType.UNTYPED_ATOMIC, false);
    }

    @Override
    public void processValue(UnicodeString value, Outputter output, XPathContext context) throws XPathException {
        output.characters(value, this.getLocation(), this.options);
    }

    @Override
    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        try {
            Item content = this.getSelect().makeElaborator().elaborateForItem().eval(context);
            return ValueOf.makeTextNode(content, this.noNodeIfEmpty, this.isDisableOutputEscaping(), context);
        }
        catch (XPathException err) {
            throw err.maybeWithLocation(this.getLocation()).maybeWithContext(context);
        }
    }

    private static NodeInfo makeTextNode(Item content, boolean noNodeIfEmpty, boolean doe, XPathContext context) throws XPathException {
        UnicodeString val;
        if (content == null) {
            if (noNodeIfEmpty) {
                return null;
            }
            val = EmptyUnicodeString.getInstance();
        } else {
            val = content.getUnicodeStringValue();
        }
        Orphan o = new Orphan(context.getConfiguration());
        o.setNodeKind((short)3);
        o.setStringValue(val);
        if (doe) {
            o.setDisableOutputEscaping(true);
        }
        return o;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("valueOf", this);
        Object flags = "";
        if (this.isDisableOutputEscaping()) {
            flags = (String)flags + "d";
        }
        if (ReceiverOption.contains(this.options, 4)) {
            flags = (String)flags + "S";
        }
        if (this.noNodeIfEmpty) {
            flags = (String)flags + "e";
        }
        if (this.isLocal()) {
            flags = (String)flags + "l";
        }
        if (!((String)flags).isEmpty()) {
            out.emitAttribute("flags", (String)flags);
        }
        this.getSelect().export(out);
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new ValueOfElaborator();
    }

    private static class ValueOfElaborator
    extends SimpleNodePushElaborator {
        private ValueOfElaborator() {
        }

        @Override
        public PushEvaluator elaborateForPush() {
            ValueOf expr = (ValueOf)this.getExpression();
            Location loc = expr.getLocation();
            boolean noNodeIfEmpty = expr.noNodeIfEmpty;
            int options = expr.getOptions();
            if (noNodeIfEmpty) {
                ItemEvaluator contentEval = expr.getSelect().makeElaborator().elaborateForItem();
                return (output, context) -> {
                    try {
                        Item value = contentEval.eval(context);
                        if (value != null) {
                            output.characters(value.getUnicodeStringValue(), loc, options);
                        }
                        return null;
                    }
                    catch (XPathException e) {
                        throw e.maybeWithLocation(expr.getSelect().getLocation());
                    }
                };
            }
            if (expr.getSelect().getItemType() == BuiltInAtomicType.STRING && !expr.isDisableOutputEscaping() && !Cardinality.allowsZero(expr.getCardinality())) {
                PushEvaluator contentEval = expr.getSelect().makeElaborator().elaborateForPush();
                return (output, context) -> {
                    try {
                        TextNodeOutputStreamer streamer = new TextNodeOutputStreamer(output, loc, options);
                        return contentEval.processLeavingTail(streamer, context);
                    }
                    catch (XPathException e) {
                        throw e.maybeWithLocation(expr.getSelect().getLocation());
                    }
                };
            }
            UnicodeStringEvaluator contentEval = expr.getSelect().makeElaborator().elaborateForUnicodeString(true);
            return (output, context) -> {
                try {
                    UnicodeString value = contentEval.eval(context);
                    output.characters(value, loc, options);
                    return null;
                }
                catch (XPathException e) {
                    throw e.maybeWithLocation(expr.getSelect().getLocation());
                }
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            ValueOf expr = (ValueOf)this.getExpression();
            ItemEvaluator contentEval = expr.getSelect().makeElaborator().elaborateForItem();
            boolean noNodeIfEmpty = expr.noNodeIfEmpty;
            boolean doe = expr.isDisableOutputEscaping();
            return context -> {
                try {
                    return ValueOf.makeTextNode(contentEval.eval(context), noNodeIfEmpty, doe, context);
                }
                catch (XPathException e) {
                    throw e.maybeWithLocation(expr.getSelect().getLocation());
                }
            };
        }
    }

    private static class TextNodeOutputStreamer
    extends ProxyOutputter {
        private final Location instructionLoc;
        private final int options;

        public TextNodeOutputStreamer(Outputter output, Location instructionLoc, int options) {
            super(output);
            this.instructionLoc = instructionLoc;
            this.options = options;
        }

        @Override
        public void append(Item item) throws XPathException {
            this.getNextOutputter().characters(item.getUnicodeStringValue(), this.instructionLoc, this.options);
        }

        @Override
        public void append(Item item, Location loc, int properties) throws XPathException {
            Location location = loc.getLineNumber() == -1 ? this.instructionLoc : loc;
            this.getNextOutputter().characters(item.getUnicodeStringValue(), location, properties | this.options);
        }

        @Override
        public UniStringConsumer getStringReceiver(boolean asTextNode, Location loc) {
            Location location = loc.getLineNumber() == -1 ? this.instructionLoc : loc;
            return this.getNextOutputter().getStringReceiver(true, location);
        }
    }
}

