/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.sf.saxon.expr.DefaultedArgumentExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.functions.NormalizeUnicode;
import net.sf.saxon.functions.OptionsParameter;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeSelector;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ComplexVariety;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;

public class DeepEqual
extends CollatingFunctionFixed {
    public static OptionsParameter OPTION_DETAILS;

    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        Expression[] newArgs = new Expression[]{arguments[0], arguments[1], arguments.length < 3 || arguments[2] instanceof DefaultedArgumentExpression ? new StringLiteral(this.getRetainedStaticContext().getDefaultCollationName()) : arguments[2], arguments.length < 4 || arguments[3] instanceof DefaultedArgumentExpression ? Literal.makeLiteral(new DictionaryMap()) : arguments[3]};
        this.setArity(4);
        return super.makeFunctionCall(newArgs);
    }

    public static boolean deepEqual(SequenceIterator op1, SequenceIterator op2, XPathContext context, DeepEqualOptions options) throws XPathException {
        ErrorReporter reporter;
        Object reason;
        boolean result;
        block18: {
            result = true;
            reason = null;
            reporter = context.getErrorReporter();
            try {
                if (!options.textBoundariesSignificant) {
                    op1 = DeepEqual.mergeAdjacentTextNodes(op1);
                    op2 = DeepEqual.mergeAdjacentTextNodes(op2);
                }
                int pos1 = 0;
                int pos2 = 0;
                while (true) {
                    Item item1 = op1.next();
                    Item item2 = op2.next();
                    if (item1 == null && item2 == null) break block18;
                    ++pos1;
                    ++pos2;
                    if (item1 == null || item2 == null) {
                        result = false;
                        reason = item1 == null ? "Second sequence is longer (first sequence length = " + pos2 + ")" : "First sequence is longer (second sequence length = " + pos1 + ")";
                        if (item1 instanceof WhitespaceTextImpl || item2 instanceof WhitespaceTextImpl) {
                            reason = (String)reason + " (the first extra node is whitespace text)";
                        }
                        break block18;
                    }
                    if (item1 instanceof FunctionItem || item2 instanceof FunctionItem) {
                        if (!(item1 instanceof FunctionItem) || !(item2 instanceof FunctionItem)) {
                            reason = "if one item is a function then both must be functions (position " + pos1 + ")";
                            return false;
                        }
                        boolean fe = ((FunctionItem)item1).deepEqual40((FunctionItem)item2, context, options);
                        if (fe) continue;
                        result = false;
                        reason = "functions at position " + pos1 + " differ";
                        break block18;
                    }
                    if (item1 instanceof ObjectValue || item2 instanceof ObjectValue) {
                        if (item1.equals(item2)) continue;
                        return false;
                    }
                    if (item1 instanceof NodeInfo) {
                        if (item2 instanceof NodeInfo) {
                            String message = DeepEqual.deepEqual((NodeInfo)item1, (NodeInfo)item2, context, options);
                            if (message == null) continue;
                            result = false;
                            reason = "nodes at position " + pos1 + " differ: " + message;
                        } else {
                            result = false;
                            reason = "comparing a node to an atomic value at position " + pos1;
                        }
                        break block18;
                    }
                    if (item2 instanceof NodeInfo) {
                        result = false;
                        reason = "comparing an atomic value to a node at position " + pos1;
                        break block18;
                    }
                    AtomicValue av1 = (AtomicValue)item1;
                    AtomicValue av2 = (AtomicValue)item2;
                    if (!(av1.isNaN() && av2.isNaN() || options.comparer.comparesEqual(av1, av2))) {
                        result = false;
                        reason = "atomic values at position " + pos1 + " differ";
                        break block18;
                    }
                    if (options.typeAnnotationsSignificant && !av1.getItemType().equals(av2.getItemType())) {
                        result = false;
                        reason = "atomic values at position " + pos1 + " have different type annotations";
                        break block18;
                    }
                    if (options.namespacePrefixesSignificant && av1 instanceof QualifiedNameValue && av2 instanceof QualifiedNameValue && !((QualifiedNameValue)av1).getPrefix().equals(((QualifiedNameValue)av2).getPrefix())) {
                        result = false;
                        reason = "QName values at position " + pos1 + " have different namespace prefixes";
                        break block18;
                    }
                    if (options.timezonesSignificant && av1 instanceof CalendarValue && av2 instanceof CalendarValue && ((CalendarValue)av1).getTimezoneInMinutes() != ((CalendarValue)av2).getTimezoneInMinutes()) break;
                }
                result = false;
                reason = "Values at position " + pos1 + " have different timezone";
            }
            catch (UncheckedXPathException uxe) {
                throw uxe.getXPathException();
            }
            catch (ClassCastException err) {
                result = false;
                reason = "sequences contain non-comparable values";
            }
        }
        if (!result) {
            DeepEqual.explain(reporter, (String)reason, options, null, null);
        }
        return result;
    }

    public static String deepEqual(NodeInfo n1, NodeInfo n2, XPathContext context, DeepEqualOptions options) throws XPathException {
        if (n1.equals(n2)) {
            return null;
        }
        ErrorReporter reporter = context.getErrorReporter();
        if (n1.getNodeKind() != n2.getNodeKind()) {
            String reason = "node kinds differ: comparing " + DeepEqual.showKind(n1) + " to " + DeepEqual.showKind(n2);
            DeepEqual.explain(reporter, reason, options, n1, n2);
            return reason;
        }
        if (options.baseUriSignificant && !Objects.equals(n1.getBaseURI(), n2.getBaseURI())) {
            String reason = "base URIs differ: comparing " + n1.getBaseURI() + " to " + n2.getBaseURI();
            DeepEqual.explain(reporter, reason, options, n1, n2);
            return reason;
        }
        if (options.typeAnnotationsSignificant && !n1.getSchemaType().equals(n2.getSchemaType())) {
            String reason = "nodes have different type annotations";
            DeepEqual.explain(reporter, reason, options, n1, n2);
            return reason;
        }
        switch (n1.getNodeKind()) {
            case 1: {
                String reason;
                NamespaceMap nm2;
                NamespaceMap nm1;
                Object reason2;
                NodeInfo att1;
                AxisIterator a2;
                if (!Navigator.haveSameName(n1, n2)) {
                    String reason3 = "element names differ: " + NameOfNode.makeName(n1).getStructuredQName().getEQName() + " != " + NameOfNode.makeName(n2).getStructuredQName().getEQName();
                    DeepEqual.explain(reporter, reason3, options, n1, n2);
                    return reason3;
                }
                if (options.namespacePrefixesSignificant && !n1.getPrefix().equals(n2.getPrefix())) {
                    String reason4 = "element prefixes differ: " + n1.getPrefix() + " != " + n2.getPrefix();
                    DeepEqual.explain(reporter, reason4, options, n1, n2);
                    return reason4;
                }
                if (options.inScopeNamespacesSignificant && !n1.getAllNamespaces().equals(n2.getAllNamespaces())) {
                    String reason5 = "in-scope namespaces differ: " + String.valueOf(n1.getAllNamespaces()) + " versus " + String.valueOf(n2.getAllNamespaces());
                    DeepEqual.explain(reporter, reason5, options, n1, n2);
                    return reason5;
                }
                AxisIterator a1 = n1.iterateAxis(2);
                if (!SequenceTool.sameLength(a1, a2 = n2.iterateAxis(2))) {
                    String reason6 = "elements have different number of attributes";
                    DeepEqual.explain(reporter, "elements have different number of attributes", options, n1, n2);
                    return "elements have different number of attributes";
                }
                a1 = n1.iterateAxis(2);
                while ((att1 = a1.next()) != null) {
                    AxisIterator a2iter = n2.iterateAxis(2, new SameNameTest(att1));
                    NodeInfo att2 = a2iter.next();
                    if (att2 == null) {
                        reason2 = "one element has an attribute " + NameOfNode.makeName(att1).getStructuredQName().getEQName() + ", the other does not";
                        DeepEqual.explain(reporter, (String)reason2, options, n1, n2);
                        return reason2;
                    }
                    String attReason = DeepEqual.deepEqual(att1, att2, context, options);
                    if (attReason == null) continue;
                    String reason7 = "elements have different values for the attribute " + NameOfNode.makeName(att1).getStructuredQName().getEQName() + " - " + attReason;
                    DeepEqual.explain(reporter, reason7, options, n1, n2);
                    return reason7;
                }
                if (options.inScopeNamespacesSignificant && !(nm1 = n1.getAllNamespaces()).equals(nm2 = n2.getAllNamespaces())) {
                    reason2 = "elements have different in-scope namespaces: " + String.valueOf(nm1) + " versus " + String.valueOf(nm2);
                    DeepEqual.explain(reporter, (String)reason2, options, n1, n2);
                    return reason2;
                }
                if (options.typeAnnotationsSignificant && !n1.getSchemaType().equals(n2.getSchemaType())) {
                    reason = "elements have different type annotation";
                    DeepEqual.explain(reporter, "elements have different type annotation", options, n1, n2);
                    return "elements have different type annotation";
                }
                if (options.typeVarietySignificant) {
                    ComplexVariety variety2;
                    ComplexVariety variety1;
                    if (n1.getSchemaType().isComplexType() != n2.getSchemaType().isComplexType()) {
                        reason = "one element has complex type, the other simple";
                        DeepEqual.explain(reporter, "one element has complex type, the other simple", options, n1, n2);
                        return "one element has complex type, the other simple";
                    }
                    if (n1.getSchemaType().isComplexType() && (variety1 = ((ComplexType)n1.getSchemaType()).getVariety()) != (variety2 = ((ComplexType)n2.getSchemaType()).getVariety())) {
                        reason2 = "both elements have complex type, but a different variety";
                        DeepEqual.explain(reporter, "both elements have complex type, but a different variety", options, n1, n2);
                        return "both elements have complex type, but a different variety";
                    }
                }
                if (options.typedValuesSignificant) {
                    boolean isSimple2;
                    SchemaType type1 = n1.getSchemaType();
                    SchemaType type2 = n2.getSchemaType();
                    boolean isSimple1 = type1.isSimpleType() || ((ComplexType)type1).isSimpleContent();
                    boolean bl = isSimple2 = type2.isSimpleType() || ((ComplexType)type2).isSimpleContent();
                    if (options.typeVarietySignificant && isSimple1 != isSimple2) {
                        String reason8 = "one element has a simple type, the other does not";
                        DeepEqual.explain(reporter, "one element has a simple type, the other does not", options, n1, n2);
                        return "one element has a simple type, the other does not";
                    }
                    if (isSimple1 && isSimple2) {
                        AtomicIterator v2;
                        AtomicIterator v1 = n1.atomize().iterate();
                        boolean typedValueComparison = DeepEqual.deepEqual(v1, v2 = n2.atomize().iterate(), context, options);
                        return typedValueComparison ? null : "typed values of elements differ";
                    }
                }
                if (options.idSignificant && n1.isId() != n2.isId()) {
                    reason = "one element is an ID, the other is not";
                    DeepEqual.explain(reporter, "one element is an ID, the other is not", options, n1, n2);
                    return "one element is an ID, the other is not";
                }
                if (options.idrefSignificant && n1.isIdref() != n2.isIdref()) {
                    reason = "one element is an IDREF, the other is not";
                    DeepEqual.explain(reporter, "one element is an IDREF, the other is not", options, n1, n2);
                    return "one element is an IDREF, the other is not";
                }
                if (options.nilledSignificant && n1.isNilled() != n2.isNilled()) {
                    reason = "one element is nilled, the other is not";
                    DeepEqual.explain(reporter, "one element is nilled, the other is not", options, n1, n2);
                    return "one element is nilled, the other is not";
                }
                if (options.unorderedElements.contains(NameOfNode.makeName(n1).getStructuredQName())) {
                    return DeepEqual.hasSameChildrenUnordered(n1, n2, options, context);
                }
                CSharp.emitCode("goto case Saxon.Hej.type.Type.DOCUMENT;");
            }
            case 9: {
                NodeInfo d2;
                NodeInfo d1;
                String recursiveResult;
                SequenceIterator c1 = n1.iterateAxis(3, NodeSelector.of(node -> !DeepEqual.isIgnorable(node, options)));
                SequenceIterator c2 = n2.iterateAxis(3, NodeSelector.of(node -> !DeepEqual.isIgnorable(node, options)));
                if (!options.textBoundariesSignificant) {
                    c1 = DeepEqual.mergeAdjacentTextNodes(c1);
                    c2 = DeepEqual.mergeAdjacentTextNodes(c2);
                }
                do {
                    boolean r;
                    d1 = (NodeInfo)c1.next();
                    d2 = (NodeInfo)c2.next();
                    if (d1 != null && d2 != null) continue;
                    boolean bl = r = d1 == d2;
                    if (!r) {
                        String message = "the first operand contains a node with " + (d1 == null ? "fewer" : "more") + " children than the second";
                        if (d1 instanceof WhitespaceTextImpl || d2 instanceof WhitespaceTextImpl) {
                            message = message + " (the first extra child is whitespace text)";
                        }
                        DeepEqual.explain(reporter, message, options, n1, n2);
                        return message;
                    }
                    return null;
                } while ((recursiveResult = DeepEqual.deepEqual(d1, d2, context, options)) == null);
                return recursiveResult;
            }
            case 2: {
                if (!Navigator.haveSameName(n1, n2)) {
                    String reason = "attribute names differ: " + NameOfNode.makeName(n1).getStructuredQName().getEQName() + " != " + NameOfNode.makeName(n1).getStructuredQName().getEQName();
                    DeepEqual.explain(reporter, reason, options, n1, n2);
                    return reason;
                }
                if (options.namespacePrefixesSignificant && !n1.getPrefix().equals(n2.getPrefix())) {
                    String reason = "attribute prefixes differ: " + n1.getPrefix() + " != " + n2.getPrefix();
                    DeepEqual.explain(reporter, reason, options, n1, n2);
                    return reason;
                }
                if (options.typeAnnotationsSignificant && !n1.getSchemaType().equals(n2.getSchemaType())) {
                    String reason = "attributes have different type annotations";
                    DeepEqual.explain(reporter, "attributes have different type annotations", options, n1, n2);
                    return "attributes have different type annotations";
                }
                boolean ar = options.typedValuesSignificant ? DeepEqual.deepEqual(n1.atomize().iterate(), n2.atomize().iterate(), context, options) : options.comparer.comparesEqual(new StringValue(n1.getUnicodeStringValue()), new StringValue(n2.getUnicodeStringValue()));
                if (!ar) {
                    String reason = "attribute values differ";
                    DeepEqual.explain(reporter, "attribute values differ", options, n1, n2);
                    return "attribute values differ";
                }
                if (options.idSignificant && n1.isId() != n2.isId()) {
                    String reason = "one attribute is an ID, the other is not";
                    DeepEqual.explain(reporter, "one attribute is an ID, the other is not", options, n1, n2);
                    return "one attribute is an ID, the other is not";
                }
                if (options.idrefSignificant && n1.isIdref() != n2.isIdref()) {
                    String reason = "one attribute is an IDREF, the other is not";
                    DeepEqual.explain(reporter, "one attribute is an IDREF, the other is not", options, n1, n2);
                    return "one attribute is an IDREF, the other is not";
                }
                return null;
            }
            case 7: 
            case 13: {
                if (!n1.getLocalPart().equals(n2.getLocalPart())) {
                    String reason = Type.displayTypeName(n1) + " names differ";
                    DeepEqual.explain(reporter, reason, options, n1, n2);
                    return reason;
                }
                CSharp.emitCode("goto case Saxon.Hej.type.Type.TEXT;");
            }
            case 3: 
            case 8: {
                boolean vr = DeepEqual.compareStrings(n1.getStringValue(), n2.getStringValue(), options, context);
                if (!vr) {
                    if (options.debug) {
                        String v1 = n1.getStringValue();
                        String v2 = n2.getStringValue();
                        Object message = "";
                        if (v1.length() != v2.length()) {
                            message = "lengths (" + v1.length() + "," + v2.length() + ")";
                        }
                        if (v1.length() < 10 && v2.length() < 10) {
                            message = " (\"" + v1 + "\" vs \"" + v2 + "\")";
                        } else {
                            int min = Math.min(v1.length(), v2.length());
                            if (v1.substring(0, min).equals(v2.substring(0, min))) {
                                message = (String)message + " different at char " + min + "(\"" + StringTool.diagnosticDisplay((v1.length() > v2.length() ? v1 : v2).substring(min)) + "\")";
                            } else if (v1.charAt(0) != v2.charAt(0)) {
                                message = (String)message + " different at start (\"" + v1.substring(0, Math.min(v1.length(), 10)) + "\", \"" + v2.substring(0, Math.min(v2.length(), 10)) + "\")";
                            } else {
                                for (int i = 1; i < min; ++i) {
                                    if (v1.substring(0, i).equals(v2.substring(0, i))) continue;
                                    message = (String)message + " different at char " + (i - 1) + "(\"" + v1.substring(i - 1, Math.min(v1.length(), i + 10)) + "\", \"" + v2.substring(i - 1, Math.min(v2.length(), i + 10)) + "\")";
                                    break;
                                }
                            }
                        }
                        DeepEqual.explain(reporter, Type.displayTypeName(n1) + " values differ (" + Navigator.getPath(n1) + ", " + Navigator.getPath(n2) + "): " + (String)message, options, n1, n2);
                        return message;
                    }
                    return "atomized values differ";
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown node kind");
    }

    private static String hasSameChildrenUnordered(NodeInfo e0, NodeInfo e1, DeepEqualOptions options, XPathContext context) throws XPathException {
        int hash;
        ArrayList<NodeInfo> children0 = new ArrayList<NodeInfo>();
        ArrayList<NodeInfo> children1 = new ArrayList<NodeInfo>();
        for (NodeInfo nodeInfo : e0.children()) {
            if (DeepEqual.isIgnorable(nodeInfo, options)) continue;
            children0.add(nodeInfo);
        }
        for (NodeInfo nodeInfo : e1.children()) {
            if (DeepEqual.isIgnorable(nodeInfo, options)) continue;
            children1.add(nodeInfo);
        }
        if (children0.size() != children1.size()) {
            return "Number of children differs: " + children0.size() + " vs. " + children1.size();
        }
        ArrayList<Integer> hashcodes1 = new ArrayList<Integer>(children1.size());
        IntHashSet intHashSet = new IntHashSet();
        for (NodeInfo nodeInfo : children1) {
            hash = DeepEqual.computeHashCode(nodeInfo, options);
            ((IntSet)intHashSet).add(hash);
            hashcodes1.add(hash);
        }
        for (NodeInfo c0 : children0) {
            hash = DeepEqual.computeHashCode(c0, options);
            if (!((IntSet)intHashSet).contains(hash)) {
                return "Node found among first node's children with no counterpart among the second node's children";
            }
            int found = -1;
            for (int j = 0; j < hashcodes1.size(); ++j) {
                if (hash != (Integer)hashcodes1.get(j) || DeepEqual.deepEqual(c0, (NodeInfo)children1.get(j), context, options) != null) continue;
                found = j;
                break;
            }
            if (found >= 0) {
                children1.remove(found);
                hashcodes1.remove(found);
                continue;
            }
            return "Node found among first node's children with no counterpart among the second node's children";
        }
        return null;
    }

    private static int computeHashCode(NodeInfo node, DeepEqualOptions options) {
        return node.getNodeKind() << 24 ^ node.getFingerprint() ^ node.attributes().size() << 10;
    }

    private static long hashCodeOfSequence(GroundedValue value, Function<Item, Long> hash) {
        long h = 0L;
        for (Item item : value.asIterable()) {
            h ^= hash.apply(item).longValue();
        }
        return h;
    }

    private static long hashCodeOfNode(NodeInfo node, DeepEqualOptions options, XPathContext context) {
        int kind = node.getNodeKind();
        long h = 8680314229351636154L;
        h ^= (long)node.getFingerprint() << 25;
        if (options.namespacePrefixesSignificant) {
            h ^= (long)node.getPrefix().hashCode() << 13;
        }
        if (kind == 3 && !Whitespace.isAllWhite(node.getUnicodeStringValue())) {
            String s = node.getStringValue();
            if (options.normalizeSpace) {
                s = Whitespace.collapseWhitespace(s);
            }
            if (options.normalizationForm != null) {
                try {
                    s = NormalizeUnicode.normalize(s, options.normalizationForm);
                }
                catch (XPathException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            h ^= (long)s.hashCode() << 5;
        }
        return h;
    }

    private static boolean compareStrings(String s1, String s2, DeepEqualOptions options, XPathContext context) {
        if (options.normalizeSpace) {
            s1 = Whitespace.collapseWhitespace(s1);
            s2 = Whitespace.collapseWhitespace(s2);
        }
        if (options.normalizationForm != null) {
            try {
                s1 = NormalizeUnicode.normalize(s1, options.normalizationForm);
                s2 = NormalizeUnicode.normalize(s2, options.normalizationForm);
            }
            catch (XPathException e) {
                return false;
            }
        }
        return options.stringCollator.comparesEqual(StringView.of(s1), StringView.of(s2));
    }

    private static boolean isIgnorable(NodeInfo node, DeepEqualOptions options) {
        int kind = node.getNodeKind();
        if (kind == 8) {
            return !options.commentsSignificant;
        }
        if (kind == 7) {
            return !options.processingInstructionsSignificant;
        }
        if (kind == 3) {
            return !options.preserveSpace && Whitespace.isAllWhite(node.getUnicodeStringValue());
        }
        return false;
    }

    private static void explain(ErrorReporter reporter, String message, DeepEqualOptions options, NodeInfo n1, NodeInfo n2) {
        if (options.debug) {
            reporter.report(new XmlProcessingIncident("deep-equal() " + (String)(n1 != null && n2 != null ? "comparing " + Navigator.getPath(n1) + " to " + Navigator.getPath(n2) + ": " : ": ") + message).asWarning());
        }
    }

    private static String showKind(Item item) {
        if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 3 && Whitespace.isAllWhite(item.getUnicodeStringValue())) {
            return "whitespace text() node";
        }
        return Type.displayTypeName(item);
    }

    private static String showNamespaces(HashSet<NamespaceBinding> bindings) {
        StringBuilder sb = new StringBuilder(256);
        for (NamespaceBinding binding : bindings) {
            sb.append(binding.getPrefix());
            sb.append("=");
            sb.append(binding.getNamespaceUri());
            sb.append(" ");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static SequenceIterator mergeAdjacentTextNodes(SequenceIterator in) throws XPathException {
        Item next;
        ArrayList<Item> items = new ArrayList<Item>(20);
        boolean prevIsText = false;
        UnicodeBuilder textBuffer = new UnicodeBuilder();
        while ((next = in.next()) != null) {
            if (next instanceof NodeInfo && ((NodeInfo)next).getNodeKind() == 3) {
                textBuffer.accept(next.getUnicodeStringValue());
                prevIsText = true;
                continue;
            }
            if (prevIsText) {
                Orphan textNode = new Orphan(null);
                textNode.setNodeKind((short)3);
                textNode.setStringValue(textBuffer.toUnicodeString());
                items.add(textNode);
                textBuffer.clear();
            }
            prevIsText = false;
            items.add(next);
        }
        if (prevIsText) {
            Orphan textNode = new Orphan(null);
            textNode.setNodeKind((short)3);
            textNode.setStringValue(textBuffer.toUnicodeString());
            items.add(textNode);
        }
        return new ListIterator.Of(items);
    }

    @Override
    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        MapItem suppliedOptions;
        Item arg3 = arguments.length >= 3 ? arguments[2].head() : null;
        String collationName = arg3 == null ? this.getRetainedStaticContext().getDefaultCollationName() : arg3.getStringValue();
        MapItem options = new DictionaryMap();
        if (arguments.length >= 4 && (suppliedOptions = (MapItem)arguments[3].head()) != null) {
            options = suppliedOptions;
        }
        DeepEqualOptions eqOptions = new DeepEqualOptions(options, collationName, context);
        boolean b = DeepEqual.deepEqual(arguments[0].iterate(), arguments[1].iterate(), context, eqOptions);
        return BooleanValue.get(b);
    }

    @Override
    public String getStreamerName() {
        return "DeepEqual";
    }

    static {
        OptionsParameter o = new OptionsParameter();
        o.addAllowedOption("base-uri", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("comments", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("debug", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("false-on-error", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("id-property", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("idrefs-property", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("in-scope-namespaces", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("namespace-prefixes", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("nilled-property", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("normalize-space", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("preserve-space", SequenceType.SINGLE_BOOLEAN, BooleanValue.TRUE);
        o.addAllowedOption("processing-instructions", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("text-boundaries", SequenceType.SINGLE_BOOLEAN, BooleanValue.TRUE);
        o.addAllowedOption("timezones", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("type-annotations", SequenceType.SINGLE_BOOLEAN, BooleanValue.FALSE);
        o.addAllowedOption("type-variety", SequenceType.SINGLE_BOOLEAN, BooleanValue.TRUE);
        o.addAllowedOption("typed-values", SequenceType.SINGLE_BOOLEAN, BooleanValue.TRUE);
        o.addAllowedOption("normalization-form", SequenceType.OPTIONAL_STRING, EmptySequence.getInstance());
        o.setAllowedValues("normalization-form", "FOJS0005", "NFC", "NFD", "NFKC", "NFKD");
        o.addAllowedOption("unordered-elements", BuiltInAtomicType.QNAME.zeroOrMore(), EmptySequence.getInstance());
        OPTION_DETAILS = o;
    }

    public static class DeepEqualOptions {
        public boolean baseUriSignificant = false;
        public boolean commentsSignificant = false;
        public boolean debug = false;
        public boolean falseOnError = false;
        public boolean idSignificant = false;
        public boolean idrefSignificant = false;
        public boolean inScopeNamespacesSignificant = false;
        public boolean namespacePrefixesSignificant = false;
        public String normalizationForm = null;
        public boolean nilledSignificant = false;
        public boolean normalizeSpace = false;
        public boolean processingInstructionsSignificant = false;
        public boolean textBoundariesSignificant = true;
        public boolean timezonesSignificant = false;
        public boolean typeAnnotationsSignificant = false;
        public boolean typeVarietySignificant = true;
        public boolean typedValuesSignificant = true;
        public Set<StructuredQName> unorderedElements = Collections.emptySet();
        public boolean preserveSpace = true;
        public String collationName;
        public StringCollator stringCollator;
        public AtomicComparer comparer;
        private static final String[] booleanOptions = new String[]{"base-uri", "comments", "debug", "false-on-error", "id-property", "idrefs-property", "in-scope-namespaces", "namespace-prefixes", "nilled-property", "normalize-space", "preserve-space", "processing-instructions", "text-boundaries", "timezones", "type-annotations", "type-variety", "typed-values"};

        public DeepEqualOptions() {
        }

        public DeepEqualOptions(MapItem map, String collationName, XPathContext context) throws XPathException {
            GroundedValue listedElements;
            Map<String, GroundedValue> values = OPTION_DETAILS.processSuppliedOptions(map, context);
            for (String string : booleanOptions) {
                this.setBooleanOption(values, string);
            }
            GroundedValue normForm = map.get(new StringValue("normalization-form"));
            if (normForm != null) {
                this.normalizationForm = normForm.getStringValue();
            }
            if ((listedElements = map.get(new StringValue("unordered-elements"))) != null) {
                this.unorderedElements = new HashSet<StructuredQName>();
                for (Item item : listedElements.asIterable()) {
                    if (!(item instanceof QNameValue)) continue;
                    this.unorderedElements.add(((QNameValue)item).getStructuredQName());
                }
            }
            this.collationName = collationName;
            this.stringCollator = context.getConfiguration().getCollation(collationName);
            if (this.stringCollator == null) {
                throw new XPathException("Unknown collation " + collationName, "FOCH0002");
            }
            this.comparer = GenericAtomicComparer.makeAtomicComparer(BuiltInAtomicType.ANY_ATOMIC, BuiltInAtomicType.ANY_ATOMIC, this.stringCollator, context);
            if (this.normalizeSpace || this.normalizationForm != null) {
                this.comparer = new NormalizingComparer(this.comparer, this);
            }
        }

        public static DeepEqualOptions defaultOptions() {
            return new DeepEqualOptions();
        }

        private void setBooleanOption(Map<String, GroundedValue> map, String optionName) throws XPathException {
            Sequence value = map.get(optionName);
            if (value != null) {
                boolean booleanValue = ExpressionTool.effectiveBooleanValue(value.iterate());
                switch (optionName) {
                    case "base-uri": {
                        this.baseUriSignificant = booleanValue;
                        return;
                    }
                    case "comments": {
                        this.commentsSignificant = booleanValue;
                        return;
                    }
                    case "debug": {
                        this.debug = booleanValue;
                        return;
                    }
                    case "false-on-error": {
                        this.falseOnError = booleanValue;
                        return;
                    }
                    case "id-property": {
                        this.idSignificant = booleanValue;
                        return;
                    }
                    case "idrefs-property": {
                        this.idrefSignificant = booleanValue;
                        return;
                    }
                    case "in-scope-namespaces": {
                        this.inScopeNamespacesSignificant = booleanValue;
                        return;
                    }
                    case "namespace-prefixes": {
                        this.namespacePrefixesSignificant = booleanValue;
                        return;
                    }
                    case "nilled-property": {
                        this.nilledSignificant = booleanValue;
                        return;
                    }
                    case "normalize-space": {
                        this.normalizeSpace = booleanValue;
                        return;
                    }
                    case "preserve-space": {
                        this.preserveSpace = booleanValue;
                        return;
                    }
                    case "processing-instructions": {
                        this.processingInstructionsSignificant = booleanValue;
                        return;
                    }
                    case "text-boundaries": {
                        this.textBoundariesSignificant = booleanValue;
                        return;
                    }
                    case "timezones": {
                        this.timezonesSignificant = booleanValue;
                        return;
                    }
                    case "type-annotations": {
                        this.typeAnnotationsSignificant = booleanValue;
                        return;
                    }
                    case "type-variety": {
                        this.typeVarietySignificant = booleanValue;
                        return;
                    }
                    case "typed-values": {
                        this.typedValuesSignificant = booleanValue;
                        return;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
    }

    private static class NormalizingComparer
    implements AtomicComparer {
        private AtomicComparer baseComparer;
        private DeepEqualOptions options;

        public NormalizingComparer(AtomicComparer baseComparer, DeepEqualOptions options) {
            this.baseComparer = baseComparer;
            this.options = options;
        }

        @Override
        public StringCollator getCollator() {
            return this.baseComparer.getCollator();
        }

        @Override
        public AtomicComparer provideContext(XPathContext context) {
            this.baseComparer = this.baseComparer.provideContext(context);
            return this;
        }

        @Override
        public int compareAtomicValues(AtomicValue v0, AtomicValue v1) throws NoDynamicContextException {
            return this.baseComparer.compareAtomicValues(v0, v1);
        }

        @Override
        public boolean comparesEqual(AtomicValue v0, AtomicValue v1) throws NoDynamicContextException {
            if (v0 instanceof StringValue && v1 instanceof StringValue) {
                UnicodeString u0 = v0.getUnicodeStringValue();
                UnicodeString u1 = v1.getUnicodeStringValue();
                if (this.options.normalizeSpace) {
                    u0 = Whitespace.collapseWhitespace(u0);
                    u1 = Whitespace.collapseWhitespace(u1);
                }
                if (this.options.normalizationForm != null) {
                    try {
                        u0 = StringView.of(NormalizeUnicode.normalize(u0.toString(), this.options.normalizationForm));
                    }
                    catch (XPathException e) {
                        throw new IllegalArgumentException(e);
                    }
                    try {
                        u1 = StringView.of(NormalizeUnicode.normalize(u1.toString(), this.options.normalizationForm));
                    }
                    catch (XPathException e) {
                        throw new IllegalArgumentException();
                    }
                }
                return this.getCollator().comparesEqual(u0, u1);
            }
            return this.baseComparer.comparesEqual(v0, v1);
        }

        @Override
        public String save() {
            return null;
        }
    }
}

