/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;

public abstract class RegexFunction
extends SystemFunction
implements StatefulSystemFunction {
    private RegularExpression staticRegex;

    public RegularExpression getStaticRegex() {
        return this.staticRegex;
    }

    private void tryToBindRegularExpression(Expression[] arguments) {
        if (arguments[1] instanceof StringLiteral && arguments[arguments.length - 1] instanceof StringLiteral) {
            try {
                Configuration config = this.getRetainedStaticContext().getConfiguration();
                UnicodeString re = ((StringLiteral)arguments[1]).getGroundedValue().getUnicodeStringValue();
                String flags = ((StringLiteral)arguments[arguments.length - 1]).stringify();
                Object hostLang = "XP30";
                if (config.getXsdVersion() == 11) {
                    hostLang = (String)hostLang + "/XSD11";
                }
                ArrayList<String> warnings = new ArrayList<String>(1);
                this.staticRegex = config.compileRegularExpression(re, flags, (String)hostLang, warnings);
                if (!this.allowRegexMatchingEmptyString() && this.staticRegex.matches(EmptyUnicodeString.getInstance())) {
                    this.staticRegex = null;
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
    }

    @Override
    public RegexFunction copy() {
        RegexFunction copy = (RegexFunction)SystemFunction.makeFunction(this.getFunctionName().getLocalPart(), this.getRetainedStaticContext(), this.getArity());
        copy.staticRegex = this.staticRegex;
        return copy;
    }

    protected abstract boolean allowRegexMatchingEmptyString();

    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        this.tryToBindRegularExpression(arguments);
        return super.makeFunctionCall(arguments);
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        this.tryToBindRegularExpression(arguments);
        return super.makeOptimizedFunctionCall(visitor, contextInfo, arguments);
    }

    protected RegularExpression getRegularExpression(Sequence[] args, int regexPos, int flagsPos) throws XPathException {
        if (this.staticRegex != null) {
            return this.staticRegex;
        }
        Configuration config = this.getRetainedStaticContext().getConfiguration();
        Item regexItem = args[regexPos].head();
        if (regexItem == null) {
            if (this.getRetainedStaticContext().getPackageData().getHostLanguageVersion() >= 40) {
                return null;
            }
            XPathException err = new XPathException("Regular expression argument must not be an empty sequence (unless 4.0 is enabled)", "XPTY0004");
            err.setIsTypeError(true);
            throw err;
        }
        UnicodeString regexArg = regexItem.getUnicodeStringValue();
        String flags = "";
        if (flagsPos < args.length) {
            Item flagsItem = args[flagsPos].head();
            if (flagsItem == null && this.getRetainedStaticContext().getPackageData().getHostLanguageVersion() < 40) {
                XPathException err = new XPathException("Flags argument must not be an empty sequence (unless 4.0 is enabled)", "XPTY0004");
                err.setIsTypeError(true);
                throw err;
            }
            flags = flagsItem == null ? "" : flagsItem.getStringValue();
        }
        Object hostLang = "XP30";
        if (config.getXsdVersion() == 11) {
            hostLang = (String)hostLang + "/XSD11";
        }
        ArrayList<String> warnings = new ArrayList<String>(1);
        RegularExpression regex = config.compileRegularExpression(regexArg, flags, (String)hostLang, warnings);
        if (!this.allowRegexMatchingEmptyString() && regex.matches(EmptyUnicodeString.getInstance())) {
            throw new XPathException("The regular expression must not be one that matches a zero-length string", "FORX0003");
        }
        return regex;
    }
}

