/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.hof;

import java.util.function.Supplier;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.AbstractFunction;
import net.sf.saxon.functions.hof.FunctionLiteral;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class CoercedFunction
extends AbstractFunction {
    private FunctionItem targetFunction;
    private final SpecificFunctionType requiredType;
    private final boolean allowReducedArity;

    public CoercedFunction(FunctionItem targetFunction, SpecificFunctionType requiredType, boolean allowReducedArity) throws XPathException {
        if (!(targetFunction.getArity() == requiredType.getArity() || targetFunction.getArity() <= requiredType.getArity() && allowReducedArity)) {
            throw new XPathException(CoercedFunction.wrongArityMessage(targetFunction, requiredType.getArity()), "XPTY0004");
        }
        this.targetFunction = targetFunction;
        this.requiredType = requiredType;
        this.allowReducedArity = allowReducedArity;
    }

    public CoercedFunction(SpecificFunctionType requiredType) {
        this.requiredType = requiredType;
        this.allowReducedArity = false;
    }

    public void setTargetFunction(FunctionItem targetFunction) throws XPathException {
        if (!(targetFunction.getArity() == this.requiredType.getArity() || targetFunction.getArity() <= this.requiredType.getArity() && this.allowReducedArity)) {
            throw new XPathException(CoercedFunction.wrongArityMessage(targetFunction, this.requiredType.getArity()), "XPTY0004");
        }
        this.targetFunction = targetFunction;
    }

    @Override
    public void typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (this.targetFunction instanceof AbstractFunction) {
            ((AbstractFunction)this.targetFunction).typeCheck(visitor, contextItemType);
        }
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        return this.requiredType;
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.targetFunction.getFunctionName();
    }

    @Override
    public String getDescription() {
        return this.targetFunction.getDescription() + " (used where the required type is " + String.valueOf(this.requiredType) + ")";
    }

    @Override
    public int getArity() {
        return this.requiredType.getArity();
    }

    @Override
    public AnnotationList getAnnotations() {
        return this.targetFunction.getAnnotations();
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        SpecificFunctionType req = this.requiredType;
        SequenceType[] argTypes = this.targetFunction.getFunctionItemType().getArgumentTypes();
        int suppliedArity = Math.min(args.length, argTypes.length);
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        Sequence[] targetArgs = new Sequence[suppliedArity];
        for (int i = 0; i < suppliedArity; ++i) {
            GroundedValue gVal = args[i].materialize();
            if (argTypes[i].matches(gVal, th)) {
                targetArgs[i] = gVal;
                continue;
            }
            int pos = i;
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(0, this.targetFunction.getDescription(), pos);
            targetArgs[i] = th.applyFunctionConversionRules(gVal, argTypes[i], role, Loc.NONE);
        }
        GroundedValue rawResult = this.targetFunction.call(context, targetArgs).materialize();
        if (req.getResultType().matches(rawResult, th)) {
            return rawResult;
        }
        Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(5, this.getDescription(), 0);
        return th.applyFunctionConversionRules(rawResult, req.getResultType(), role, Loc.NONE);
    }

    private static String wrongArityMessage(FunctionItem supplied, int expected) {
        return "The supplied function (" + supplied.getDescription() + ") has " + FunctionCall.plural(supplied.getArity(), "parameter") + " - expected a function with " + FunctionCall.plural(expected, "parameter");
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("coercedFn");
        out.emitAttribute("type", this.requiredType.toExportString());
        new FunctionLiteral(this.targetFunction).export(out);
        out.endElement();
    }
}

