/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ListConstructorFunction;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnionConstructorFunction;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.hof.AtomicConstructorFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class ConstructorFunctionLibrary
implements FunctionLibrary {
    private final Configuration config;

    public ConstructorFunctionLibrary(Configuration config) {
        this.config = config;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        NamespaceResolver resolver;
        if (functionName.getArity() != 1) {
            return null;
        }
        NamespaceUri uri = functionName.getComponentName().getNamespaceUri();
        if (uri.equals(NamespaceUri.ANONYMOUS)) {
            return null;
        }
        String localName = functionName.getComponentName().getLocalPart();
        SchemaType type = this.config.getSchemaType(new StructuredQName("", uri, localName));
        if (type == null || type.isComplexType()) {
            return null;
        }
        NamespaceResolver namespaceResolver = resolver = ((SimpleType)type).isNamespaceSensitive() ? staticContext.getNamespaceResolver() : null;
        if (type instanceof AtomicType) {
            return new AtomicConstructorFunction((AtomicType)type, resolver);
        }
        if (type instanceof ListType) {
            return new ListConstructorFunction((ListType)type, resolver, true);
        }
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            AtomicValue value = (AtomicValue)arguments[0].head();
            if (value == null) {
                return EmptySequence.getInstance();
            }
            return UnionConstructorFunction.cast(value, (UnionType)((Object)type), resolver, context.getConfiguration().getConversionRules());
        });
        SequenceType returnType = ((UnionType)((Object)type)).getResultTypeOfCast();
        return new CallableFunction(1, (Callable)callable, (FunctionItemType)new SpecificFunctionType(new SequenceType[]{SequenceType.OPTIONAL_ATOMIC}, returnType));
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        if (functionName.getArity() != 1) {
            return false;
        }
        SchemaType type = this.config.getSchemaType(functionName.getComponentName());
        if (type == null || type.isComplexType()) {
            return false;
        }
        if (type.isAtomicType() && ((AtomicType)type).isAbstract()) {
            return false;
        }
        return type != AnySimpleType.getInstance();
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] arguments, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) {
        SchemaType st;
        NamespaceUri uri = functionName.getComponentName().getNamespaceUri();
        String localName = functionName.getComponentName().getLocalPart();
        boolean builtInNamespace = uri.equals(NamespaceUri.SCHEMA);
        if (builtInNamespace) {
            SimpleType type;
            int languageVersion = env.getXPathVersion();
            if (languageVersion >= 40 && arguments.length == 0) {
                SymbolicName.F f1 = new SymbolicName.F(functionName.getComponentName(), 1);
                return this.bind(f1, new Expression[]{new ContextItemExpression()}, keywords, env, reasons);
            }
            if (functionName.getArity() != 1) {
                reasons.add("A constructor function must have exactly one argument");
                return null;
            }
            if (keywords != null && !keywords.isEmpty()) {
                if (keywords.size() != 1) {
                    reasons.add("The keyword for the sole argument of a constructor function is 'value'");
                    return null;
                }
                for (Map.Entry<StructuredQName, Integer> kw : keywords.entrySet()) {
                    if (kw.getKey().getEQName().equals("Q{}value")) {
                        if (kw.getValue() == 0) continue;
                        reasons.add("The 'value' keyword in a constructor function call must be the first and only argument");
                        return null;
                    }
                    reasons.add("The argument keyword '" + kw.getKey().getEQName() + " is not allowed in a constructor function call");
                    return null;
                }
            }
            if ((type = Type.getBuiltInSimpleType(uri, localName)) != null) {
                NamespaceResolver resolver;
                if (type.isAtomicType()) {
                    if (((AtomicType)type).isAbstract()) {
                        reasons.add("Abstract type used in constructor function: {" + String.valueOf(uri) + "}" + localName);
                        return null;
                    }
                    CastExpression cast = new CastExpression(arguments[0], (AtomicType)type, true);
                    if (arguments[0] instanceof StringLiteral) {
                        cast.setOperandIsStringLiteral(true);
                    }
                    return cast;
                }
                if (type.isUnionType()) {
                    resolver = env.getNamespaceResolver();
                    UnionConstructorFunction ucf = new UnionConstructorFunction((UnionType)((Object)type), resolver, true);
                    return new StaticFunctionCall(ucf, arguments);
                }
                resolver = env.getNamespaceResolver();
                try {
                    ListConstructorFunction lcf = new ListConstructorFunction((ListType)type, resolver, true);
                    return new StaticFunctionCall(lcf, arguments);
                }
                catch (MissingComponentException e) {
                    reasons.add("Missing schema component: " + e.getMessage());
                    return null;
                }
            }
            reasons.add("Unknown constructor function: {" + String.valueOf(uri) + "}" + localName);
            return null;
        }
        if (arguments.length == 1 && (st = this.config.getSchemaType(new StructuredQName("", uri, localName))) instanceof SimpleType) {
            if (st instanceof AtomicType) {
                return new CastExpression(arguments[0], (AtomicType)st, true);
            }
            if (st instanceof ListType && env.getXPathVersion() >= 30) {
                NamespaceResolver resolver = env.getNamespaceResolver();
                try {
                    ListConstructorFunction lcf = new ListConstructorFunction((ListType)st, resolver, true);
                    return new StaticFunctionCall(lcf, arguments);
                }
                catch (MissingComponentException e) {
                    reasons.add("Missing schema component: " + e.getMessage());
                    return null;
                }
            }
            if (((SimpleType)st).isUnionType() && env.getXPathVersion() >= 30) {
                NamespaceResolver resolver = env.getNamespaceResolver();
                UnionConstructorFunction ucf = new UnionConstructorFunction((UnionType)((Object)st), resolver, true);
                return new StaticFunctionCall(ucf, arguments);
            }
        }
        return null;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }
}

