/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.File;
import java.nio.file.Paths;
import java.util.Objects;
import net.sf.saxon.style.PackageVersion;

public class DocumentKey {
    public static final boolean CASE_BLIND_FILES = new File("a").equals(new File("A"));
    private String displayValue;
    private String normalizedValue;
    private String packageName = "";
    private PackageVersion packageVersion = PackageVersion.ONE;

    public DocumentKey(String uri) {
        Objects.requireNonNull(uri);
        this.displayValue = uri;
        this.normalizedValue = DocumentKey.normalizeURI(uri);
    }

    public DocumentKey(String uri, String packageName, PackageVersion version) {
        Objects.requireNonNull(uri);
        this.displayValue = uri;
        this.normalizedValue = DocumentKey.normalizeURI(uri);
        this.packageName = packageName == null ? "" : packageName;
        this.packageVersion = version;
    }

    public String getAbsoluteURI() {
        return this.displayValue;
    }

    public String toString() {
        return this.displayValue;
    }

    public boolean equals(Object obj) {
        return obj instanceof DocumentKey && this.normalizedValue.equals(((DocumentKey)obj).normalizedValue) && this.packageName.equals(((DocumentKey)obj).packageName) && this.packageVersion.equals(((DocumentKey)obj).packageVersion);
    }

    public int hashCode() {
        return this.normalizedValue.hashCode();
    }

    public static String normalizeURI(String uri) {
        if (uri == null) {
            return null;
        }
        if (((String)uri).startsWith("FILE:")) {
            uri = "file:" + ((String)uri).substring(5);
        }
        if (((String)uri).startsWith("file:")) {
            if (((String)uri).startsWith("file:///")) {
                uri = "file:/" + ((String)uri).substring(8);
            }
            if (((String)uri).startsWith("file:/")) {
                try {
                    String cpath = DocumentKey.getCanonicalPath((String)uri);
                    uri = "file:" + cpath;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (CASE_BLIND_FILES) {
                uri = ((String)uri).toLowerCase();
            }
        }
        return uri;
    }

    private static String getCanonicalPath(String uri) {
        return Paths.get(uri.substring(6), new String[0]).normalize().toString();
    }
}

