/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Iterator;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.tree.jiter.MonoIterator;

public final class NamespaceBinding
implements NamespaceBindingSet {
    private final String prefix;
    private final NamespaceUri uri;
    public static final NamespaceBinding XML = new NamespaceBinding("xml", NamespaceUri.XML);
    public static final NamespaceBinding DEFAULT_UNDECLARATION = new NamespaceBinding("", NamespaceUri.NULL);
    public static final NamespaceBinding[] EMPTY_ARRAY = new NamespaceBinding[0];

    public NamespaceBinding(String prefix, NamespaceUri uri) {
        this.prefix = prefix;
        this.uri = uri;
        if (prefix == null || uri == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public NamespaceUri getNamespaceUri(String prefix) {
        return prefix.equals(this.prefix) ? this.uri : null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public NamespaceUri getNamespaceUri() {
        return this.uri;
    }

    public boolean isXmlNamespace() {
        return this.prefix.equals("xml");
    }

    public boolean isDefaultUndeclaration() {
        return this.prefix.isEmpty() && this.uri == NamespaceUri.NULL;
    }

    @Override
    public Iterator<NamespaceBinding> iterator() {
        return new MonoIterator<NamespaceBinding>(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof NamespaceBinding && this.prefix.equals(((NamespaceBinding)obj).getPrefix()) && this.uri.equals(((NamespaceBinding)obj).getNamespaceUri());
    }

    public int hashCode() {
        return this.prefix.hashCode() ^ this.uri.hashCode();
    }

    public String toString() {
        return this.prefix + "=" + String.valueOf(this.uri);
    }
}

