/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.List;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.AscendingRangeIterator;
import net.sf.saxon.expr.DescendingRangeIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.functions.Count;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ItemConsumer;
import net.sf.saxon.om.LargeAttributeMap;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonAttributeMap;
import net.sf.saxon.om.SmallAttributeMap;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AnyExternalObject;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SingletonClosure;

public class SequenceTool {
    public static final int INDETERMINATE_ORDERING = Integer.MIN_VALUE;

    public static GroundedValue toGroundedValue(SequenceIterator iterator) {
        if (iterator instanceof GroundedIterator && ((GroundedIterator)iterator).isActuallyGrounded()) {
            return ((GroundedIterator)iterator).materialize();
        }
        return SequenceExtent.from(iterator).reduce();
    }

    public static Sequence toMemoSequence(SequenceIterator iterator) throws XPathException {
        if (iterator instanceof EmptyIterator) {
            return EmptySequence.getInstance();
        }
        if (iterator instanceof GroundedIterator && ((GroundedIterator)iterator).isActuallyGrounded()) {
            try {
                return SequenceTool.toGroundedValue(iterator);
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }
        return new MemoSequence(iterator);
    }

    public static Sequence toLazySequence(SequenceIterator iterator) throws XPathException {
        if (iterator instanceof GroundedIterator && ((GroundedIterator)iterator).isActuallyGrounded() && !(iterator instanceof AscendingRangeIterator) && !(iterator instanceof DescendingRangeIterator)) {
            try {
                return SequenceTool.toGroundedValue(iterator);
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }
        return new LazySequence(iterator);
    }

    public static boolean supportsGetLength(SequenceIterator iterator) {
        return iterator instanceof LastPositionFinder && ((LastPositionFinder)((Object)iterator)).supportsGetLength();
    }

    public static int getLength(SequenceIterator iterator) {
        try {
            return ((LastPositionFinder)((Object)iterator)).getLength();
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("getLength() not available in " + String.valueOf(iterator.getClass()));
        }
    }

    public static void supply(SequenceIterator iter, ItemConsumer<? super Item> consumer) {
        try {
            Item item;
            while ((item = iter.next()) != null) {
                consumer.accept(item);
            }
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    public static boolean isUnrepeatable(Sequence seq) {
        return seq instanceof LazySequence || seq instanceof Closure && !(seq instanceof MemoClosure) && !(seq instanceof SingletonClosure);
    }

    public static int getLength(Sequence sequence) throws XPathException {
        if (sequence instanceof GroundedValue) {
            return ((GroundedValue)sequence).getLength();
        }
        return Count.count(sequence.iterate());
    }

    public static boolean hasLength(SequenceIterator iter, int length) throws XPathException {
        if (SequenceTool.supportsGetLength(iter)) {
            return ((LastPositionFinder)((Object)iter)).getLength() == length;
        }
        int n = 0;
        while (iter.next() != null) {
            if (n++ != length) continue;
            iter.close();
            return false;
        }
        return length == 0;
    }

    public static boolean sameLength(SequenceIterator a, SequenceIterator b) {
        Item itB;
        Item itA;
        if (SequenceTool.supportsGetLength(a) && SequenceTool.supportsGetLength(b)) {
            return ((LastPositionFinder)((Object)a)).getLength() == ((LastPositionFinder)((Object)b)).getLength();
        }
        do {
            itA = a.next();
            itB = b.next();
        } while (itA != null && itB != null);
        if (itA != null) {
            a.close();
        }
        if (itB != null) {
            b.close();
        }
        return itA == null && itB == null;
    }

    public static Item itemAt(Sequence sequence, int index) {
        if (sequence instanceof Item && index == 0) {
            return (Item)sequence;
        }
        try {
            return sequence.materialize().itemAt(index);
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    public static Item asItem(Sequence sequence) throws XPathException {
        if (sequence instanceof Item) {
            return (Item)sequence;
        }
        SequenceIterator iter = sequence.iterate();
        Item first = iter.next();
        if (first == null) {
            return null;
        }
        if (iter.next() != null) {
            throw new XPathException("Sequence contains more than one item");
        }
        return first;
    }

    public static FocusIterator focusTracker(SequenceIterator basis) {
        if (basis instanceof FocusIterator) {
            return (FocusIterator)basis;
        }
        return new FocusTrackingIterator(basis);
    }

    public static Object convertToJava(Item item) throws XPathException {
        switch (item.getGenre()) {
            case NODE: {
                Object node = item;
                while (node instanceof VirtualNode) {
                    node = ((VirtualNode)node).getRealNode();
                }
                return node;
            }
            case FUNCTION: 
            case ARRAY: 
            case MAP: {
                return item;
            }
            case EXTERNAL: {
                return ((AnyExternalObject)item).getWrappedObject();
            }
            case ATOMIC: {
                AtomicValue value = (AtomicValue)item;
                switch (value.getItemType().getPrimitiveType()) {
                    case 513: 
                    case 518: 
                    case 520: 
                    case 529: 
                    case 631: {
                        return value.getStringValue();
                    }
                    case 514: {
                        return ((BooleanValue)value).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 515: {
                        return ((DecimalValue)value).getDecimalValue();
                    }
                    case 533: {
                        return ((NumericValue)value).longValue();
                    }
                    case 517: {
                        return ((DoubleValue)value).getDoubleValue();
                    }
                    case 516: {
                        return Float.valueOf(((FloatValue)value).getFloatValue());
                    }
                    case 519: {
                        return ((DateTimeValue)value).getCalendar().getTime();
                    }
                    case 521: {
                        return ((DateValue)value).getCalendar().getTime();
                    }
                    case 528: {
                        return ((Base64BinaryValue)value).getBinaryValue();
                    }
                    case 527: {
                        return ((HexBinaryValue)value).getBinaryValue();
                    }
                }
                return item;
            }
        }
        return item;
    }

    public static UnicodeString getStringValue(Sequence sequence) throws XPathException {
        UnicodeBuilder ub = new UnicodeBuilder();
        SequenceTool.supply(sequence.iterate(), item -> {
            if (!ub.isEmpty()) {
                ub.append(' ');
            }
            ub.accept(item.getUnicodeStringValue());
        });
        return ub.toUnicodeString();
    }

    public static String stringify(Sequence sequence) throws XPathException {
        StringBuilder sb = new StringBuilder(64);
        SequenceTool.supply(sequence.iterate(), item -> {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(item.getStringValue());
        });
        return sb.toString();
    }

    public static ItemType getItemType(Sequence sequence, TypeHierarchy th) {
        if (sequence instanceof Item) {
            return Type.getItemType((Item)sequence, th);
        }
        if (sequence instanceof IntegerRange) {
            return BuiltInAtomicType.INTEGER;
        }
        if (sequence instanceof GroundedValue) {
            try {
                Item item;
                ItemType type = null;
                SequenceIterator iter = sequence.iterate();
                while ((item = iter.next()) != null && (type = type == null ? Type.getItemType(item, th) : Type.getCommonSuperType(type, Type.getItemType(item, th), th)) != AnyItemType.getInstance()) {
                }
                return type == null ? ErrorType.getInstance() : type;
            }
            catch (UncheckedXPathException err) {
                return AnyItemType.getInstance();
            }
        }
        return AnyItemType.getInstance();
    }

    public static UType getUType(Sequence sequence) {
        if (sequence instanceof Item) {
            return UType.getUType((Item)sequence);
        }
        if (sequence instanceof GroundedValue) {
            Item item;
            UType type = UType.VOID;
            SequenceIterator iter = sequence.iterate();
            while ((item = iter.next()) != null && (type = type.union(UType.getUType(item))) != UType.ANY) {
            }
            return type;
        }
        return UType.ANY;
    }

    public static int getCardinality(Sequence sequence) {
        if (sequence instanceof Item) {
            return 16384;
        }
        if (sequence instanceof GroundedValue) {
            int len = ((GroundedValue)sequence).getLength();
            switch (len) {
                case 0: {
                    return 8192;
                }
                case 1: {
                    return 16384;
                }
            }
            return 49152;
        }
        try {
            SequenceIterator iter = sequence.iterate();
            Item item = iter.next();
            if (item == null) {
                return 8192;
            }
            item = iter.next();
            return item == null ? 16384 : 49152;
        }
        catch (UncheckedXPathException err) {
            return 49152;
        }
    }

    public static void process(Sequence value, Outputter output, Location locationId) throws XPathException {
        try {
            SequenceTool.supply(value.iterate(), it -> output.append(it, locationId, 524288));
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException().maybeWithLocation(locationId);
        }
    }

    public static Sequence[] makeSequenceArray(int length) {
        return new Sequence[length];
    }

    public static Sequence[] fromItems(Item ... items) {
        Sequence[] seq = new Sequence[items.length];
        System.arraycopy(items, 0, seq, 0, items.length);
        return seq;
    }

    public static AttributeMap attributeMapFromList(List<AttributeInfo> list) {
        int n = list.size();
        if (n == 0) {
            return EmptyAttributeMap.getInstance();
        }
        if (n == 1) {
            return SingletonAttributeMap.of(list.get(0));
        }
        if (n <= 8) {
            return new SmallAttributeMap(list);
        }
        return new LargeAttributeMap(list);
    }

    public static GroundedValue itemOrEmpty(Item item) {
        if (item == null) {
            return EmptySequence.getInstance();
        }
        return item;
    }
}

