/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.instruct.OriginalFunction;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLOverride;
import net.sf.saxon.style.XSLUsePackage;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class XSLOriginalLibrary
implements FunctionLibrary {
    private static final XSLOriginalLibrary THE_INSTANCE = new XSLOriginalLibrary();
    public static StructuredQName XSL_ORIGINAL = new StructuredQName("xsl", NamespaceUri.XSLT, "original");

    public static XSLOriginalLibrary getInstance() {
        return THE_INSTANCE;
    }

    private XSLOriginalLibrary() {
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) {
        try {
            FunctionItem target = this.getFunctionItem(functionName, env);
            if (target == null) {
                return null;
            }
            return new StaticFunctionCall(target, staticArgs);
        }
        catch (XPathException e) {
            reasons.add(e.getMessage());
            return null;
        }
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        return false;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext env) throws XPathException {
        if (functionName.getComponentKind() == 160 && functionName.getComponentName().hasURI(NamespaceUri.XSLT) && functionName.getComponentName().getLocalPart().equals("original") && env instanceof ExpressionContext) {
            ExpressionContext expressionContext = (ExpressionContext)env;
            StyleElement containingElement = expressionContext.getStyleElement();
            XSLFunction overridingFunction = (XSLFunction)containingElement.findAncestorElement(160);
            if (overridingFunction == null) {
                throw new XPathException("Function name xsl:original can only be used within xsl:function", "XTSE3058");
            }
            SymbolicName.F originalName = overridingFunction.getSymbolicName();
            StyleElement override = (StyleElement)overridingFunction.getParent();
            if (!(override instanceof XSLOverride)) {
                throw new XPathException("Function name xsl:original can only be used within xsl:override", "XPST0017");
            }
            XSLUsePackage use = (XSLUsePackage)override.getParent();
            assert (use != null);
            Component overridden = use.getUsedPackage().getComponent(originalName);
            if (overridden == null) {
                throw new XPathException("Function " + String.valueOf(originalName) + " does not exist in used package", "XTSE3058");
            }
            return new OriginalFunction(overridden);
        }
        return null;
    }
}

