/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SingletonClosure;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntIterator;

public class Err {
    public static final int ELEMENT = 1;
    public static final int ATTRIBUTE = 2;
    public static final int FUNCTION = 3;
    public static final int VALUE = 4;
    public static final int VARIABLE = 5;
    public static final int GENERAL = 6;
    public static final int URI = 7;
    public static final int EQNAME = 8;

    public static String wrap(UnicodeString cs) {
        return Err.wrap(cs, 6);
    }

    public static String wrap(String cs) {
        return Err.wrap(cs, 6);
    }

    public static String wrap(String cs, int valueType) {
        return Err.wrap(StringView.of(cs), valueType);
    }

    public static String wrap(UnicodeString cs, int valueType) {
        Object s;
        if (cs == null) {
            return "(NULL)";
        }
        StringBuilder sb = new StringBuilder(64);
        IntIterator iter = cs.codePoints();
        int len = 0;
        block15: while (iter.hasNext()) {
            int c = iter.next();
            ++len;
            switch (c) {
                case 10: {
                    sb.append("\\n");
                    continue block15;
                }
                case 9: {
                    sb.append("\\t");
                    continue block15;
                }
                case 13: {
                    sb.append("\\r");
                    continue block15;
                }
            }
            if (c < 32) {
                sb.append("\\x");
                sb.append(Integer.toHexString(c));
                continue;
            }
            sb.appendCodePoint(c);
        }
        if (valueType == 1 || valueType == 2) {
            s = sb.toString();
            if (((String)s).startsWith("{")) {
                s = "Q" + (String)s;
            }
            if (((String)s).startsWith("Q{")) {
                try {
                    StructuredQName qn = StructuredQName.fromEQName(sb.toString());
                    String uri = Err.abbreviateURI(qn.getNamespaceUri());
                    s = "Q{" + uri + "}" + qn.getLocalPart();
                }
                catch (Exception e) {
                    s = sb.toString();
                }
            }
        } else {
            s = valueType == 7 ? Err.abbreviateURI(sb.toString()) : (valueType == 8 ? Err.abbreviateEQName(sb.toString()) : (len > 30 ? sb.toString().substring(0, 30) + "..." : sb.toString()));
        }
        switch (valueType) {
            case 1: {
                return "<" + (String)s + ">";
            }
            case 2: {
                return "@" + (String)s;
            }
            case 3: {
                return (String)s + "()";
            }
            case 5: {
                return "$" + (String)s;
            }
            case 4: {
                return "\"" + (String)s + "\"";
            }
            case 8: {
                return s;
            }
        }
        return "{" + (String)s + "}";
    }

    public static String depict(Item item) {
        if (item == null) {
            return "(*null*)";
        }
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    return "doc(" + Err.abbreviateURI(node.getSystemId()) + ")";
                }
                case 1: {
                    return "<" + node.getDisplayName() + ">";
                }
                case 2: {
                    return "@" + node.getDisplayName() + "=\"" + String.valueOf(node.getUnicodeStringValue()) + "\"";
                }
                case 3: {
                    return "text{" + String.valueOf(Err.truncate30(node.getUnicodeStringValue())) + "}";
                }
                case 8: {
                    return "<!--...-->";
                }
                case 7: {
                    return "<?" + node.getLocalPart() + "...?>";
                }
                case 13: {
                    return "xmlns:" + node.getLocalPart() + "=" + Err.abbreviateURI(node.getStringValue());
                }
            }
            return "";
        }
        return item.toShortString();
    }

    public static String depictCodepoint(int cp) {
        String hexCode = "#x" + Integer.toHexString(cp);
        if (cp >= 20 && cp < 55296) {
            return "'" + (char)cp + "'(" + hexCode + ")";
        }
        return hexCode;
    }

    public static CharSequence depictSequence(Sequence seq) {
        if (seq == null) {
            return "(*null*)";
        }
        try {
            if (seq instanceof GroundedValue) {
                GroundedValue val = (GroundedValue)seq;
                if (val.getLength() == 0) {
                    return "()";
                }
                if (val.getLength() == 1) {
                    return Err.depict(seq.head());
                }
                return Err.depictSequenceStart(val.iterate(), 3, val.getLength());
            }
            if (seq instanceof SingletonClosure) {
                SingletonClosure sc = (SingletonClosure)seq;
                if (sc.isBuilt()) {
                    return sc.asItem() == null ? "()" : Err.depict(sc.asItem());
                }
                return "(*not-yet-evaluated singleton*)";
            }
            if (seq instanceof MemoClosure) {
                MemoClosure mc = (MemoClosure)seq;
                if ((seq = mc.getSequenceAsIs()) == null) {
                    return "(*not-yet-evaluated sequence*)";
                }
                return Err.depictSequence(seq);
            }
            return "(*lazily evaluated*)";
        }
        catch (Exception e) {
            return "(*unreadable*)";
        }
    }

    public static String depictSequenceStart(SequenceIterator seq, int max, int actual) {
        Item next;
        StringBuilder sb = new StringBuilder(64);
        int count = 0;
        sb.append(" (");
        while ((next = seq.next()) != null) {
            if (count++ > 0) {
                sb.append(", ");
            }
            if (count > max) {
                sb.append("... [" + actual + "])");
                return sb.toString();
            }
            sb.append(Err.depict(next));
        }
        sb.append(") ");
        return sb.toString();
    }

    public static UnicodeString truncate30(UnicodeString cs) {
        if (cs.length() <= 30L) {
            return Whitespace.collapseWhitespace(cs);
        }
        return Whitespace.collapseWhitespace(cs.substring(0L, 30L)).concat(BMPString.of("..."));
    }

    public static String abbreviateURI(String uri) {
        if (uri == null) {
            return "";
        }
        int lastSlash = ((String)(((String)uri).endsWith("/") ? ((String)uri).substring(0, ((String)uri).length() - 1) : uri)).lastIndexOf(47);
        if (lastSlash < 0) {
            if (((String)uri).length() > 15) {
                uri = "..." + ((String)uri).substring(((String)uri).length() - 15);
            }
            return uri;
        }
        return "..." + ((String)uri).substring(lastSlash);
    }

    public static String abbreviateURI(NamespaceUri uri) {
        return Err.abbreviateURI(uri.toString());
    }

    public static String abbreviateEQName(String eqName) {
        try {
            if (((String)eqName).startsWith("{")) {
                eqName = "Q" + (String)eqName;
            }
            StructuredQName sq = StructuredQName.fromEQName((String)eqName);
            return "Q{" + Err.abbreviateURI(sq.getNamespaceUri()) + "}" + sq.getLocalPart();
        }
        catch (Exception e) {
            return eqName;
        }
    }

    public static String wrap(Expression exp) {
        if (ExpressionTool.expressionSize(exp) < 10 && !(exp instanceof Instruction)) {
            return "{" + String.valueOf(exp) + "}";
        }
        return exp.getExpressionName();
    }

    public static String describeGenre(Genre genre) {
        switch (genre) {
            case ANY: {
                return "any item";
            }
            case ATOMIC: {
                return "an atomic value";
            }
            case NODE: {
                return "a node";
            }
            case FUNCTION: {
                return "a function";
            }
            case MAP: {
                return "a map";
            }
            case ARRAY: {
                return "an array";
            }
        }
        return "an external object";
    }

    public static String describeVisibility(Visibility vis) {
        return vis.toString().toLowerCase();
    }

    public static String show(Location loc) {
        return Err.abbreviateURI(loc.getSystemId()) + "#" + loc.getLineNumber();
    }

    public static String indefiniteArticleFor(String s, boolean caps) {
        if ("aeioux".indexOf(s.charAt(0)) >= 0) {
            return caps ? "An" : "an";
        }
        return caps ? "A" : "a";
    }
}

