/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QualifiedNameValue;

public final class NotationValue
extends QualifiedNameValue {
    public NotationValue(String prefix, NamespaceUri uri, String localName, boolean check) throws XPathException {
        super(new StructuredQName(prefix, uri, localName), BuiltInAtomicType.NOTATION);
        if (check && !NameChecker.isValidNCName(localName)) {
            throw new XPathException("Malformed local name in NOTATION: '" + localName + "'", "FORG0001");
        }
        String string = prefix = prefix == null ? "" : prefix;
        if (check && uri.isEmpty() && prefix.length() != 0) {
            throw new XPathException("NOTATION has null namespace but non-empty prefix", "FOCA0002");
        }
    }

    public NotationValue(String prefix, String uri, String localName, boolean check) throws XPathException {
        this(prefix, NamespaceUri.of(uri), localName, check);
    }

    public NotationValue(String prefix, NamespaceUri uri, String localName) {
        super(new StructuredQName(prefix, uri, localName), BuiltInAtomicType.NOTATION);
    }

    public NotationValue(String prefix, NamespaceUri uri, String localName, AtomicType typeLabel) {
        super(new StructuredQName(prefix, uri, localName), typeLabel);
    }

    public NotationValue(StructuredQName qName, AtomicType typeLabel) {
        super(qName, typeLabel);
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        return new NotationValue(this.getStructuredQName(), typeLabel);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.NOTATION;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NotationValue && this.qName.equals(((NotationValue)other).qName);
    }

    @Override
    public int hashCode() {
        return this.qName.hashCode();
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) throws NoDynamicContextException {
        return null;
    }

    @Override
    public String show() {
        return "NOTATION(" + this.getClarkName() + ")";
    }
}

