/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Objects;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Genre;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyExternalObject;
import net.sf.saxon.value.StringValue;

public class ObjectValue<T>
implements AnyExternalObject {
    private final T value;
    private final Class<? extends T> theInterface;

    public ObjectValue(T object) {
        this.value = Objects.requireNonNull(object, "External object cannot wrap a Java null");
        this.theInterface = null;
    }

    public ObjectValue(T object, Class<? extends T> theInterface) {
        this.value = Objects.requireNonNull(object, "External object cannot wrap a Java null");
        this.theInterface = Objects.requireNonNull(theInterface);
    }

    public Class<? extends T> getInterface() {
        return this.theInterface;
    }

    @Override
    public Genre getGenre() {
        return Genre.EXTERNAL;
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        return StringView.of(this.value.toString()).tidy();
    }

    @Override
    public StringValue atomize() {
        return new StringValue(this.getUnicodeStringValue().tidy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemType getItemType(TypeHierarchy th) {
        Configuration configuration = th.getConfiguration();
        synchronized (configuration) {
            return JavaExternalObjectType.of(this.value.getClass());
        }
    }

    public static String displayTypeName(Object value) {
        return "java-type:" + value.getClass().getName();
    }

    @Override
    public boolean effectiveBooleanValue() {
        return true;
    }

    public T getObject() {
        return this.value;
    }

    @Override
    public Object getWrappedObject() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other instanceof ObjectValue) {
            T o = ((ObjectValue)other).value;
            return this.value.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toShortString() {
        String v = this.value.toString();
        if (v.startsWith(this.value.getClass().getName())) {
            return v;
        }
        return "(" + this.value.getClass().getSimpleName() + ")" + String.valueOf(Err.truncate30(StringView.tidy(this.value.toString())));
    }
}

