/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;

public abstract class SequenceWriter
extends SequenceReceiver {
    private Receiver outputter = null;
    private Builder builder = null;
    private int level = 0;
    private boolean inStartTag = false;

    public SequenceWriter(PipelineConfiguration pipe) {
        super(pipe);
    }

    public abstract void write(Item var1) throws XPathException;

    public void startDocument(int properties) throws XPathException {
        if (this.outputter == null) {
            this.createTree((properties & 0x8000) != 0);
        }
        if (this.level++ == 0) {
            this.outputter.startDocument(properties);
        }
    }

    private void createTree(boolean mutable) throws XPathException {
        TreeModel model;
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        this.builder = mutable ? ((model = pipe.getController().getModel()).isMutable() ? pipe.getController().makeBuilder() : new LinkedTreeBuilder(pipe)) : pipe.getController().makeBuilder();
        this.builder.setPipelineConfiguration(pipe);
        this.builder.setSystemId(this.getSystemId());
        this.builder.setTiming(false);
        NamespaceReducer reducer = new NamespaceReducer(this.builder);
        ComplexContentOutputter cco = new ComplexContentOutputter(pipe);
        cco.setHostLanguage(pipe.getHostLanguage());
        cco.setReceiver(reducer);
        this.outputter = cco;
        this.outputter.setSystemId(this.systemId);
        this.outputter.setPipelineConfiguration(this.getPipelineConfiguration());
        this.outputter.open();
    }

    protected boolean adviseReuse() {
        if (this.builder instanceof TinyBuilder) {
            TinyTree tree = ((TinyBuilder)this.builder).getTree();
            return tree != null && tree.getNumberOfNodes() < 20000;
        }
        return false;
    }

    public void endDocument() throws XPathException {
        if (--this.level == 0) {
            this.outputter.endDocument();
            DocumentInfo doc = (DocumentInfo)this.builder.getCurrentRoot();
            this.append(doc, 0, 2);
        }
        this.previousAtomic = false;
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.outputter == null) {
            this.createTree((properties & 0x8000) != 0);
        }
        this.outputter.startElement(elemName, typeCode, locationId, properties);
        ++this.level;
        this.inStartTag = true;
        this.previousAtomic = false;
    }

    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.outputter.endElement();
        if (--this.level == 0) {
            this.outputter.close();
            NodeInfo element = this.builder.getCurrentRoot();
            this.append(element, 0, 2);
        }
        this.previousAtomic = false;
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)13);
            o.setNodeName(new NoNamespaceName(namespaceBinding.getPrefix()));
            o.setStringValue(namespaceBinding.getURI());
            this.append(o, 0, 2);
        } else {
            this.outputter.namespace(namespaceBinding, properties);
        }
        this.previousAtomic = false;
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)2);
            o.setNodeName(attName);
            o.setStringValue(value);
            o.setTypeAnnotation(typeCode);
            this.append(o, locationId, 2);
        } else {
            this.outputter.attribute(attName, typeCode, value, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        this.inStartTag = false;
        this.outputter.startContent();
        this.previousAtomic = false;
    }

    public void characters(CharSequence s, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(s.toString());
            this.append(o, locationId, 2);
        } else if (s.length() > 0) {
            if (this.inStartTag) {
                this.startContent();
            }
            this.outputter.characters(s, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void comment(CharSequence comment, int locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)8);
            o.setStringValue(comment);
            this.append(o, locationId, 2);
        } else {
            this.outputter.comment(comment, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeName(new NoNamespaceName(target));
            o.setNodeKind((short)7);
            o.setStringValue(data);
            this.append(o, locationId, 2);
        } else {
            this.outputter.processingInstruction(target, data, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void close() throws XPathException {
        this.previousAtomic = false;
        if (this.outputter != null) {
            this.outputter.close();
        }
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (item == null) {
            return;
        }
        if (this.level == 0) {
            this.write(item);
            this.previousAtomic = false;
        } else if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.outputter.characters(" ", 0, 0);
            }
            this.outputter.characters(item.getStringValueCS(), 0, 0);
            this.previousAtomic = true;
        } else {
            if (item instanceof FunctionItem) {
                XPathException err = new XPathException("Cannot write a function item to an XML tree", "XPTY0004");
                err.setLocator(this.getPipelineConfiguration().getSourceLocation(locationId));
                throw err;
            }
            NodeInfo node = (NodeInfo)item;
            if (node.getNodeKind() == 2 && ((SimpleType)node.getSchemaType()).isNamespaceSensitive()) {
                XPathException err = new XPathException("Cannot copy attributes whose type is namespace-sensitive (QName or NOTATION): " + Err.wrap(node.getDisplayName(), 2));
                err.setErrorCode(this.getPipelineConfiguration().getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086");
                throw err;
            }
            ((NodeInfo)item).copy(this.outputter, 6, locationId);
            this.previousAtomic = false;
        }
    }

    public boolean usesTypeAnnotations() {
        return this.outputter == null || this.outputter.usesTypeAnnotations();
    }
}

