/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;

public class ConstructorFunctionLibrary
implements FunctionLibrary {
    private Configuration config;

    public ConstructorFunctionLibrary(Configuration config) {
        this.config = config;
    }

    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        if (arity != 1 && arity != -1) {
            return null;
        }
        String uri = functionName.getURI();
        String local = functionName.getLocalPart();
        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
            SimpleType type = Type.getBuiltInSimpleType(uri, local);
            if (type != null) {
                if (type.isAtomicType()) {
                    if (((AtomicType)type).isAbstract()) {
                        return null;
                    }
                    return new SequenceType[]{SequenceType.makeSequenceType((AtomicType)type, 24576), SequenceType.OPTIONAL_ATOMIC};
                }
                assert (type.isListType());
                return new SequenceType[]{SequenceType.makeSequenceType((AtomicType)((ListType)type).getItemType(), 57344), SequenceType.OPTIONAL_ATOMIC};
            }
            return null;
        }
        int fingerprint = this.config.getNamePool().getFingerprint(uri, local);
        if (fingerprint == -1) {
            return null;
        }
        SchemaType schemaType = this.config.getSchemaType(fingerprint);
        if (schemaType instanceof SimpleType) {
            SimpleType st = (SimpleType)schemaType;
            if (st instanceof AtomicType) {
                return new SequenceType[]{SequenceType.makeSequenceType((AtomicType)st, 24576), SequenceType.OPTIONAL_ATOMIC};
            }
            if (st.isListType()) {
                SimpleType sType = ((ListType)st).getItemType();
                if (sType instanceof AtomicType) {
                    return new SequenceType[]{SequenceType.makeSequenceType((AtomicType)sType, 57344), SequenceType.OPTIONAL_ATOMIC};
                }
                return new SequenceType[]{SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), SequenceType.OPTIONAL_ATOMIC};
            }
            if (st.isUnionType()) {
                return new SequenceType[]{SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), SequenceType.OPTIONAL_ATOMIC};
            }
        }
        return null;
    }

    public Expression bind(StructuredQName functionName, Expression[] arguments, StaticContext env, Container container) throws XPathException {
        int fp;
        String uri = functionName.getURI();
        String localName = functionName.getLocalPart();
        String targetURI = uri;
        boolean builtInNamespace = uri.equals("http://www.w3.org/2001/XMLSchema");
        if (builtInNamespace) {
            if (arguments.length != 1) {
                throw new XPathException("A constructor function must have exactly one argument");
            }
            SimpleType type = Type.getBuiltInSimpleType(uri, localName);
            if (type != null) {
                if (type.isAtomicType()) {
                    if (((AtomicType)type).isAbstract()) {
                        XPathException err = new XPathException("Abstract type used in constructor function: {" + uri + '}' + localName);
                        err.setErrorCode("XPST0017");
                        err.setIsStaticError(true);
                        throw err;
                    }
                    CastExpression cast = new CastExpression(arguments[0], (AtomicType)type, true);
                    if (arguments[0] instanceof StringLiteral) {
                        cast.setOperandIsStringLiteral(true);
                    }
                    if (type.isNamespaceSensitive()) {
                        cast.setNamespaceResolver(new SavedNamespaceContext(env.getNamespaceResolver()));
                    }
                    cast.setContainer(container);
                    return cast;
                }
                if (type == ErrorType.getInstance()) {
                    XPathException err = new XPathException("Unsupported constructor function: {" + uri + '}' + localName);
                    err.setErrorCode("XPST0017");
                    err.setIsStaticError(true);
                    throw err;
                }
                assert (type.isListType());
                Expression exp = env.getConfiguration().obtainOptimizer().makeCastToList(arguments[0], (ListType)type, true);
                exp.setContainer(container);
                return exp;
            }
            XPathException err = new XPathException("Unknown constructor function: {" + uri + '}' + localName);
            err.setErrorCode("XPST0017");
            err.setIsStaticError(true);
            throw err;
        }
        if (arguments.length == 1 && (fp = this.config.getNamePool().getFingerprint(uri, localName)) != -1) {
            SchemaType st = this.config.getSchemaType(fp);
            if (st instanceof AtomicType) {
                CastExpression cast = new CastExpression(arguments[0], (AtomicType)st, true);
                cast.setContainer(container);
                return cast;
            }
            if (st instanceof ListType && DecimalValue.THREE.equals(env.getXPathLanguageLevel())) {
                return env.getConfiguration().obtainOptimizer().makeCastToList(arguments[0], (ListType)st, true);
            }
            if (st instanceof ItemType && ((ItemType)((Object)st)).isPlainType() && DecimalValue.THREE.equals(env.getXPathLanguageLevel())) {
                Expression cast = env.getConfiguration().obtainOptimizer().makeCastToUnion(arguments[0], st, true);
                cast.setContainer(container);
                return cast;
            }
        }
        return null;
    }

    public FunctionLibrary copy() {
        return this;
    }
}

