/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.regex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.saxon.expr.sort.IntRangeSet;
import net.sf.saxon.functions.regex.CaseVariants;
import net.sf.saxon.functions.regex.Categories;
import net.sf.saxon.functions.regex.RegexSyntaxException;
import net.sf.saxon.functions.regex.RegexTranslator;
import net.sf.saxon.functions.regex.UnicodeBlocks;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDK15RegexTranslator
extends RegexTranslator {
    public static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    public static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private static final CharClass DOT_SCHEMA = Complement.makeComplement(new Union(new CharClass[]{new SingleChar(10), new SingleChar(13)}));
    private static final CharClass ESC_W = new Union(new CharClass[]{JDK15RegexTranslator.getSafeCategory('P'), JDK15RegexTranslator.getSafeCategory('Z'), JDK15RegexTranslator.getSafeCategory('C')});
    private static final CharClass ESC_w = Complement.makeComplement(ESC_W);
    private static final CharClass ESC_s = new Union(new CharClass[]{new SingleChar(32), new SingleChar(10), new SingleChar(13), new SingleChar(9)});
    private static final CharClass ESC_S = Complement.makeComplement(ESC_s);
    private static final CharClass ESC_i_11 = JDK15RegexTranslator.makeNameCharClass((byte)32);
    private static final CharClass ESC_I_11 = Complement.makeComplement(ESC_i_11);
    private static final CharClass ESC_c_11 = JDK15RegexTranslator.makeNameCharClass((byte)16);
    private static final CharClass ESC_C_11 = Complement.makeComplement(ESC_c_11);

    private static CharClass getSafeCategory(char c) {
        try {
            return JDK15RegexTranslator.getCategoryCharClass(c);
        }
        catch (RegexSyntaxException err) {
            throw new AssertionError((Object)err);
        }
    }

    private JDK15RegexTranslator() {
    }

    public static String translate(CharSequence regExp, int options, int flagbits, List<RegexSyntaxException> warnings) throws RegexSyntaxException {
        JDK15RegexTranslator tr = new JDK15RegexTranslator();
        tr.regExp = regExp;
        tr.length = regExp.length();
        tr.xmlVersion = (options & 1) != 0 ? 11 : 10;
        tr.xsdVersion = (options & 0x20) != 0 ? 11 : 10;
        tr.isXPath = (options & 6) != 0;
        tr.isXPath30 = (options & 4) != 0;
        tr.ignoreWhitespace = (flagbits & 4) != 0;
        tr.caseBlind = (flagbits & 2) != 0;
        tr.warnings = warnings == null ? new ArrayList() : warnings;
        tr.advance();
        tr.translateTop();
        return tr.result.toString();
    }

    @Override
    protected boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                if (this.isXPath30 && this.curChar == '?') {
                    this.copyCurChar();
                    this.expect(':');
                    this.copyCurChar();
                    this.translateRegExp();
                    this.expect(')');
                    this.copyCurChar();
                    return true;
                }
                int thisCapture = ++this.currentCapture;
                this.translateRegExp();
                this.expect(')');
                this.captures.add(thisCapture);
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.inCharClassExpr = true;
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                if (this.isXPath) break;
                DOT_SCHEMA.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                if (this.isXPath) {
                    this.copyCurChar();
                    return true;
                }
                this.result.append('\\');
                break;
            }
            default: {
                int thisChar;
                int[] variants;
                if (!this.caseBlind || (variants = CaseVariants.getCaseVariants(thisChar = this.absorbSurrogatePair())).length <= 0) break;
                CharClass[] chars = new CharClass[variants.length + 1];
                chars[0] = new SingleChar(thisChar);
                for (int i = 0; i < variants.length; ++i) {
                    chars[i + 1] = new SingleChar(variants[i]);
                }
                Union union = new Union(chars);
                union.output(this.result);
                this.advance();
                return true;
            }
        }
        this.copyCurChar();
        return true;
    }

    private static CharClass makeNameCharClass(byte mask) {
        ArrayList<SimpleCharClass> ranges = new ArrayList<SimpleCharClass>();
        ranges.add(new SingleChar(58));
        IntRangeSet members = XMLCharacterData.getCategory(mask);
        int used = members.getNumberOfRanges();
        int[] startPoints = members.getStartPoints();
        int[] endPoints = members.getEndPoints();
        for (int i = 0; i < used; ++i) {
            if (startPoints[i] == endPoints[i]) {
                ranges.add(new SingleChar(startPoints[i]));
                continue;
            }
            ranges.add(new CharRange(startPoints[i], endPoints[i]));
        }
        return new Union(ranges);
    }

    private CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SingleChar(10, true);
            }
            case 'r': {
                this.advance();
                return new SingleChar(13, true);
            }
            case 't': {
                this.advance();
                return new SingleChar(9, true);
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return ESC_i_11;
            }
            case 'I': {
                this.advance();
                return ESC_I_11;
            }
            case 'c': {
                this.advance();
                return ESC_c_11;
            }
            case 'C': {
                this.advance();
                return ESC_C_11;
            }
            case 'd': {
                this.advance();
                return JDK15RegexTranslator.getSubCategoryCharClass("Nd");
            }
            case 'D': {
                this.advance();
                return Complement.makeComplement(JDK15RegexTranslator.getSubCategoryCharClass("Nd"));
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp(false);
            }
            case 'P': {
                this.advance();
                return Complement.makeComplement(this.parseProp(true));
            }
            case '0': {
                throw this.makeException("backreference cannot start with digit zero");
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.isXPath) {
                    if (this.inCharClassExpr) {
                        throw this.makeException("back-reference not allowed within []");
                    }
                    int backRef = this.curChar - 48;
                    while (true) {
                        int backRef2;
                        this.advance();
                        int c1 = "0123456789".indexOf(this.curChar);
                        if (c1 < 0 || (backRef2 = backRef * 10 + c1) > this.currentCapture) break;
                        backRef = backRef2;
                    }
                    if (!this.captures.contains(backRef)) {
                        String explanation = backRef > this.currentCapture ? "(no such group)" : "(group not yet closed)";
                        throw this.makeException("invalid backreference \\" + backRef + " " + explanation);
                    }
                    return new BackReference(backRef, this.caseBlind);
                }
                throw this.makeException("digit not allowed after \\");
            }
            case '$': {
                if (this.isXPath) break;
            }
            default: {
                throw this.makeException("invalid escape sequence");
            }
        }
        SingleChar tem = new SingleChar(this.curChar, true);
        this.advance();
        return tem;
    }

    private CharClass parseProp(boolean complement) throws RegexSyntaxException {
        this.expect('{');
        int start = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (JDK15RegexTranslator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        CharSequence propertyNameCS = this.regExp.subSequence(start, this.pos - 1);
        if (this.ignoreWhitespace && !this.inCharClassExpr) {
            propertyNameCS = Whitespace.removeAllWhitespace(propertyNameCS);
        }
        String propertyName = propertyNameCS.toString();
        this.advance();
        switch (propertyName.length()) {
            case 0: {
                throw this.makeException("empty property name");
            }
            case 2: {
                return JDK15RegexTranslator.getSubCategoryCharClass(propertyName);
            }
            case 1: {
                return JDK15RegexTranslator.getCategoryCharClass(propertyName.charAt(0));
            }
        }
        if (propertyName.startsWith("Is")) {
            String blockName = propertyName.substring(2);
            CharClass cc = UnicodeBlocks.getBlock(blockName);
            if (cc != null) {
                return cc;
            }
            if (this.xsdVersion == 11) {
                this.warnings.add(this.makeException("invalid block name", blockName));
                if (complement) {
                    return Empty.getInstance();
                }
                return Complement.makeComplement(Empty.getInstance());
            }
            throw this.makeException("invalid block name", blockName);
        }
        throw this.makeException("invalid property name", propertyName);
    }

    private CharClass parseCharClassExpr() throws RegexSyntaxException {
        boolean compl;
        if (this.curChar == '^') {
            this.advance();
            compl = true;
        } else {
            compl = false;
        }
        ArrayList<CharClass> members = new ArrayList<CharClass>(10);
        do {
            CharClass lower = this.parseCharClassEscOrXmlChar();
            members.add(lower);
            if (this.curChar == ']' || this.eos) {
                this.addCaseVariant(lower, members);
                break;
            }
            if (this.curChar == '-') {
                char next = this.regExp.charAt(this.pos);
                if (next == '[') {
                    this.addCaseVariant(lower, members);
                    this.advance();
                    break;
                }
                if (next == ']') {
                    if (this.isXPath30) {
                        throw this.makeException("hyphen in a character range must be followed by a single character");
                    }
                    this.addCaseVariant(lower, members);
                    continue;
                }
                this.advance();
                CharClass upper = this.parseCharClassEscOrXmlChar();
                if (lower.getSingleChar() < 0 || upper.getSingleChar() < 0) {
                    throw this.makeException("the ends of a range must be single characters");
                }
                if (lower.getSingleChar() > upper.getSingleChar()) {
                    throw this.makeException("invalid range (start > end)");
                }
                if (lower instanceof SingleChar && lower.getSingleChar() == 45 && !((SingleChar)lower).isEscaped) {
                    throw this.makeException("range cannot start with unescaped hyphen");
                }
                if (upper instanceof SingleChar && upper.getSingleChar() == 45 && !((SingleChar)upper).isEscaped) {
                    throw this.makeException("range cannot end with unescaped hyphen");
                }
                members.set(members.size() - 1, new CharRange(lower.getSingleChar(), upper.getSingleChar()));
                if (this.caseBlind) {
                    int v;
                    if (lower.getSingleChar() == 97 && upper.getSingleChar() == 122) {
                        members.add(new CharRange(65, 90));
                        for (v = 0; v < CaseVariants.ROMAN_VARIANTS.length; ++v) {
                            members.add(new SingleChar(CaseVariants.ROMAN_VARIANTS[v]));
                        }
                    } else if (lower.getSingleChar() == 65 && upper.getSingleChar() == 90) {
                        members.add(new CharRange(97, 122));
                        for (v = 0; v < CaseVariants.ROMAN_VARIANTS.length; ++v) {
                            members.add(new SingleChar(CaseVariants.ROMAN_VARIANTS[v]));
                        }
                    } else {
                        for (int k = lower.getSingleChar(); k <= upper.getSingleChar(); ++k) {
                            int[] variants;
                            for (int variant : variants = CaseVariants.getCaseVariants(k)) {
                                members.add(new SingleChar(variant));
                            }
                        }
                    }
                }
                if (this.curChar != '-' || this.regExp.charAt(this.pos) != '[') continue;
                this.advance();
                break;
            }
            this.addCaseVariant(lower, members);
        } while (this.curChar != ']');
        if (this.eos) {
            this.expect(']');
        }
        CharClass result = members.size() == 1 ? (CharClass)members.get(0) : new Union(members);
        if (compl) {
            result = Complement.makeComplement(result);
        }
        if (this.curChar == '[') {
            this.advance();
            result = new Subtraction(result, this.parseCharClassExpr());
            this.expect(']');
        }
        this.inCharClassExpr = false;
        this.advance();
        return result;
    }

    private void addCaseVariant(CharClass lower, List<CharClass> members) {
        if (this.caseBlind) {
            int[] variants;
            for (int variant : variants = CaseVariants.getCaseVariants(lower.getSingleChar())) {
                members.add(new SingleChar(variant));
            }
        }
    }

    private CharClass parseCharClassEscOrXmlChar() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '[': 
            case ']': {
                throw this.makeException("character must be escaped", new String(new char[]{this.curChar}));
            }
        }
        SingleChar tem = new SingleChar(this.absorbSurrogatePair());
        this.advance();
        return tem;
    }

    private static synchronized CharClass getCategoryCharClass(char category) throws RegexSyntaxException {
        ArrayList<CharClass> ranges = new ArrayList<CharClass>(10);
        for (String sub : Categories.CATEGORIES.keySet()) {
            if (sub.charAt(0) != category) continue;
            ranges.add(JDK15RegexTranslator.getSubCategoryCharClass(sub));
        }
        if (ranges.isEmpty()) {
            throw new RegexSyntaxException("Unknown category " + category);
        }
        return new Union(ranges);
    }

    private static CharClass getSubCategoryCharClass(String category) throws RegexSyntaxException {
        int[] codes = Categories.CATEGORIES.get(category);
        if (codes == null) {
            throw new RegexSyntaxException("Unknown category " + category);
        }
        ArrayList<SimpleCharClass> ranges = new ArrayList<SimpleCharClass>(codes.length / 2);
        for (int i = 0; i < codes.length; i += 2) {
            int start = codes[i];
            int end = codes[i + 1];
            if (start == end) {
                ranges.add(new SingleChar(start));
                continue;
            }
            ranges.add(new CharRange(start, end));
        }
        return new Union(ranges);
    }

    public static void main(String[] args) throws RegexSyntaxException {
        String s = JDK15RegexTranslator.translate(args[0], 7, 0, null);
        System.err.println(StringValue.diagnosticDisplay(s));
        try {
            Pattern.compile(s);
        }
        catch (Exception err) {
            System.err.println("Error: " + err.getMessage());
        }
        System.err.println();
    }

    static class Complement
    extends CharClass {
        private final CharClass cc;

        private Complement(CharClass cc) {
            this.cc = cc;
        }

        static CharClass makeComplement(CharClass cc) {
            if (cc instanceof Complement) {
                return ((Complement)cc).cc;
            }
            return new Complement(cc);
        }

        void output(FastStringBuffer buf) {
            this.cc.outputComplement(buf);
        }

        void outputComplement(FastStringBuffer buf) {
            this.cc.output(buf);
        }
    }

    static class BackReference
    extends CharClass {
        private final int n;
        private boolean caseBlind = false;

        BackReference(int n, boolean caseBlind) {
            this.n = n;
            this.caseBlind = caseBlind;
        }

        void output(FastStringBuffer buf) {
            this.inClassOutput(buf);
        }

        void outputComplement(FastStringBuffer buf) {
            this.inClassOutput(buf);
        }

        void inClassOutput(FastStringBuffer buf) {
            buf.append("(?" + (this.caseBlind ? "i" : "") + ":\\" + this.n + ")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Union
    extends CharClass {
        private final List<? extends CharClass> members;

        Union(CharClass[] v) {
            this(Union.toList(v));
        }

        Union(CharClass a, CharClass b) {
            this(new CharClass[]{a, b});
        }

        private static List toList(CharClass[] v) {
            ArrayList<CharClass> members = new ArrayList<CharClass>(5);
            members.addAll(Arrays.asList(v));
            return members;
        }

        Union(List<? extends CharClass> members) {
            this.members = members;
        }

        @Override
        void output(FastStringBuffer buf) {
            buf.append('[');
            int len = this.members.size();
            for (int i = 0; i < len; ++i) {
                this.members.get(i).output(buf);
            }
            buf.append(']');
        }

        @Override
        void outputComplement(FastStringBuffer buf) {
            boolean first = true;
            for (CharClass charClass : this.members) {
                if (!(charClass instanceof SimpleCharClass)) continue;
                if (first) {
                    buf.append("[^");
                    first = false;
                }
                ((SimpleCharClass)charClass).inClassOutput(buf);
            }
            for (CharClass charClass : this.members) {
                if (charClass instanceof SimpleCharClass) continue;
                if (first) {
                    buf.append('[');
                    first = false;
                } else {
                    buf.append("&&");
                }
                charClass.outputComplement(buf);
            }
            if (first) {
                buf.append("[\u0001-");
                buf.appendWideChar(0x10FFFF);
                buf.append("]");
            } else {
                buf.append(']');
            }
        }
    }

    static class Subtraction
    extends CharClass {
        private final CharClass cc1;
        private final CharClass cc2;

        Subtraction(CharClass cc1, CharClass cc2) {
            this.cc1 = cc1;
            this.cc2 = cc2;
        }

        void output(FastStringBuffer buf) {
            buf.append('[');
            this.cc1.output(buf);
            buf.append("&&");
            this.cc2.outputComplement(buf);
            buf.append(']');
        }

        void outputComplement(FastStringBuffer buf) {
            buf.append('[');
            this.cc1.outputComplement(buf);
            this.cc2.output(buf);
            buf.append(']');
        }
    }

    static class Property
    extends SimpleCharClass {
        private final String name;

        Property(String name) {
            this.name = name;
        }

        void inClassOutput(FastStringBuffer buf) {
            buf.append("\\p{");
            buf.append(this.name);
            buf.append('}');
        }

        void outputComplement(FastStringBuffer buf) {
            buf.append("\\P{");
            buf.append(this.name);
            buf.append('}');
        }
    }

    protected static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        CharRange(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        void inClassOutput(FastStringBuffer buf) {
            if (RegexTranslator.isJavaMetaChar(this.lower)) {
                buf.append('\\');
            }
            buf.appendWideChar(this.lower);
            buf.append('-');
            if (RegexTranslator.isJavaMetaChar(this.upper)) {
                buf.append('\\');
            }
            buf.appendWideChar(this.upper);
        }
    }

    static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
        }

        static Empty getInstance() {
            return instance;
        }

        void output(FastStringBuffer buf) {
            buf.append("\\x00");
        }

        void outputComplement(FastStringBuffer buf) {
            buf.append("[^\\x00]");
        }

        void inClassOutput(FastStringBuffer buf) {
            throw new RuntimeException("BMP output botch");
        }
    }

    static class SingleChar
    extends SimpleCharClass {
        private final int c;
        private boolean isEscaped = false;

        SingleChar(int c) {
            this.c = c;
        }

        SingleChar(int c, boolean isEscaped) {
            this.c = c;
            this.isEscaped = isEscaped;
        }

        int getSingleChar() {
            return this.c;
        }

        void output(FastStringBuffer buf) {
            this.inClassOutput(buf);
        }

        void inClassOutput(FastStringBuffer buf) {
            if (RegexTranslator.isJavaMetaChar(this.c)) {
                buf.append('\\');
                buf.append((char)this.c);
            } else {
                switch (this.c) {
                    case 13: {
                        buf.append("\\r");
                        break;
                    }
                    case 10: {
                        buf.append("\\n");
                        break;
                    }
                    case 9: {
                        buf.append("\\t");
                        break;
                    }
                    case 32: {
                        buf.append("\\x20");
                        break;
                    }
                    default: {
                        buf.appendWideChar(this.c);
                    }
                }
            }
        }
    }

    static abstract class SimpleCharClass
    extends CharClass {
        SimpleCharClass() {
        }

        void output(FastStringBuffer buf) {
            buf.append('[');
            this.inClassOutput(buf);
            buf.append(']');
        }

        void outputComplement(FastStringBuffer buf) {
            buf.append("[^");
            this.inClassOutput(buf);
            buf.append(']');
        }

        abstract void inClassOutput(FastStringBuffer var1);
    }

    protected static abstract class CharClass {
        protected CharClass() {
        }

        abstract void output(FastStringBuffer var1);

        abstract void outputComplement(FastStringBuffer var1);

        int getSingleChar() {
            return -1;
        }
    }
}

