/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.StringValue;

public class GeneralComparison10
extends BinaryExpression
implements Callable {
    protected int singletonOperator;
    protected AtomicComparer comparer;
    private boolean atomize0 = true;
    private boolean atomize1 = true;
    private boolean maybeBoolean0 = true;
    private boolean maybeBoolean1 = true;

    public GeneralComparison10(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
        this.singletonOperator = GeneralComparison.getCorrespondingSingletonOperator(op);
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        StaticContext env = visitor.getStaticContext();
        StringCollator comp = env.getCollation(env.getDefaultCollationName());
        if (comp == null) {
            comp = CodepointCollator.getInstance();
        }
        XPathContext context = env.makeEarlyEvaluationContext();
        this.comparer = new GenericAtomicComparer(comp, context);
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral(this.evaluateItem(context));
        }
        return this;
    }

    public void setAtomicComparer(AtomicComparer comparer) {
        this.comparer = comparer;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        StaticContext env = visitor.getStaticContext();
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        this.operand0 = ExpressionTool.unsorted(opt, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(opt, this.operand1, false);
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            return Literal.makeLiteral(this.evaluateItem(env.makeEarlyEvaluationContext()));
        }
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        ItemType type0 = this.operand0.getItemType(th);
        ItemType type1 = this.operand1.getItemType(th);
        if (type0.isPlainType()) {
            this.atomize0 = false;
        }
        if (type1.isPlainType()) {
            this.atomize1 = false;
        }
        if (th.relationship(type0, BuiltInAtomicType.BOOLEAN) == 4) {
            this.maybeBoolean0 = false;
        }
        if (th.relationship(type1, BuiltInAtomicType.BOOLEAN) == 4) {
            this.maybeBoolean1 = false;
        }
        if (!this.maybeBoolean0 && !this.maybeBoolean1) {
            boolean numeric1;
            int n0 = th.relationship(type0, BuiltInAtomicType.NUMERIC);
            int n1 = th.relationship(type1, BuiltInAtomicType.NUMERIC);
            boolean maybeNumeric0 = n0 != 4;
            boolean maybeNumeric1 = n1 != 4;
            boolean numeric0 = n0 == 2 || n0 == 0;
            boolean bl = numeric1 = n1 == 2 || n1 == 0;
            if (this.operator == 6 || this.operator == 22) {
                if (!maybeNumeric0 && !maybeNumeric1 || numeric0 && numeric1) {
                    GeneralComparison20 gc = new GeneralComparison20(this.operand0, this.operator, this.operand1);
                    BinaryExpression binExp = visitor.getConfiguration().obtainOptimizer().optimizeGeneralComparison(gc, false);
                    ExpressionTool.copyLocationInfo(this, binExp);
                    return visitor.optimize(visitor.typeCheck(binExp, contextItemType), contextItemType);
                }
            } else if (numeric0 && numeric1) {
                GeneralComparison20 gc = new GeneralComparison20(this.operand0, this.operator, this.operand1);
                BinaryExpression binExp = visitor.getConfiguration().obtainOptimizer().optimizeGeneralComparison(gc, false);
                ExpressionTool.copyLocationInfo(this, binExp);
                return visitor.optimize(visitor.typeCheck(binExp, contextItemType), contextItemType);
            }
        }
        return this;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(arguments[0].iterate(), arguments[1].iterate(), context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.effectiveBooleanValue(this.operand0.iterate(context), this.operand1.iterate(context), context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private boolean effectiveBooleanValue(SequenceIterator iter0, SequenceIterator iter1, XPathContext context) throws XPathException {
        boolean iter0used = false;
        boolean iter1used = false;
        if (this.maybeBoolean0) {
            Object i02;
            iter0used = true;
            Object i01 = iter0.next();
            Object object = i02 = i01 == null ? null : iter0.next();
            if (i01 instanceof BooleanValue && i02 == null) {
                iter0.close();
                boolean b = ExpressionTool.effectiveBooleanValue(iter1);
                return GeneralComparison10.compare((BooleanValue)i01, this.singletonOperator, BooleanValue.get(b), this.comparer, context);
            }
            if (i01 == null && !this.maybeBoolean1) {
                iter0.close();
                return false;
            }
        }
        if (this.maybeBoolean1) {
            Object i12;
            iter1used = true;
            Object i11 = iter1.next();
            Object object = i12 = i11 == null ? null : iter1.next();
            if (i11 instanceof BooleanValue && i12 == null) {
                iter1.close();
                if (iter0used) {
                    iter0 = iter0.getAnother();
                }
                boolean b = ExpressionTool.effectiveBooleanValue(iter0);
                return GeneralComparison10.compare(BooleanValue.get(b), this.singletonOperator, (BooleanValue)i11, this.comparer, context);
            }
            if (i11 == null && !this.maybeBoolean0) {
                iter1.close();
                return false;
            }
        }
        if (iter0used) {
            iter0 = iter0.getAnother();
        }
        if (iter1used) {
            iter1 = iter1.getAnother();
        }
        if (this.atomize0) {
            iter0 = Atomizer.getAtomizingIterator(iter0, false);
        }
        if (this.atomize1) {
            iter1 = Atomizer.getAtomizingIterator(iter1, false);
        }
        if (this.operator == 12 || this.operator == 14 || this.operator == 11 || this.operator == 13) {
            final Configuration config = context.getConfiguration();
            ItemMappingFunction map = new ItemMappingFunction(){

                public Item mapItem(Item item) throws XPathException {
                    return NumberFn.convert((AtomicValue)item, config);
                }
            };
            iter0 = new ItemMappingIterator(iter0, map, true);
            iter1 = new ItemMappingIterator(iter1, map, true);
        }
        ArrayList<AtomicValue> seq1 = null;
        AtomicValue item0;
        block2: while ((item0 = (AtomicValue)iter0.next()) != null) {
            if (iter1 == null) {
                AtomicValue item1;
                Iterator listIter1 = seq1.iterator();
                do {
                    if (!listIter1.hasNext()) continue block2;
                } while (!GeneralComparison10.compare(item0, this.singletonOperator, item1 = (AtomicValue)listIter1.next(), this.comparer, context));
                return true;
            }
            while (true) {
                AtomicValue item1;
                if ((item1 = (AtomicValue)iter1.next()) == null) {
                    iter1 = null;
                    if (seq1 == null) return false;
                    continue block2;
                }
                try {
                    if (GeneralComparison10.compare(item0, this.singletonOperator, item1, this.comparer, context)) {
                        return true;
                    }
                    if (seq1 == null) {
                        seq1 = new ArrayList<AtomicValue>(40);
                    }
                    seq1.add(item1);
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
            break;
        }
        return false;
    }

    public Expression copy() {
        GeneralComparison10 gc = new GeneralComparison10(this.operand0.copy(), this.operator, this.operand1.copy());
        gc.comparer = this.comparer;
        gc.atomize0 = this.atomize0;
        gc.atomize1 = this.atomize1;
        gc.maybeBoolean0 = this.maybeBoolean0;
        gc.maybeBoolean1 = this.maybeBoolean1;
        return gc;
    }

    private static boolean compare(AtomicValue a0, int operator, AtomicValue a1, AtomicComparer comparer, XPathContext context) throws XPathException {
        comparer = comparer.provideContext(context);
        ConversionRules rules = context.getConfiguration().getConversionRules();
        BuiltInAtomicType t0 = a0.getPrimitiveType();
        BuiltInAtomicType t1 = a1.getPrimitiveType();
        if (t0.isPrimitiveNumeric() || t1.isPrimitiveNumeric()) {
            DoubleValue v0 = NumberFn.convert(a0, context.getConfiguration());
            DoubleValue v1 = NumberFn.convert(a1, context.getConfiguration());
            return ValueComparison.compare(v0, operator, v1, comparer, false);
        }
        if (t0.equals(BuiltInAtomicType.STRING) || t1.equals(BuiltInAtomicType.STRING) || t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            StringValue s0 = StringValue.makeStringValue(a0.getStringValueCS());
            StringValue s1 = StringValue.makeStringValue(a1.getStringValueCS());
            return ValueComparison.compare(s0, operator, s1, comparer, false);
        }
        if (t0.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            a0 = rules.getStringConverter(t1).convert(a0).asAtomic();
        }
        if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            a1 = rules.getStringConverter(t0).convert(a1).asAtomic();
        }
        return ValueComparison.compare(a0, operator, a1, comparer, false);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    protected void explainExtraAttributes(ExpressionPresenter out) {
        out.emitAttribute("cardinality", "many-to-many (1.0)");
    }
}

