/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class LocalVariableBinding
implements Binding {
    private StructuredQName variableName;
    private SequenceType requiredType;
    private int slotNumber = -999;
    private int refCount = 0;

    public LocalVariableBinding(StructuredQName name, SequenceType type) {
        this.variableName = name;
        this.requiredType = type;
    }

    public LocalVariableBinding copy() {
        LocalVariableBinding lvb = new LocalVariableBinding(this.variableName, this.requiredType);
        lvb.refCount = this.refCount;
        lvb.slotNumber = this.slotNumber;
        return lvb;
    }

    public StructuredQName getVariableQName() {
        return this.variableName;
    }

    public void setRequiredType(SequenceType type) {
        this.requiredType = type;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public IntegerValue[] getIntegerBoundsForVariable() {
        return null;
    }

    public int getNominalReferenceCount() {
        return this.refCount;
    }

    public void addReference(boolean isLoopingReference) {
        if (this.refCount != 10000) {
            this.refCount += isLoopingReference ? 10 : 1;
        }
    }

    public void setIndexedVariable() {
        this.refCount = 10000;
    }

    public void setVariableQName(StructuredQName variableName) {
        this.variableName = variableName;
    }

    public void setSlotNumber(int nr) {
        this.slotNumber = nr;
    }

    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public Sequence evaluateVariable(XPathContext context) throws XPathException {
        return context.evaluateLocalVariable(this.slotNumber);
    }

    public boolean isAssignable() {
        return false;
    }

    public boolean isGlobal() {
        return false;
    }
}

