/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.EventSource;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorToReceiver;
import net.sf.saxon.evpull.PullEventSource;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorHandler;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.pull.StaxBridge;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class Sender {
    private static Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static Class staxSourceClass;

    private Sender() {
    }

    public static void send(Source source, Receiver receiver, ParseOptions options) throws XPathException {
        Controller controller;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        options = options == null ? new ParseOptions(pipe.getParseOptions()) : new ParseOptions(options);
        String systemId = source.getSystemId();
        if (source instanceof AugmentedSource) {
            options.merge(((AugmentedSource)source).getParseOptions());
            systemId = source.getSystemId();
            source = ((AugmentedSource)source).getContainedSource();
        }
        Configuration config = pipe.getConfiguration();
        options.applyDefaults(config);
        receiver.setSystemId(systemId);
        Receiver next = receiver;
        int schemaValidation = options.getSchemaValidationMode();
        List<FilterFactory> filters = options.getFilters();
        if (filters != null) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                ProxyReceiver filter = filters.get(i).makeFilter(next);
                filter.setSystemId(source.getSystemId());
                next = filter;
            }
        }
        if (options.getStripSpace() == 2) {
            next = new Stripper(AllElementsSpaceStrippingRule.getInstance(), next);
        } else if (options.getStripSpace() == 4 && (controller = pipe.getController()) != null) {
            next = controller.makeStripper(next);
        }
        if (source instanceof TreeInfo) {
            source = ((TreeInfo)source).getRootNode();
        }
        if (source instanceof NodeInfo) {
            int kind;
            NodeInfo ns = (NodeInfo)source;
            String baseURI = ns.getBaseURI();
            if (schemaValidation != 3) {
                next = config.getDocumentValidator(next, baseURI, options);
            }
            if ((kind = ns.getNodeKind()) != 9 && kind != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            next.setSystemId(baseURI);
            ExplicitLocation loc = new ExplicitLocation(systemId, -1, -1);
            Sender.sendDocumentInfo(ns, next, loc);
            return;
        }
        if (source instanceof PullSource) {
            Sender.sendPullSource((PullSource)source, next, options);
            return;
        }
        if (source instanceof PullEventSource) {
            Sender.sendPullEventSource((PullEventSource)source, next, options);
            return;
        }
        if (source instanceof EventSource) {
            ((EventSource)source).send(next);
            return;
        }
        if (source instanceof SAXSource) {
            Sender.sendSAXSource((SAXSource)source, next, options);
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            boolean dtdValidation = options.getDTDValidationMode() == 1;
            Source ps = Version.platform.getParserSource(pipe, ss, schemaValidation, dtdValidation, options.getStripSpace());
            if (ps == ss) {
                String url = source.getSystemId();
                InputSource is = new InputSource(url);
                is.setCharacterStream(ss.getReader());
                is.setByteStream(ss.getInputStream());
                boolean reuseParser = false;
                XMLReader parser = options.getXMLReader();
                if (parser == null) {
                    parser = config.getSourceParser();
                    if (options.getEntityResolver() != null && parser.getEntityResolver() == null) {
                        parser.setEntityResolver(options.getEntityResolver());
                    }
                    reuseParser = true;
                }
                SAXSource sax = new SAXSource(parser, is);
                sax.setSystemId(source.getSystemId());
                Sender.sendSAXSource(sax, next, options);
                if (reuseParser) {
                    config.reuseSourceParser(parser);
                }
            } else {
                Sender.send(ps, next, options);
            }
            return;
        }
        if (staxSourceClass != null && staxSourceClass.isAssignableFrom(source.getClass())) {
            XMLStreamReader reader = null;
            try {
                Method getReaderMethod = staxSourceClass.getMethod("getXMLStreamReader", EMPTY_CLASS_ARRAY);
                reader = (XMLStreamReader)getReaderMethod.invoke((Object)source, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (reader == null) {
                throw new XPathException("Saxon can only handle a StAXSource that wraps an XMLStreamReader");
            }
            StaxBridge bridge = new StaxBridge();
            bridge.setXMLStreamReader(reader);
            Sender.sendPullSource(new PullSource(bridge), next, options);
            return;
        }
        next = Sender.makeValidator(next, source.getSystemId(), options);
        Source newSource = config.getSourceResolver().resolveSource(source, config);
        if (newSource instanceof StreamSource || newSource instanceof SAXSource || newSource instanceof NodeInfo || newSource instanceof PullSource || newSource instanceof AugmentedSource || newSource instanceof EventSource) {
            Sender.send(newSource, next, options);
        }
        List<ExternalObjectModel> externalObjectModels = config.getExternalObjectModels();
        for (ExternalObjectModel externalObjectModel : externalObjectModels) {
            ExternalObjectModel model = externalObjectModel;
            boolean done = model.sendSource(source, next);
            if (!done) continue;
            return;
        }
        throw new XPathException("A source of type " + source.getClass().getName() + " is not supported in this environment");
    }

    private static void sendDocumentInfo(NodeInfo top, Receiver receiver, Location location) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        NamePool targetNamePool = pipe.getConfiguration().getNamePool();
        if (top.getConfiguration().getNamePool() != targetNamePool) {
            receiver = new NamePoolConverter(receiver, top.getConfiguration().getNamePool(), targetNamePool);
        }
        LocationCopier copier = new LocationCopier(top.getNodeKind() == 9);
        pipe.setComponent(CopyInformee.class.getName(), copier);
        receiver.open();
        receiver.startDocument(0);
        top.copy(receiver, 6, location);
        receiver.endDocument();
        receiver.close();
    }

    /*
     * WARNING - void declaration
     */
    private static void sendSAXSource(SAXSource source, Receiver receiver, ParseOptions options) throws XPathException {
        void var13_26;
        boolean xInclude;
        ErrorHandler errorHandler;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        XMLReader parser = source.getXMLReader();
        boolean reuseParser = false;
        Configuration config = pipe.getConfiguration();
        UnfailingErrorListener listener = options.getErrorListener();
        if (listener == null) {
            listener = pipe.getErrorListener();
        }
        if ((errorHandler = options.getErrorHandler()) == null) {
            errorHandler = new StandardErrorHandler(listener);
        }
        if (parser == null) {
            parser = options.getXMLReader();
        }
        if (parser == null) {
            SAXSource ss = new SAXSource();
            ss.setInputSource(source.getInputSource());
            ss.setSystemId(source.getSystemId());
            parser = config.getSourceParser();
            parser.setErrorHandler(errorHandler);
            if (options.getEntityResolver() != null && parser.getEntityResolver() == null) {
                parser.setEntityResolver(options.getEntityResolver());
            }
            ss.setXMLReader(parser);
            source = ss;
            reuseParser = true;
        } else {
            Sender.configureParser(parser);
            if (parser.getErrorHandler() == null) {
                parser.setErrorHandler(errorHandler);
            }
        }
        if (!pipe.getParseOptions().isExpandAttributeDefaults()) {
            try {
                parser.setFeature("http://xml.org/sax/features/use-attributes2", true);
            }
            catch (SAXNotRecognizedException err) {
            }
            catch (SAXNotSupportedException err) {
                // empty catch block
            }
        }
        boolean dtdRecover = options.getDTDValidationMode() == 2;
        Map<String, Boolean> parserFeatures = options.getParserFeatures();
        Map<String, Object> parserProperties = options.getParserProperties();
        if (parserFeatures != null) {
            for (Map.Entry<String, Object> entry : parserFeatures.entrySet()) {
                try {
                    String name = entry.getKey();
                    boolean value = (Boolean)entry.getValue();
                    if (name.equals("http://apache.org/xml/features/xinclude")) {
                        boolean tryAgain = false;
                        try {
                            parser.setFeature(name, value);
                        }
                        catch (SAXNotRecognizedException err) {
                            tryAgain = true;
                        }
                        catch (SAXNotSupportedException err) {
                            tryAgain = true;
                        }
                        if (!tryAgain) continue;
                        try {
                            parser.setFeature(name + "-aware", value);
                            continue;
                        }
                        catch (SAXNotRecognizedException err) {
                            throw new XPathException(Sender.namedParser(parser) + " does not recognize request for XInclude processing", err);
                        }
                        catch (SAXNotSupportedException err) {
                            throw new XPathException(Sender.namedParser(parser) + " does not support XInclude processing", err);
                        }
                    }
                    parser.setFeature(entry.getKey(), (Boolean)entry.getValue());
                }
                catch (SAXNotRecognizedException err) {
                    config.getLogger().warning(Sender.namedParser(parser) + " does not recognize the feature " + entry.getKey());
                }
                catch (SAXNotSupportedException err) {
                    config.getLogger().warning(Sender.namedParser(parser) + " does not support the feature " + entry.getKey());
                }
            }
        }
        if (parserProperties != null) {
            for (Map.Entry<String, Object> entry : parserProperties.entrySet()) {
                try {
                    parser.setProperty(entry.getKey(), entry.getValue());
                }
                catch (SAXNotRecognizedException err) {
                    config.getLogger().warning(Sender.namedParser(parser) + " does not recognize the property " + entry.getKey());
                }
                catch (SAXNotSupportedException err) {
                    config.getLogger().warning(Sender.namedParser(parser) + " does not support the property " + entry.getKey());
                }
            }
        }
        if (xInclude = options.isXIncludeAware()) {
            void var13_23;
            boolean bl = false;
            try {
                parser.setFeature("http://apache.org/xml/features/xinclude-aware", true);
            }
            catch (SAXNotRecognizedException err) {
                boolean bl2 = true;
            }
            catch (SAXNotSupportedException err) {
                boolean bl3 = true;
            }
            if (var13_23 != false) {
                try {
                    parser.setFeature("http://apache.org/xml/features/xinclude", true);
                }
                catch (SAXNotRecognizedException err) {
                    throw new XPathException(Sender.namedParser(parser) + " does not recognize request for XInclude processing", err);
                }
                catch (SAXNotSupportedException err) {
                    throw new XPathException(Sender.namedParser(parser) + " does not support XInclude processing", err);
                }
            }
        }
        receiver = Sender.makeValidator(receiver, source.getSystemId(), options);
        ContentHandler ch = parser.getContentHandler();
        if (ch instanceof ReceivingContentHandler && config.isCompatible(((ReceivingContentHandler)ch).getConfiguration())) {
            ReceivingContentHandler receivingContentHandler = (ReceivingContentHandler)ch;
            receivingContentHandler.reset();
        } else {
            ReceivingContentHandler receivingContentHandler = new ReceivingContentHandler();
            parser.setContentHandler(receivingContentHandler);
            parser.setDTDHandler(receivingContentHandler);
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", receivingContentHandler);
            }
            catch (SAXNotSupportedException err) {
            }
            catch (SAXNotRecognizedException err) {
                // empty catch block
            }
        }
        var13_26.setReceiver(receiver);
        var13_26.setPipelineConfiguration(pipe);
        try {
            parser.parse(source.getInputSource());
        }
        catch (SAXException err) {
            XPathException de;
            Exception nested = err.getException();
            if (nested instanceof XPathException) {
                throw (XPathException)nested;
            }
            if (nested instanceof RuntimeException) {
                throw (RuntimeException)nested;
            }
            if (errorHandler instanceof StandardErrorHandler && ((StandardErrorHandler)errorHandler).getFatalErrorCount() == 0 || err instanceof SAXParseException && ((SAXParseException)err).getSystemId() == null && source.getSystemId() != null) {
                de = new XPathException("Error reported by XML parser processing " + source.getSystemId() + ": " + err.getMessage(), err);
                listener.fatalError(de);
                de.setHasBeenReported(true);
                throw de;
            }
            de = new XPathException(err);
            de.setErrorCode("SXXP0003");
            de.setHasBeenReported(true);
            throw de;
        }
        catch (IOException err) {
            throw new XPathException("I/O error reported by XML parser processing " + source.getSystemId() + ": " + err.getMessage(), err);
        }
        if (errorHandler instanceof StandardErrorHandler) {
            int errs = ((StandardErrorHandler)errorHandler).getFatalErrorCount();
            if (errs > 0) {
                throw new XPathException("The XML parser reported " + errs + (errs == 1 ? " error" : " errors"));
            }
            errs = ((StandardErrorHandler)errorHandler).getErrorCount();
            if (errs > 0) {
                String message = "The XML parser reported " + new Numberer_en().toWords(errs).toLowerCase() + " validation error" + (errs == 1 ? "" : "s");
                if (dtdRecover) {
                    message = message + ". Processing continues, because recovery from validation errors was requested";
                    listener.warning(new XPathException(message));
                } else {
                    throw new XPathException(message);
                }
            }
        }
        if (reuseParser) {
            config.reuseSourceParser(parser);
        }
    }

    private static String namedParser(XMLReader parser) {
        return "Selected XML parser " + parser.getClass().getName();
    }

    private static Receiver makeValidator(Receiver receiver, String systemId, ParseOptions options) throws XPathException {
        Controller controller;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        Configuration config = pipe.getConfiguration();
        int sv = options.getSchemaValidationMode();
        if (sv != 3 && sv != 0 && (controller = pipe.getController()) != null && !controller.getExecutable().isSchemaAware() && sv != 4) {
            throw new XPathException("Cannot use schema-validated input documents when the query/stylesheet is not schema-aware");
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendPullSource(PullSource source, Receiver receiver, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = Sender.makeValidator(receiver, source.getSystemId(), options);
        PullProvider provider = source.getPullProvider();
        provider.setPipelineConfiguration(pipe);
        receiver.setPipelineConfiguration(pipe);
        PullPushCopier copier = new PullPushCopier(provider, receiver);
        try {
            copier.copy();
        }
        finally {
            if (options.isPleaseCloseAfterUse()) {
                provider.close();
            }
        }
    }

    private static void sendPullEventSource(PullEventSource source, Receiver receiver, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = Sender.makeValidator(receiver, source.getSystemId(), options);
        receiver.open();
        EventIterator provider = source.getEventIterator();
        receiver.setPipelineConfiguration(pipe);
        SequenceReceiver out = SequenceReceiver.isTrueSequenceReceiver(receiver) ? (SequenceReceiver)receiver : new TreeReceiver(receiver);
        EventIteratorToReceiver.copy(provider, out);
        receiver.close();
    }

    public static void configureParser(XMLReader parser) throws XPathException {
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespaces' feature", err);
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespaces' feature to true", err);
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespace-prefixes' feature", err);
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespace-prefixes' feature to false", err);
        }
    }

    static {
        try {
            staxSourceClass = Class.forName("javax.xml.transform.stax.StAXSource");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

