/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation {
    public static final StructuredQName UPDATING = new StructuredQName("", "http://www.w3.org/2012/xquery", "updating");
    public static final StructuredQName SIMPLE = new StructuredQName("", "http://www.w3.org/2012/xquery", "simple");
    public static final StructuredQName PRIVATE = new StructuredQName("", "http://www.w3.org/2012/xquery", "private");
    public static final StructuredQName PUBLIC = new StructuredQName("", "http://www.w3.org/2012/xquery", "public");
    public static final int FUNCTION_DECLARATION = 1;
    public static final int VARIABLE_DECLARATION = 2;
    public static final int INLINE_FUNCTION = 4;
    public static final int ANNOTATION_ASSERTION = 8;
    private StructuredQName qName = null;
    private List<AtomicValue> annList = null;
    private static DisallowedCombination[] blackList = new DisallowedCombination[]{new DisallowedCombination(SIMPLE, null, "XUST0032", 2), new DisallowedCombination(UPDATING, null, "XUST0032", 2), new DisallowedCombination(PUBLIC, null, "XQST0125", 4), new DisallowedCombination(PRIVATE, null, "XQST0125", 4), new DisallowedCombination(PRIVATE, PRIVATE, "XQST0106", 1), new DisallowedCombination(PRIVATE, PUBLIC, "XQST0106", 1), new DisallowedCombination(PUBLIC, PUBLIC, "XQST0106", 1), new DisallowedCombination(PUBLIC, PRIVATE, "XQST0106", 1), new DisallowedCombination(PRIVATE, PRIVATE, "XQST0116", 2), new DisallowedCombination(PRIVATE, PUBLIC, "XQST0116", 2), new DisallowedCombination(PUBLIC, PUBLIC, "XQST0116", 2), new DisallowedCombination(PUBLIC, PRIVATE, "XQST0116", 2), new DisallowedCombination(UPDATING, UPDATING, "XUST0033", 5), new DisallowedCombination(UPDATING, SIMPLE, "XUST0033", 5), new DisallowedCombination(SIMPLE, SIMPLE, "XUST0033", 5), new DisallowedCombination(SIMPLE, UPDATING, "XUST0033", 5)};

    public Annotation(StructuredQName name) {
        this.qName = name;
    }

    public StructuredQName getAnnotationQName() {
        return this.qName;
    }

    public void addAnnotationParameter(AtomicValue value) {
        if (this.annList == null) {
            this.annList = new ArrayList<AtomicValue>();
        }
        this.annList.add(value);
    }

    public List<AtomicValue> getAnnotationParameters() {
        return this.annList;
    }

    public static boolean existsAnnotation(List<Annotation> annotationList, StructuredQName name) {
        for (Annotation a : annotationList) {
            if (!a.getAnnotationQName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void checkAnnotationList(List<Annotation> list, int where) throws XPathException {
        for (int i = 0; i < list.size(); ++i) {
            Annotation ann = list.get(i);
            for (DisallowedCombination dc : blackList) {
                if (!dc.one.equals(ann.getAnnotationQName()) || (dc.where & where) == 0) continue;
                if (dc.two == null) {
                    throw new XPathException("Annotation %" + ann.getAnnotationQName().getLocalPart() + " is not allowed here", dc.errorCode);
                }
                for (int j = 0; j < i; ++j) {
                    Annotation other = list.get(j);
                    if (!dc.two.equals(other.getAnnotationQName())) continue;
                    if (dc.two.equals(ann.getAnnotationQName())) {
                        throw new XPathException("Annotation %" + ann.getAnnotationQName().getLocalPart() + " cannot appear more than once", dc.errorCode);
                    }
                    throw new XPathException("Annotations %" + ann.getAnnotationQName().getLocalPart() + " and " + other.getAnnotationQName().getLocalPart() + " cannot appear together", dc.errorCode);
                }
            }
        }
    }

    private static class DisallowedCombination {
        public StructuredQName one;
        public StructuredQName two;
        public String errorCode;
        public int where;

        public DisallowedCombination(StructuredQName one, StructuredQName two, String errorCode, int where) {
            this.one = one;
            this.two = two;
            this.errorCode = errorCode;
            this.where = where;
        }
    }
}

