/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSLTemplate
extends StyleElement
implements StylesheetComponent {
    private String matchAtt = null;
    private String modeAtt = null;
    private String nameAtt = null;
    private String priorityAtt = null;
    private String asAtt = null;
    private String visibilityAtt = null;
    private StructuredQName[] modeNames;
    private String diagnosticId;
    private Pattern match;
    private boolean prioritySpecified;
    private double priority;
    private SlotManager stackFrameMap;
    private NamedTemplate compiledNamedTemplate = new NamedTemplate();
    private Map<StructuredQName, TemplateRule> compiledTemplateRules = new HashMap<StructuredQName, TemplateRule>();
    private SequenceType requiredType = null;
    private boolean hasRequiredParams = false;
    private boolean isTailRecursive = false;
    private Visibility visibility = Visibility.PRIVATE;
    private ItemType requiredContextItemType = AnyItemType.getInstance();
    private boolean mayOmitContextItem = true;
    private boolean maySupplyContextItem = true;
    private Expression body;

    @Override
    public NamedTemplate getCompiledProcedure() {
        return this.compiledNamedTemplate;
    }

    @Override
    public void setCompilation(Compilation compilation) {
        super.setCompilation(compilation);
    }

    @Override
    public boolean isDeclaration() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean mayContainParam(String attName) {
        return true;
    }

    @Override
    protected boolean isWithinDeclaredStreamableConstruct() {
        try {
            for (Mode m : this.getApplicableModes()) {
                if (!m.isDeclaredStreamable()) continue;
                return true;
            }
        }
        catch (XPathException e) {
            return false;
        }
        return false;
    }

    public void setContextItemRequirements(ItemType type, boolean mayBeOmitted, boolean mayBeSupplied) {
        this.requiredContextItemType = type;
        this.mayOmitContextItem = mayBeOmitted;
        this.maySupplyContextItem = mayBeSupplied;
    }

    @Override
    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLLocalParam || child.getFingerprint() == 144;
    }

    public StructuredQName getTemplateName() {
        try {
            String nameAtt;
            if (this.getObjectName() == null && (nameAtt = this.getAttributeValue("", "name")) != null) {
                this.setObjectName(this.makeQName(nameAtt));
            }
            return this.getObjectName();
        }
        catch (NamespaceException err) {
            return null;
        }
        catch (XPathException err) {
            return null;
        }
    }

    @Override
    public SymbolicName getSymbolicName() {
        if (this.getTemplateName() == null) {
            return null;
        }
        return new SymbolicName(200, this.getTemplateName());
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public boolean isMayOmitContextItem() {
        return this.mayOmitContextItem;
    }

    public boolean isMaySupplyContextItem() {
        return this.maySupplyContextItem;
    }

    @Override
    public void checkCompatibility(Component component) throws XPathException {
        NodeInfo param;
        SequenceType req;
        NamedTemplate other = (NamedTemplate)component.getCode();
        if (!this.getSymbolicName().equals(other.getSymbolicName())) {
            throw new IllegalArgumentException();
        }
        SequenceType sequenceType = req = this.requiredType == null ? SequenceType.ANY_SEQUENCE : this.requiredType;
        if (!req.equals(other.getRequiredType())) {
            this.compileError("The overriding template has a different required type from the overridden template", "XTSE3070");
        }
        if (!this.requiredContextItemType.equals(other.getRequiredContextItemType()) || this.mayOmitContextItem != other.isMayOmitContextItem() || this.maySupplyContextItem != other.isMaySupplyContextItem()) {
            this.compileError("The required context item for the overriding template differs from that of the overridden template", "XTSE3070");
        }
        List<LocalParam> otherParams = other.getLocalParams();
        HashSet<StructuredQName> overriddenParams = new HashSet<StructuredQName>();
        for (LocalParam lp0 : otherParams) {
            XSLLocalParam lp1 = this.getParam(lp0.getVariableQName());
            if (lp1 == null) {
                if (!lp0.isTunnelParam()) {
                    this.compileError("The overridden template declares a parameter " + lp0.getVariableQName().getDisplayName() + " which is not declared in the overriding template", "XTSE3070");
                }
                return;
            }
            if (!lp1.getRequiredType().equals(lp0.getRequiredType())) {
                lp1.compileError("The parameter " + lp0.getVariableQName().getDisplayName() + " has a different required type in the overridden template", "XTSE3070");
                return;
            }
            if (lp1.isRequiredParam() != lp0.isRequiredParam() && !lp0.isTunnelParam()) {
                lp1.compileError("The parameter " + lp0.getVariableQName().getDisplayName() + " is " + (lp1.isRequiredParam() ? "required" : "optional") + " in the overriding template, but " + (lp0.isRequiredParam() ? "required" : "optional") + " in the overridden template", "XTSE3070");
                return;
            }
            if (lp1.isTunnelParam() != lp0.isTunnelParam()) {
                lp1.compileError("The parameter " + lp0.getVariableQName().getDisplayName() + " is a " + (lp1.isTunnelParam() ? "tunnel" : "non-tunnel") + " parameter in the overriding template, but " + (lp0.isTunnelParam() ? "tunnel" : "non-tunnel") + " parameter in the overridden template", "XTSE3070");
                return;
            }
            overriddenParams.add(lp0.getVariableQName());
        }
        AxisIterator params = this.iterateAxis((byte)3);
        while ((param = params.next()) != null) {
            if (!(param instanceof XSLLocalParam) || overriddenParams.contains(((XSLLocalParam)param).getObjectName()) || !((XSLLocalParam)param).isRequiredParam()) continue;
            ((XSLLocalParam)param).compileError("An overriding template cannot introduce a required parameter that is not declared in the overridden template", "XTSE3070");
        }
    }

    public XSLLocalParam getParam(StructuredQName name) {
        NodeInfo param;
        AxisIterator params = this.iterateAxis((byte)3);
        while ((param = params.next()) != null) {
            if (!(param instanceof XSLLocalParam) || !name.equals(((XSLLocalParam)param).getObjectName())) continue;
            return (XSLLocalParam)param;
        }
        return null;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("mode")) {
                this.modeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("match")) {
                this.matchAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("priority")) {
                this.priorityAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("as")) {
                this.asAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("visibility")) {
                this.visibilityAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        try {
            if (this.modeAtt == null) {
                if (this.matchAtt != null) {
                    StructuredQName defaultMode = this.getDefaultMode();
                    if (defaultMode == null) {
                        defaultMode = Mode.UNNAMED_MODE_NAME;
                    }
                    this.modeNames = new StructuredQName[1];
                    this.modeNames[0] = defaultMode;
                }
            } else {
                if (this.matchAtt == null) {
                    this.compileError("The mode attribute must be absent if the match attribute is absent", "XTSE0500");
                }
                this.getModeNames();
            }
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("XTSE0280");
            if (err.getErrorCodeLocalPart().equals("XTSE0020")) {
                err.setErrorCode("XTSE0550");
            }
            err.setIsStaticError(true);
            this.compileError(err);
        }
        try {
            if (this.nameAtt != null) {
                StructuredQName qName = this.makeQName(this.nameAtt);
                this.setObjectName(qName);
                this.compiledNamedTemplate.setTemplateName(qName);
                this.diagnosticId = this.nameAtt;
            }
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("XTSE0280");
            err.setIsStaticError(true);
            this.compileError(err);
        }
        boolean bl = this.prioritySpecified = this.priorityAtt != null;
        if (this.prioritySpecified) {
            if (this.matchAtt == null) {
                this.compileError("The priority attribute must be absent if the match attribute is absent", "XTSE0500");
            }
            try {
                if (!DecimalValue.castableAsDecimal(this.priorityAtt)) {
                    this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
                }
                this.priority = Double.parseDouble(this.priorityAtt);
            }
            catch (NumberFormatException err) {
                this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
            }
        }
        if (this.matchAtt != null) {
            this.match = this.makePattern(this.matchAtt, "match");
            if (this.diagnosticId == null) {
                this.diagnosticId = "match=\"" + this.matchAtt + '\"';
                if (this.modeAtt != null) {
                    this.diagnosticId = this.diagnosticId + " mode=\"" + this.modeAtt + '\"';
                }
            }
        }
        if (this.match == null && this.nameAtt == null) {
            this.compileError("xsl:template must have a name or match attribute (or both)", "XTSE0500");
        }
        if (this.asAtt != null) {
            this.requiredType = this.makeSequenceType(this.asAtt);
        }
        if (this.visibilityAtt != null) {
            this.check30attribute("visibility");
            this.visibility = this.interpretVisibilityValue(this.visibilityAtt, "");
            if (this.nameAtt == null) {
                this.compileError("xsl:template/@visibility can be specified only if the template has a @name attribute", "XTSE0020");
            }
            this.compiledNamedTemplate.setDeclaredVisibility(this.visibility);
        }
    }

    public StructuredQName[] getModeNames() throws XPathException {
        if (this.modeNames == null) {
            if (this.modeAtt == null) {
                this.modeAtt = this.getAttributeValue("mode");
                if (this.modeAtt == null) {
                    this.modeAtt = "#default";
                }
            }
            int count = 0;
            boolean allModes = false;
            StringTokenizer st = new StringTokenizer(this.modeAtt, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                st.nextToken();
                ++count;
            }
            if (count == 0) {
                this.compileError("The mode attribute must not be empty", "XTSE0550");
            }
            this.modeNames = new StructuredQName[count];
            count = 0;
            st = new StringTokenizer(this.modeAtt, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                StructuredQName mname;
                String s = st.nextToken();
                if ("#default".equals(s)) {
                    mname = this.getDefaultMode();
                    if (mname == null) {
                        mname = Mode.UNNAMED_MODE_NAME;
                    }
                } else if ("#unnamed".equals(s) && this.isXslt30Processor()) {
                    mname = Mode.UNNAMED_MODE_NAME;
                } else if ("#all".equals(s)) {
                    allModes = true;
                    mname = Mode.OMNI_MODE;
                } else {
                    try {
                        mname = this.makeQName(s);
                    }
                    catch (NamespaceException e) {
                        this.compileError(e.getMessage(), "XTSE0280");
                        mname = Mode.UNNAMED_MODE_NAME;
                    }
                }
                for (int e = 0; e < count; ++e) {
                    if (!this.modeNames[e].equals(mname)) continue;
                    this.compileError("In the list of modes, the value " + s + " is duplicated", "XTSE0550");
                }
                this.modeNames[count++] = mname;
            }
            if (allModes && count > 1) {
                this.compileError("mode='#all' cannot be combined with other modes", "XTSE0550");
            }
        }
        return this.modeNames;
    }

    public Set<Mode> getApplicableModes() throws XPathException {
        StructuredQName[] names = this.getModeNames();
        HashSet<Mode> modes = new HashSet<Mode>(names.length);
        RuleManager mgr = this.getPrincipalStylesheetModule().getRuleManager();
        for (StructuredQName name : names) {
            if (name.equals(Mode.OMNI_MODE)) {
                modes.addAll(mgr.getAllNamedModes());
                continue;
            }
            Mode mode = mgr.obtainMode(name, false);
            if (mode == null) continue;
            modes.add(mode);
        }
        return modes;
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeImpl param;
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel("XTSE0010", true);
        if (this.match != null) {
            this.match = this.typeCheck("match", this.match);
            if (this.match.getItemType() instanceof ErrorType) {
                this.issueWarning(new XPathException("Pattern will never match anything", "SXWN9015", this));
            }
            if (this.getPrincipalStylesheetModule().isDeclaredModes()) {
                RuleManager manager = this.getPrincipalStylesheetModule().getRuleManager();
                if (this.modeNames != null) {
                    for (StructuredQName name : this.modeNames) {
                        if (name.equals(Mode.UNNAMED_MODE_NAME) && !manager.isUnnamedModeExplicit()) {
                            this.compileError("The unnamed mode has not been declared in an xsl:mode declaration", "XTSE3085");
                        }
                        if (manager.obtainMode(name, false) != null) continue;
                        this.compileError("Mode name " + name.getDisplayName() + " has not been declared in an xsl:mode declaration", "XTSE3085");
                    }
                } else if (!manager.isUnnamedModeExplicit()) {
                    this.compileError("The unnamed mode has not been declared in an xsl:mode declaration", "XTSE3085");
                }
            }
            if (this.visibility == Visibility.ABSTRACT) {
                this.compileError("An abstract template must have no match attribute");
            }
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        boolean hasContent = false;
        while ((param = (NodeImpl)kids.next()) != null) {
            if (!(param instanceof StyleElement) || param.getFingerprint() == 144) continue;
            if (param instanceof XSLLocalParam) {
                if (!((XSLLocalParam)param).isRequiredParam()) continue;
                this.hasRequiredParams = true;
                continue;
            }
            hasContent = true;
        }
        if (this.visibility == Visibility.ABSTRACT && hasContent) {
            this.compileError("A template with visibility='abstract' must have no body");
        }
    }

    @Override
    public void postValidate() throws XPathException {
        this.isTailRecursive = this.markTailCalls();
    }

    @Override
    public void index(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
        top.indexNamedTemplate(decl);
    }

    @Override
    public boolean markTailCalls() {
        StyleElement last = this.getLastChildInstruction();
        return last != null && last.markTailCalls();
    }

    @Override
    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        RetainedStaticContext rsc = this.makeRetainedStaticContext();
        this.body = this.compileSequenceConstructor(compilation, decl, true);
        if (this.body.getRetainedStaticContext() == null) {
            this.body.setRetainedStaticContext(rsc);
        }
        if (this.body == null) {
            this.body = Literal.makeEmptySequence();
        }
        if (this.getTemplateName() != null) {
            this.compiledNamedTemplate.setTemplateName(this.getObjectName());
            this.compiledNamedTemplate.setPackageData(rsc.getPackageData());
            this.compiledNamedTemplate.setBody(this.body);
            this.compiledNamedTemplate.setStackFrameMap(this.stackFrameMap);
            this.compiledNamedTemplate.setSystemId(this.getSystemId());
            this.compiledNamedTemplate.setLineNumber(this.getLineNumber());
            this.compiledNamedTemplate.setHasRequiredParams(this.hasRequiredParams);
            this.compiledNamedTemplate.setRequiredType(this.requiredType);
            this.compiledNamedTemplate.setContextItemRequirements(this.requiredContextItemType, this.mayOmitContextItem, this.maySupplyContextItem);
            this.compiledNamedTemplate.setRetainedStaticContext(rsc);
            this.compiledNamedTemplate.setDeclaredVisibility(this.getDeclaredVisibility());
            Component component = this.getOverriddenComponent();
            if (component != null) {
                this.checkCompatibility(component);
            }
        }
        if (this.match != null) {
            for (StructuredQName modeName : this.modeNames) {
                TemplateRule templateRule = this.compiledTemplateRules.get(modeName);
                if (templateRule == null) {
                    templateRule = new TemplateRule();
                    this.compiledTemplateRules.put(modeName, templateRule);
                }
                templateRule.setMatchPattern(this.match);
                templateRule.setBody(this.body);
                templateRule.setStackFrameMap(this.stackFrameMap);
                templateRule.setSystemId(this.getSystemId());
                templateRule.setLineNumber(this.getLineNumber());
                templateRule.setHasRequiredParams(this.hasRequiredParams);
                templateRule.setRequiredType(this.requiredType);
                templateRule.setContextItemRequirements(this.requiredContextItemType, this.mayOmitContextItem, this.maySupplyContextItem);
            }
        }
        try {
            this.body = this.body.simplify();
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        if (this.visibility != Visibility.ABSTRACT) {
            try {
                if (this.requiredType != null) {
                    RoleDiagnostic roleDiagnostic = new RoleDiagnostic(7, this.diagnosticId, 0);
                    roleDiagnostic.setErrorCode("XTTE0505");
                    this.body = TypeChecker.staticTypeCheck(this.body, this.requiredType, false, roleDiagnostic, this.makeExpressionVisitor());
                }
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        if (this.getConfiguration().isCompileWithTracing()) {
            this.body = XSLTemplate.makeTraceInstruction(this, this.body);
            if (this.body instanceof TraceExpression) {
                ((TraceExpression)this.body).setProperty("match", this.matchAtt);
                ((TraceExpression)this.body).setProperty("mode", this.modeAtt);
            }
        }
        if (this.getTemplateName() != null) {
            this.compiledNamedTemplate.setBody(this.body);
        }
        if (this.match != null) {
            for (TemplateRule rule : this.compiledTemplateRules.values()) {
                rule.setBody(this.body);
                rule.updateSlaveCopies();
            }
        }
    }

    public void register(ComponentDeclaration declaration) throws XPathException {
        if (this.match != null) {
            StylesheetModule module = declaration.getModule();
            RuleManager mgr = this.getCompilation().getPrincipalStylesheetModule().getRuleManager();
            ExpressionVisitor visitor = ExpressionVisitor.make(this.getStaticContext());
            for (StructuredQName modeName : this.getModeNames()) {
                TemplateRule rule;
                Mode mode = mgr.obtainMode(modeName, false);
                if (mode == null) {
                    if (mgr.existsOmniMode()) {
                        Mode omniMode = mgr.obtainMode(Mode.OMNI_MODE, true);
                        mode = mgr.obtainMode(modeName, true);
                        SimpleMode.copyRules(omniMode.getActivePart(), mode.getActivePart());
                    } else {
                        mode = mgr.obtainMode(modeName, true);
                    }
                } else {
                    boolean ok = this.getPrincipalStylesheetModule().checkAcceptableModeForPackage(this, mode);
                    if (!ok) {
                        return;
                    }
                }
                Pattern match2 = this.match;
                String typed = mode.getActivePart().getPropertyValue("typed");
                if ("strict".equals(typed) || "lax".equals(typed)) {
                    try {
                        match2 = this.match.convertToTypedPattern(typed);
                    }
                    catch (XPathException e) {
                        e.maybeSetLocation(this);
                        throw e;
                    }
                    if (match2 != this.match) {
                        ContextItemStaticInfo info = new ContextItemStaticInfo(AnyItemType.getInstance(), false);
                        ExpressionTool.copyLocationInfo(this.match, match2);
                        match2.setOriginalText(this.match.toString());
                        match2 = match2.typeCheck(visitor, info);
                    }
                    if (this.modeNames.length == 1) {
                        this.match = match2;
                    }
                }
                if ((rule = this.compiledTemplateRules.get(modeName)) == null) {
                    rule = new TemplateRule();
                    this.compiledTemplateRules.put(modeName, rule);
                }
                double prio = this.prioritySpecified ? this.priority : Double.NaN;
                mgr.setTemplateRule(match2, rule, mode, module, prio);
                if (mode.isDeclaredStreamable()) {
                    rule.setDeclaredStreamable(true);
                }
                if (!mode.getModeName().equals(Mode.OMNI_MODE)) continue;
                mgr.setTemplateRule(match2, rule, mgr.getUnnamedMode(), module, prio);
                for (Mode m : mgr.getAllNamedModes()) {
                    if (!(m instanceof SimpleMode)) continue;
                    TemplateRule ruleCopy = rule.copy();
                    if (m.isDeclaredStreamable()) {
                        ruleCopy.setDeclaredStreamable(true);
                    }
                    this.compiledTemplateRules.put(m.getModeName(), ruleCopy);
                    mgr.setTemplateRule(match2.copy(new RebindingMap()), ruleCopy, m, module, prio);
                }
            }
        }
    }

    public void allocatePatternSlotNumbers() throws XPathException {
        if (this.match != null) {
            for (TemplateRule templateRule : this.compiledTemplateRules.values()) {
                for (Rule r : templateRule.getRules()) {
                    int slots;
                    Pattern match = r.getPattern();
                    int nextFree = 0;
                    if ((match.getDependencies() & 1) != 0) {
                        nextFree = 1;
                    }
                    if ((slots = match.allocateSlots(this.getSlotManager(), nextFree)) <= 0) continue;
                    RuleManager mgr = this.getCompilation().getPrincipalStylesheetModule().getRuleManager();
                    boolean appliesToAll = false;
                    for (StructuredQName nc : this.modeNames) {
                        if (nc.equals(Mode.OMNI_MODE)) {
                            appliesToAll = true;
                            break;
                        }
                        Mode mode = mgr.obtainMode(nc, true);
                        mode.getActivePart().allocatePatternSlots(slots);
                    }
                    if (!appliesToAll) continue;
                    for (Mode m : mgr.getAllNamedModes()) {
                        m.getActivePart().allocatePatternSlots(slots);
                    }
                    mgr.getUnnamedMode().getActivePart().allocatePatternSlots(slots);
                }
            }
        }
    }

    @Override
    public void optimize(ComponentDeclaration declaration) throws XPathException {
        ContextItemStaticInfo cit;
        ItemType contextItemType = Type.ITEM_TYPE;
        if (this.getObjectName() == null) {
            contextItemType = this.match.getItemType();
            if (contextItemType.equals(ErrorType.getInstance())) {
                contextItemType = AnyItemType.getInstance();
            }
            cit = new ContextItemStaticInfo(contextItemType, false);
        } else {
            cit = new ContextItemStaticInfo(contextItemType, true);
        }
        ExpressionTool.resetPropertiesWithinSubtree(this.body);
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        Optimizer opt = this.getConfiguration().obtainOptimizer();
        try {
            this.body = this.body.typeCheck(visitor, cit);
            ExpressionTool.resetPropertiesWithinSubtree(this.body);
            boolean needCopy = false;
            if (this.getTemplateName() != null) {
                Expression namedTemplateBody = ExpressionTool.optimizeComponentBody(this.body, this.getCompilation(), visitor, cit, true);
                needCopy = true;
                this.compiledNamedTemplate.setBody(namedTemplateBody);
                this.allocateLocalSlots(namedTemplateBody);
                if (this.isExplaining()) {
                    Logger err = this.getConfiguration().getLogger();
                    err.info("Optimized expression tree for named template at line " + this.getLineNumber() + " in " + this.getSystemId() + ':');
                    namedTemplateBody.explain(err);
                }
                namedTemplateBody.restoreParentPointers();
            }
            for (TemplateRule compiledTemplateRule : this.compiledTemplateRules.values()) {
                Expression templateRuleBody = needCopy ? this.body.copy(new RebindingMap()) : this.body;
                templateRuleBody = ExpressionTool.optimizeComponentBody(templateRuleBody, this.getCompilation(), visitor, cit, true);
                compiledTemplateRule.setBody(templateRuleBody);
                opt.checkStreamability(this, compiledTemplateRule);
                this.allocateLocalSlots(templateRuleBody);
                for (Rule r : compiledTemplateRule.getRules()) {
                    Pattern match = r.getPattern();
                    ContextItemStaticInfo info = new ContextItemStaticInfo(match.getItemType(), false, true);
                    Pattern m2 = match.optimize(visitor, info);
                    if (needCopy) {
                        m2 = m2.copy(new RebindingMap());
                    }
                    if (m2 == match) continue;
                    r.setPattern(m2);
                }
                needCopy = true;
                if (!this.isExplaining()) continue;
                Logger err = this.getConfiguration().getLogger();
                err.info("Optimized expression tree for template rule at line " + this.getLineNumber() + " in " + this.getSystemId() + ':');
                templateRuleBody.explain(err);
            }
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            this.compileError(e);
        }
    }

    @Override
    public void generateByteCode(Optimizer opt) throws XPathException {
        if (this.getCompilation().getCompilerInfo().isGenerateByteCode() && !this.isTailRecursive) {
            if (this.getTemplateName() != null) {
                try {
                    Expression exp = this.compiledNamedTemplate.getBody();
                    Expression cbody = opt.compileToByteCode(exp, this.nameAtt, 4);
                    if (cbody != null) {
                        this.compiledNamedTemplate.setBody(cbody);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed while compiling named template " + this.nameAtt);
                    e.printStackTrace();
                    throw new XPathException(e);
                }
            }
            for (TemplateRule compiledTemplateRule : this.compiledTemplateRules.values()) {
                if (compiledTemplateRule.isDeclaredStreamable()) continue;
                try {
                    Expression exp = compiledTemplateRule.getBody();
                    Expression cbody = opt.compileToByteCode(exp, this.matchAtt, 4);
                    if (cbody == null) continue;
                    compiledTemplateRule.setBody(cbody);
                }
                catch (Exception e) {
                    System.err.println("Failed while compiling template rule with match = '" + this.matchAtt + "'");
                    e.printStackTrace();
                    throw new XPathException(e);
                }
            }
        }
    }

    @Override
    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public NamedTemplate getCompiledNamedTemplate() {
        return this.compiledNamedTemplate;
    }

    @Override
    public int getConstructType() {
        return 200;
    }

    public Pattern getMatch() {
        return this.match;
    }

    public Map<StructuredQName, TemplateRule> getTemplateRulesByMode() {
        return this.compiledTemplateRules;
    }
}

