/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceMaintainer
implements EventIterator,
NamespaceResolver {
    private EventIterator base;
    private NamespaceBinding[] allNamespaces = new NamespaceBinding[50];
    private int allNamespacesSize = 0;
    private int[] namespaceCountStack = new int[50];
    private int depth = 0;

    public NamespaceMaintainer(EventIterator base) {
        this.base = EventStackIterator.flatten(base);
    }

    @Override
    public boolean isFlatSequence() {
        return true;
    }

    @Override
    public PullEvent next() throws XPathException {
        PullEvent event = this.base.next();
        if (event instanceof StartElementEvent) {
            this.startElement((StartElementEvent)event);
        } else if (event instanceof EndElementEvent) {
            this.endElement();
        }
        return event;
    }

    private void startElement(StartElementEvent event) throws XPathException {
        int i;
        NamespaceBinding[] declaredNamespaces = event.getLocalNamespaces();
        int numberOfDeclaredNamespaces = declaredNamespaces.length;
        for (i = 0; i < declaredNamespaces.length; ++i) {
            if (declaredNamespaces[i] != null) continue;
            numberOfDeclaredNamespaces = i;
            break;
        }
        if (this.depth >= this.namespaceCountStack.length) {
            int[] newstack = new int[this.depth * 2];
            System.arraycopy(this.namespaceCountStack, 0, newstack, 0, this.depth);
            this.namespaceCountStack = newstack;
        }
        this.namespaceCountStack[this.depth++] = numberOfDeclaredNamespaces;
        while (this.allNamespacesSize + numberOfDeclaredNamespaces >= this.allNamespaces.length) {
            NamespaceBinding[] newlist = new NamespaceBinding[this.allNamespacesSize * 2];
            System.arraycopy(this.allNamespaces, 0, newlist, 0, this.allNamespacesSize);
            this.allNamespaces = newlist;
        }
        for (i = 0; i < declaredNamespaces.length && declaredNamespaces[i] != null; ++i) {
            this.allNamespaces[this.allNamespacesSize++] = declaredNamespaces[i];
        }
    }

    private void endElement() {
        this.allNamespacesSize -= this.namespaceCountStack[--this.depth];
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.isEmpty() && !useDefault) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (!this.allNamespaces[i].getPrefix().equals(prefix)) continue;
            return this.allNamespaces[i].getURI();
        }
        return prefix.isEmpty() ? "" : null;
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(this.allNamespacesSize);
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            String prefix = this.allNamespaces[i].getPrefix();
            if (prefixes.contains(prefix)) continue;
            prefixes.add(prefix);
        }
        prefixes.add("xml");
        return prefixes.iterator();
    }
}

