/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;

public class FingerprintedQName
implements NodeName {
    private StructuredQName qName;
    private int nameCode = -1;

    public FingerprintedQName(String prefix, String uri, String localName) {
        this.qName = new StructuredQName(prefix, uri, localName);
    }

    public FingerprintedQName(String prefix, String uri, String localName, int nameCode) {
        this.qName = new StructuredQName(prefix, uri, localName);
        this.nameCode = nameCode;
    }

    public FingerprintedQName(String prefix, String uri, String localName, NamePool pool) {
        this.qName = new StructuredQName(prefix, uri, localName);
        this.nameCode = pool.allocate(prefix, uri, localName);
    }

    public FingerprintedQName(StructuredQName qName, int nameCode) {
        this.qName = qName;
        this.nameCode = nameCode;
    }

    public FingerprintedQName(StructuredQName qName, NamePool pool) {
        this.qName = qName;
        this.nameCode = pool.allocate(qName.getPrefix(), qName.getURI(), qName.getLocalPart());
    }

    public static FingerprintedQName fromClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = "";
            localName = expandedName;
        }
        return new FingerprintedQName("", namespace, localName);
    }

    public boolean hasFingerprint() {
        return this.nameCode != -1;
    }

    public int getFingerprint() {
        return this.nameCode == -1 ? -1 : this.nameCode & 0xFFFFF;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public int allocateNameCode(NamePool pool) {
        if (this.nameCode == -1) {
            this.nameCode = pool.allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
        }
        return this.nameCode;
    }

    public String getDisplayName() {
        return this.qName.getDisplayName();
    }

    public String getPrefix() {
        return this.qName.getPrefix();
    }

    public String getURI() {
        return this.qName.getURI();
    }

    public String getLocalPart() {
        return this.qName.getLocalPart();
    }

    public StructuredQName getStructuredQName() {
        return this.qName;
    }

    public boolean isInSameNamespace(NodeName other) {
        return this.qName.isInSameNamespace(other);
    }

    public boolean hasURI(String ns) {
        return this.qName.hasURI(ns);
    }

    public NamespaceBinding getNamespaceBinding() {
        return this.qName.getNamespaceBinding();
    }

    public int identityHashCode() {
        return 0;
    }

    public boolean equals(Object other) {
        if (other instanceof NodeName) {
            if (this.nameCode != -1 && ((NodeName)other).hasFingerprint()) {
                return this.getFingerprint() == ((NodeName)other).getFingerprint();
            }
            return this.getLocalPart().equals(((NodeName)other).getLocalPart()) && this.isInSameNamespace((NodeName)other);
        }
        return false;
    }

    public int hashCode() {
        return this.qName.hashCode();
    }

    public boolean isIdentical(IdentityComparable other) {
        return other instanceof NodeName && this.equals(other) && this.getPrefix().equals(((NodeName)other).getPrefix());
    }
}

