/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public abstract class AccessorFn
extends ScalarSystemFunction {
    public abstract Component getComponentId();

    public IntegerValue[] getIntegerBounds() {
        switch (this.getComponentId()) {
            case YEAR: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-100000L), Int64Value.makeIntegerValue(100000L)};
            }
            case MONTH: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-11L), Int64Value.makeIntegerValue(11L)};
            }
            case DAY: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-31L), Int64Value.makeIntegerValue(31L)};
            }
            case HOURS: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-24L), Int64Value.makeIntegerValue(24L)};
            }
            case MINUTES: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-59L), Int64Value.makeIntegerValue(59L)};
            }
            case SECONDS: {
                return new IntegerValue[]{Int64Value.makeIntegerValue(-59L), Int64Value.makeIntegerValue(59L)};
            }
        }
        return null;
    }

    public int getRequiredComponent() {
        return this.getComponentId().ordinal();
    }

    public AtomicValue evaluate(Item item, XPathContext context) throws XPathException {
        return ((AtomicValue)item).getComponent(this.getComponentId());
    }

    public static class NamespaceUriFromQName
    extends AccessorFn {
        public Component getComponentId() {
            return Component.NAMESPACE;
        }
    }

    public static class PrefixFromQName
    extends AccessorFn {
        public Component getComponentId() {
            return Component.PREFIX;
        }
    }

    public static class LocalNameFromQName
    extends AccessorFn {
        public Component getComponentId() {
            return Component.LOCALNAME;
        }
    }

    public static class SecondsFromDuration
    extends AccessorFn {
        public Component getComponentId() {
            return Component.SECONDS;
        }
    }

    public static class MinutesFromDuration
    extends AccessorFn {
        public Component getComponentId() {
            return Component.MINUTES;
        }
    }

    public static class HoursFromDuration
    extends AccessorFn {
        public Component getComponentId() {
            return Component.HOURS;
        }
    }

    public static class DaysFromDuration
    extends AccessorFn {
        public Component getComponentId() {
            return Component.DAY;
        }
    }

    public static class MonthsFromDuration
    extends AccessorFn {
        public Component getComponentId() {
            return Component.MONTH;
        }
    }

    public static class YearsFromDuration
    extends AccessorFn {
        public Component getComponentId() {
            return Component.YEAR;
        }
    }

    public static class TimezoneFromTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.TIMEZONE;
        }
    }

    public static class SecondsFromTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.SECONDS;
        }
    }

    public static class MinutesFromTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.MINUTES;
        }
    }

    public static class HoursFromTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.HOURS;
        }
    }

    public static class TimezoneFromDate
    extends AccessorFn {
        public Component getComponentId() {
            return Component.TIMEZONE;
        }
    }

    public static class DayFromDate
    extends AccessorFn {
        public Component getComponentId() {
            return Component.DAY;
        }
    }

    public static class MonthFromDate
    extends AccessorFn {
        public Component getComponentId() {
            return Component.MONTH;
        }
    }

    public static class YearFromDate
    extends AccessorFn {
        public Component getComponentId() {
            return Component.YEAR;
        }
    }

    public static class TimezoneFromDateTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.TIMEZONE;
        }
    }

    public static class SecondsFromDateTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.SECONDS;
        }
    }

    public static class MinutesFromDateTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.MINUTES;
        }
    }

    public static class HoursFromDateTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.HOURS;
        }
    }

    public static class DayFromDateTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.DAY;
        }
    }

    public static class MonthFromDateTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.MONTH;
        }
    }

    public static class YearFromDateTime
    extends AccessorFn {
        public Component getComponentId() {
            return Component.YEAR;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Component {
        YEAR,
        MONTH,
        DAY,
        HOURS,
        MINUTES,
        SECONDS,
        TIMEZONE,
        LOCALNAME,
        NAMESPACE,
        PREFIX,
        MICROSECONDS,
        WHOLE_SECONDS,
        YEAR_ALLOWING_ZERO;

    }
}

