/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class ConsumingOperand
extends UnaryExpression {
    public ConsumingOperand(Expression subExpression) {
        super(subExpression);
    }

    protected OperandRole getOperandRole() {
        return new OperandRole(0, OperandUsage.ABSORPTION);
    }

    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    public int getIntrinsicDependencies() {
        return this.getBaseExpression().getIntrinsicDependencies();
    }

    public int computeCardinality() {
        return this.getBaseExpression().getCardinality();
    }

    public Expression copy() {
        ConsumingOperand exp = new ConsumingOperand(this.getBaseExpression().copy());
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    public int getImplementationMethod() {
        return 3;
    }

    public Sequence evaluate(XPathContext c) throws XPathException {
        if (c.getStackFrame().holdsDynamicValue()) {
            return c.getStackFrame().popDynamicValue();
        }
        return new LazySequence(this.getBaseExpression().iterate(c));
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.evaluate(context).iterate();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.evaluate(context).head();
    }

    public void export(ExpressionPresenter destination) {
        destination.startElement("consume", this);
        this.getBaseExpression().export(destination);
        destination.endElement();
    }

    public String toString() {
        return "consume(" + this.getBaseExpression().toString() + ")";
    }

    public String toShortString() {
        return "consume(" + this.getBaseExpression().toShortString() + ")";
    }
}

