/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.OriginalFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.CurriedSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticFunctionCall
extends FunctionCall
implements Callable {
    private Function target;

    public StaticFunctionCall(Function target, Expression[] arguments) {
        if (target.getArity() != arguments.length) {
            throw new IllegalArgumentException("Function call with wrong number of arguments");
        }
        this.target = target;
        this.setOperanda(arguments, target.getOperandRoles());
    }

    public Function getTargetFunction() {
        return this.target;
    }

    @Override
    public Function getTargetFunction(XPathContext context) {
        return this.getTargetFunction();
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.target.getFunctionName();
    }

    @Override
    public boolean isCallOn(Class<? extends SystemFunction> function) {
        return function.isAssignableFrom(this.target.getClass());
    }

    @Override
    public boolean isCallOnSystemFunction(String localName) {
        StructuredQName name = this.target.getFunctionName();
        return name.hasURI("http://www.w3.org/2005/xpath-functions") && localName.equals(name.getLocalPart());
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.checkFunctionCall(this.target, visitor);
        return super.typeCheck(visitor, contextInfo);
    }

    @Override
    public Expression copy() {
        Expression[] args = new Expression[this.getArity()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.getArg(i).copy();
        }
        return new StaticFunctionCall(this.target, args);
    }

    @Override
    protected int computeCardinality() {
        return this.target.getFunctionItemType().getResultType().getCardinality();
    }

    @Override
    public ItemType getItemType() {
        return this.target.getFunctionItemType().getResultType().getPrimaryType();
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.target.call(context, arguments);
    }

    @Override
    public void export(ExpressionPresenter out) {
        if (this.target instanceof CurriedSystemFunction) {
            CurriedSystemFunction csf = (CurriedSystemFunction)this.target;
            out.startElement("cfn");
            out.emitAttribute("name", csf.getName());
            csf.exportLocalData(out);
            for (Operand o : this.operands()) {
                o.getChildExpression().export(out);
            }
            out.endElement();
        } else if (this.target instanceof OriginalFunction) {
            OriginalFunction pf = (OriginalFunction)this.target;
            out.startElement("origFC", this);
            out.emitAttribute("name", pf.getFunctionName());
            out.emitAttribute("pack", pf.getContainingPackageName());
            for (Operand o : this.operands()) {
                o.getChildExpression().export(out);
            }
            out.endElement();
        } else {
            super.export(out);
        }
    }
}

