/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.z.IntHashMap;

public class SystemFunctionLibrary
implements FunctionLibrary {
    private int functionSet;
    private static IntHashMap<SystemFunctionLibrary> THE_INSTANCES = new IntHashMap(3);

    public static synchronized SystemFunctionLibrary getSystemFunctionLibrary(int functionSet, Configuration config) {
        if (THE_INSTANCES.get(functionSet) == null) {
            THE_INSTANCES.put(functionSet, config.makeSystemFunctionLibrary(functionSet));
        }
        return THE_INSTANCES.get(functionSet);
    }

    public SystemFunctionLibrary(int functionSet) {
        this.functionSet = functionSet;
    }

    public Expression bind(SymbolicName symbolicName, Expression[] staticArgs, StaticContext env) throws XPathException {
        StructuredQName functionName = symbolicName.getComponentName();
        int arity = symbolicName.getArity();
        String uri = functionName.getURI();
        if (uri.equals("http://www.w3.org/2005/xpath-functions")) {
            RetainedStaticContext rsc = new RetainedStaticContext(env);
            String local = functionName.getLocalPart();
            SystemFunction fn = SystemFunctionLibrary.makeSystemFunction(local, arity, this.functionSet);
            fn.setRetainedStaticContext(rsc);
            Expression f = fn.makeFunctionCall(staticArgs);
            f.setRetainedStaticContext(rsc);
            return f;
        }
        return null;
    }

    public static SystemFunction makeSystemFunction(String local, int arity, int functionSet) throws XPathException {
        SystemFunction f;
        StandardFunction.Entry entry = StandardFunction.getFunction(local, arity);
        if (entry == null) {
            if (StandardFunction.getFunction(local, -1) == null) {
                XPathException err = new XPathException("Unknown system function " + local + "()");
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            XPathException err = new XPathException("System function " + local + "() cannot be called with " + SystemFunctionLibrary.pluralArguments(arity));
            err.setErrorCode("XPST0017");
            err.setIsStaticError(true);
            throw err;
        }
        if ((functionSet & entry.applicability) == 0) {
            XPathException err = new XPathException("System function " + local + "#" + arity + " is not available with this host-language/version/license");
            err.setErrorCode("XPST0017");
            err.setIsStaticError(true);
            throw err;
        }
        Class functionClass = entry.implementationClass;
        try {
            f = (SystemFunction)functionClass.newInstance();
        }
        catch (Exception err) {
            err.printStackTrace();
            throw new AssertionError((Object)("Failed to load system function fn:" + local + " - " + err.getMessage()));
        }
        f.setDetails(entry);
        f.setArity(arity);
        SystemFunctionLibrary.checkArgumentCount(arity, entry.minArguments, entry.maxArguments, local);
        return f;
    }

    public boolean isAvailable(SymbolicName functionName) {
        String uri = functionName.getComponentName().getURI();
        if (uri.equals("http://www.w3.org/2005/xpath-functions")) {
            String local = functionName.getComponentName().getLocalPart();
            StandardFunction.Entry entry = StandardFunction.getFunction(local, functionName.getArity());
            return entry != null && (this.functionSet & entry.applicability) != 0 && entry.minArguments <= functionName.getArity() && entry.maxArguments >= functionName.getArity();
        }
        return false;
    }

    private static int checkArgumentCount(int numArgs, int min, int max, String local) throws XPathException {
        if (min == max && numArgs != min) {
            throw new XPathException("Function " + Err.wrap(local, 3) + " must have " + SystemFunctionLibrary.pluralArguments(min), "XPST0017");
        }
        if (numArgs < min) {
            throw new XPathException("Function " + Err.wrap(local, 3) + " must have at least " + SystemFunctionLibrary.pluralArguments(min), "XPST0017");
        }
        if (numArgs > max) {
            throw new XPathException("Function " + Err.wrap(local, 3) + " must have no more than " + SystemFunctionLibrary.pluralArguments(max), "XPST0017");
        }
        return numArgs;
    }

    private static String pluralArguments(int num) {
        if (num == 0) {
            return "zero arguments";
        }
        if (num == 1) {
            return "one argument";
        }
        return num + " arguments";
    }

    public FunctionLibrary copy() {
        return this;
    }
}

