/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.SequenceType;

public class AnyFunctionType
implements FunctionItemType {
    public static final AnyFunctionType ANY_FUNCTION = new AnyFunctionType();
    public static SequenceType SINGLE_FUNCTION = SequenceType.makeSequenceType(ANY_FUNCTION, 16384);

    public static AnyFunctionType getInstance() {
        return ANY_FUNCTION;
    }

    public UType getUType() {
        return UType.FUNCTION;
    }

    public boolean isAtomicType() {
        return false;
    }

    public boolean isPlainType() {
        return false;
    }

    public boolean isMapType() {
        return false;
    }

    public boolean isArrayType() {
        return false;
    }

    public SequenceType[] getArgumentTypes() {
        return null;
    }

    public boolean matches(Item item, TypeHierarchy th) throws XPathException {
        return item instanceof Function;
    }

    public final ItemType getPrimitiveItemType() {
        return ANY_FUNCTION;
    }

    public final int getPrimitiveType() {
        return 99;
    }

    public String toString() {
        return "function(*)";
    }

    public PlainType getAtomizedItemType() {
        return null;
    }

    public boolean isAtomizable() {
        return false;
    }

    public int relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == this) {
            return 0;
        }
        return 1;
    }

    public Expression makeFunctionSequenceCoercer(Expression exp, RoleDiagnostic role) throws XPathException {
        return new ItemChecker(exp, this, role);
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
    }

    public SequenceType getResultType() {
        return SequenceType.ANY_SEQUENCE;
    }
}

