/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TryCatch
extends Expression {
    private Operand tryOp;
    private List<CatchClause> catchClauses = new ArrayList<CatchClause>();

    public TryCatch(Expression tryExpr) {
        this.tryOp = new Operand(this, tryExpr, OperandRole.SAME_FOCUS_ACTION);
    }

    public void addCatchExpression(QNameTest test, Expression catchExpr) {
        CatchClause clause = new CatchClause();
        clause.catchOp = new Operand(this, catchExpr, OperandRole.SAME_FOCUS_ACTION);
        clause.nameTest = test;
        this.catchClauses.add(clause);
    }

    public Expression getTryExpr() {
        return this.tryOp.getChildExpression();
    }

    public List<CatchClause> getCatchClauses() {
        return this.catchClauses;
    }

    @Override
    public int computeCardinality() {
        int card = this.getTryExpr().getCardinality();
        for (CatchClause catchClause : this.catchClauses) {
            card = Cardinality.union(card, catchClause.catchOp.getChildExpression().getCardinality());
        }
        return card;
    }

    @Override
    public ItemType getItemType() {
        ItemType type = this.getTryExpr().getItemType();
        for (CatchClause catchClause : this.catchClauses) {
            type = Type.getCommonSuperType(type, catchClause.catchOp.getChildExpression().getItemType());
        }
        return type;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>();
        list.add(this.tryOp);
        for (CatchClause cc : this.catchClauses) {
            list.add(cc.catchOp);
        }
        return list;
    }

    @Override
    public Expression promote(PromotionOffer offer) throws XPathException {
        if (offer.action != 14 && offer.action != 10) {
            Expression exp = offer.accept(this);
            if (exp != null) {
                return exp;
            }
            for (CatchClause clause : this.catchClauses) {
                clause.catchOp.setChildExpression(this.doPromotion(clause.catchOp.getChildExpression(), offer));
            }
            return this;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        for (Expression e = this.getParentExpression(); e != null; e = e.getParentExpression()) {
            if (!(e instanceof LetExpression) || !ExpressionTool.dependsOnVariable(this.getTryExpr(), new Binding[]{(LetExpression)e})) continue;
            ((LetExpression)e).setNeedsEagerEvaluation(true);
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    public boolean equals(Object other) {
        return other instanceof TryCatch && ((TryCatch)other).tryOp.getChildExpression().equals(this.tryOp.getChildExpression()) && ((TryCatch)other).catchClauses.equals(this.catchClauses);
    }

    public int hashCode() {
        int h = -2090134880;
        for (int i = 0; i < this.catchClauses.size(); ++i) {
            h ^= this.catchClauses.get(i).hashCode() << i;
        }
        return h + this.tryOp.getChildExpression().hashCode();
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        TryCatch t2 = new TryCatch(this.tryOp.getChildExpression().copy(rebindings));
        for (CatchClause clause : this.catchClauses) {
            t2.addCatchExpression(clause.nameTest, clause.catchOp.getChildExpression().copy(rebindings));
        }
        ExpressionTool.copyLocationInfo(this, t2);
        return t2;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        XPathContextMinor c1 = c.newMinorContext();
        try {
            return ExpressionTool.eagerEvaluate(this.tryOp.getChildExpression(), c1).head();
        }
        catch (XPathException err) {
            if (err.isGlobalError()) {
                err.setIsGlobalError(false);
            } else {
                StructuredQName code = err.getErrorCodeQName();
                if (code == null) {
                    code = new StructuredQName("err", "http://saxon.sf.net/", "SXWN9000");
                }
                for (CatchClause clause : this.catchClauses) {
                    if (!clause.nameTest.matches(code)) continue;
                    Expression caught = clause.catchOp.getChildExpression();
                    XPathContextMajor c2 = c.newContext();
                    c2.setCurrentException(err);
                    return caught.evaluateItem(c2);
                }
            }
            err.setHasBeenReported(false);
            throw err;
        }
    }

    @Override
    public SequenceIterator iterate(XPathContext c) throws XPathException {
        XPathContextMajor c1 = c.newContext();
        c1.createThreadManager();
        c1.setErrorListener(new FilteringErrorListener(c.getErrorListener()));
        try {
            Sequence v = ExpressionTool.eagerEvaluate(this.tryOp.getChildExpression(), c1);
            c1.waitForChildThreads();
            return v.iterate();
        }
        catch (XPathException err) {
            if (err.isGlobalError()) {
                err.setIsGlobalError(false);
            } else {
                StructuredQName code = err.getErrorCodeQName();
                for (CatchClause clause : this.catchClauses) {
                    if (!clause.nameTest.matches(code)) continue;
                    Expression caught = clause.catchOp.getChildExpression();
                    XPathContextMajor c2 = c.newContext();
                    c2.setCurrentException(err);
                    return caught.iterate(c2);
                }
            }
            err.setHasBeenReported(false);
            throw err;
        }
    }

    @Override
    public String getExpressionName() {
        return "tryCatch";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("try", this);
        this.tryOp.getChildExpression().export(out);
        for (CatchClause clause : this.catchClauses) {
            out.startElement("catch");
            out.emitAttribute("err", clause.nameTest.toString());
            if ("JS".equals(out.getOption("target"))) {
                out.emitAttribute("test", clause.nameTest.generateJavaScriptNameTest());
            }
            clause.catchOp.getChildExpression().export(out);
            out.endElement();
        }
        out.endElement();
    }

    private class FilteringErrorListener
    implements ErrorListener {
        private ErrorListener base;

        FilteringErrorListener(ErrorListener base) {
            this.base = base;
        }

        private boolean isCaught(TransformerException err) {
            if (err instanceof XPathException) {
                StructuredQName code = ((XPathException)err).getErrorCodeQName();
                for (CatchClause clause : TryCatch.this.catchClauses) {
                    if (!clause.nameTest.matches(code)) continue;
                    return true;
                }
            }
            return false;
        }

        public void warning(TransformerException exception) throws TransformerException {
            this.base.warning(exception);
        }

        public void error(TransformerException exception) throws TransformerException {
            if (!this.isCaught(exception)) {
                this.base.error(exception);
            }
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            if (!this.isCaught(exception)) {
                this.base.fatalError(exception);
            }
        }
    }

    public static class CatchClause {
        public int slotNumber = -1;
        public Operand catchOp;
        public QNameTest nameTest;
    }
}

