/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalParamSetter
extends Instruction {
    private LocalParam binding;

    public LocalParamSetter(LocalParam binding) {
        this.binding = binding;
        this.adoptOperands();
    }

    private void adoptOperands() {
        if (this.binding != null) {
            Expression conversion;
            Expression select = this.binding.getSelectExpression();
            if (select != null) {
                select.setParentExpression(this);
            }
            if ((conversion = this.binding.getConversion()) != null) {
                conversion.setParentExpression(this);
            }
        }
    }

    public LocalParam getBinding() {
        return this.binding;
    }

    @Override
    public ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public int computeSpecialProperties() {
        return 0;
    }

    @Override
    public boolean createsNewNodes() {
        return false;
    }

    @Override
    public Expression simplify() throws XPathException {
        Expression select = this.binding.getSelectExpression();
        if (select != null) {
            Expression s2 = select.simplify();
            this.binding.setSelectExpression(s2);
            this.adoptOperands();
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression select = this.binding.getSelectExpression();
        if (select != null) {
            this.binding.setSelectExpression(select.typeCheck(visitor, contextInfo));
        }
        this.binding.checkAgainstRequiredType(visitor);
        this.adoptOperands();
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression select = this.binding.getSelectExpression();
        if (select != null) {
            this.binding.setSelectExpression(select.optimize(visitor, contextItemType));
            this.adoptOperands();
            this.binding.computeEvaluationMode();
        }
        return this;
    }

    @Override
    public Expression copy() {
        LocalParamSetter exp = new LocalParamSetter(this.binding);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getInstructionNameCode() {
        return 189;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.binding.operands(this);
    }

    @Override
    public void adoptChildExpression(Expression child) {
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        int slotNumber = this.binding.getSlotNumber();
        int wasSupplied = context.useLocalParameter(this.binding.getVariableQName(), slotNumber, this.binding.isTunnelParam());
        switch (wasSupplied) {
            case 2: {
                break;
            }
            case 1: {
                Expression conversion = this.binding.getConversion();
                int conversionEvaluationMode = this.binding.getConversionEvaluationMode();
                if (conversion == null) break;
                context.setLocalVariable(slotNumber, ExpressionTool.evaluate(conversion, conversionEvaluationMode, context, 10));
                break;
            }
            case 0: {
                if (this.binding.isImplicitlyRequiredParam()) {
                    String name = "$" + this.binding.getVariableQName().getDisplayName();
                    XPathException e = new XPathException("A value must be supplied for parameter " + name + " because " + "the default value is not a valid instance of the required type");
                    e.setXPathContext(context);
                    e.setErrorCode("XTDE0700");
                    throw e;
                }
                if (this.binding.isRequiredParam()) {
                    String name = "$" + this.binding.getVariableQName().getDisplayName();
                    XPathException e = new XPathException("No value supplied for required parameter " + name);
                    e.setXPathContext(context);
                    e.setErrorCode("XTDE0700");
                    throw e;
                }
                context.setLocalVariable(slotNumber, this.binding.getSelectValue(context));
            }
        }
        return null;
    }

    @Override
    public void export(ExpressionPresenter out) {
        Expression conversion;
        out.startElement("param", this);
        out.emitAttribute("name", this.binding.getVariableQName());
        out.emitAttribute("slot", "" + this.binding.getSlotNumber());
        String flags = this.getFlags();
        if (!flags.isEmpty()) {
            out.emitAttribute("flags", flags);
        }
        if (this.binding.getRequiredType() != SequenceType.ANY_SEQUENCE) {
            out.emitAttribute("as", this.binding.getRequiredType().toString());
        }
        if (this.binding.getSelectExpression() != null) {
            out.setChildRole("select");
            this.binding.getSelectExpression().export(out);
        }
        if ((conversion = this.binding.getConversion()) != null) {
            out.setChildRole("conversion");
            conversion.export(out);
        }
        out.endElement();
    }

    private String getFlags() {
        String flags = "";
        if (this.binding.isTunnelParam()) {
            flags = flags + "t";
        }
        if (this.binding.isRequiredParam()) {
            flags = flags + "r";
        }
        if (this.binding.isImplicitlyRequiredParam()) {
            flags = flags + "i";
        }
        return flags;
    }
}

