/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.expr.sort.ItemOrderComparer;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class DocumentSorter
extends UnaryExpression {
    private ItemOrderComparer comparer;

    public DocumentSorter(Expression base) {
        super(base);
        int props = base.getSpecialProperties();
        this.comparer = (props & 0x10000) != 0 || (props & 0x800000) != 0 ? LocalOrderComparer.getInstance() : GlobalOrderComparer.getInstance();
    }

    public DocumentSorter(Expression base, boolean intraDocument) {
        super(base);
        this.comparer = intraDocument ? LocalOrderComparer.getInstance() : GlobalOrderComparer.getInstance();
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public String getExpressionName() {
        return "documentSort";
    }

    public ItemOrderComparer getComparer() {
        return this.comparer;
    }

    public Expression simplify() throws XPathException {
        Expression operand = this.getBaseExpression().simplify();
        if ((operand.getSpecialProperties() & 0x20000) != 0) {
            return operand;
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        RoleDiagnostic role = new RoleDiagnostic(17, "", 0);
        Expression operand = TypeChecker.staticTypeCheck(this.getBaseExpression(), SequenceType.NODE_SEQUENCE, false, role, visitor);
        this.setBaseExpression(operand);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().optimize(visitor, contextInfo);
        Expression operand = this.getBaseExpression();
        if ((operand.getSpecialProperties() & 0x20000) != 0) {
            return operand;
        }
        if (operand instanceof SlashExpression) {
            return this.getConfiguration().obtainOptimizer().makeConditionalDocumentSorter(this, (SlashExpression)operand);
        }
        return this;
    }

    protected int getNetCost() {
        return 30;
    }

    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        Expression operand = this.getBaseExpression().unordered(retainAllNodes, forStreaming);
        if ((operand.getSpecialProperties() & 0x20000) != 0) {
            return operand;
        }
        if (!retainAllNodes) {
            return operand;
        }
        if (operand instanceof SlashExpression) {
            SlashExpression exp = (SlashExpression)operand;
            Expression a = exp.getSelectExpression();
            Expression b = exp.getActionExpression();
            a = ExpressionTool.unfilteredExpression(a, false);
            b = ExpressionTool.unfilteredExpression(b, false);
            if (a instanceof AxisExpression && (((AxisExpression)a).getAxis() == 4 || ((AxisExpression)a).getAxis() == 5) && b instanceof AxisExpression && ((AxisExpression)b).getAxis() == 3) {
                return operand.unordered(retainAllNodes, false);
            }
        }
        this.setBaseExpression(operand);
        return this;
    }

    public int computeSpecialProperties() {
        return this.getBaseExpression().getSpecialProperties() | 0x20000;
    }

    public Expression copy() {
        DocumentSorter ds = new DocumentSorter(this.getBaseExpression().copy());
        ExpressionTool.copyLocationInfo(this, ds);
        return ds;
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        return this.getBaseExpression().toPattern(config, is30);
    }

    public int getImplementationMethod() {
        return 2;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return new DocumentOrderIterator(this.getBaseExpression().iterate(context), this.comparer);
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.getBaseExpression().effectiveBooleanValue(context);
    }

    public void export(ExpressionPresenter out) {
        out.startElement("docOrder", this);
        out.emitAttribute("intra", this.comparer instanceof LocalOrderComparer ? "1" : "0");
        this.getBaseExpression().export(out);
        out.endElement();
    }
}

