/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.CheckSumFilter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;

public class ExpressionPresenter {
    private Configuration config;
    private Receiver receiver;
    private int depth = 0;
    private boolean inStartTag = false;
    private String nextRole = null;
    private Stack<Expression> expressionStack = new Stack();
    private Stack<String> nameStack = new Stack();
    private String defaultNamespace;

    public ExpressionPresenter(Configuration config) {
        this(config, config.getLogger());
    }

    public ExpressionPresenter(Configuration config, StreamResult out) {
        this(config, out, false);
    }

    public ExpressionPresenter(Configuration config, StreamResult out, boolean checksum) {
        Properties props = ExpressionPresenter.makeDefaultProperties(config);
        try {
            this.receiver = config.getSerializerFactory().getReceiver(out, config.makePipelineConfiguration(), props);
            this.receiver = new NamespaceReducer(this.receiver);
            if (checksum) {
                this.receiver = new CheckSumFilter(this.receiver);
            }
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
        this.config = config;
        try {
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
    }

    public ExpressionPresenter(Configuration config, Logger out) {
        this(config, out.asStreamResult());
    }

    public ExpressionPresenter(Configuration config, Receiver receiver) {
        this.config = config;
        this.receiver = receiver;
        try {
            receiver.open();
            receiver.startDocument(0);
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
    }

    public void setDefaultNamespace(String namespace) {
        this.defaultNamespace = namespace;
    }

    public static Receiver defaultDestination(Configuration config, Logger out) throws XPathException {
        Properties props = ExpressionPresenter.makeDefaultProperties(config);
        return config.getSerializerFactory().getReceiver(out.asStreamResult(), config.makePipelineConfiguration(), props);
    }

    public static Properties makeDefaultProperties(Configuration config) {
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("indent", "yes");
        props.setProperty("{http://saxon.sf.net/}indent-spaces", "2");
        if (config.getXMLVersion() == 11) {
            props.setProperty("omit-xml-declaration", "no");
            props.setProperty("version", "1.1");
        } else {
            props.setProperty("omit-xml-declaration", "yes");
            props.setProperty("version", "1.0");
        }
        return props;
    }

    public int startElement(String name, Expression expr) {
        String mod;
        Expression parent = this.expressionStack.isEmpty() ? null : this.expressionStack.peek();
        this.expressionStack.push(expr);
        this.nameStack.push("*" + name);
        int n = this._startElement(name);
        if ((parent == null || expr.getRetainedStaticContext() != parent.getRetainedStaticContext()) && expr.getRetainedStaticContext() != null) {
            this.emitRetainedStaticContext(expr.getRetainedStaticContext());
        }
        if (!((mod = expr.getSystemId()) == null || parent == null || parent.getSystemId() != null && parent.getSystemId().equals(mod))) {
            this.emitAttribute("module", mod);
        }
        int lineNr = expr.getLocation().getLineNumber();
        if (parent == null || parent.getLocation().getLineNumber() != lineNr && lineNr != -1) {
            this.emitAttribute("line", lineNr + "");
        }
        return n;
    }

    public void emitRetainedStaticContext(RetainedStaticContext sc) {
        try {
            if (sc.getXPathVersion() != 30) {
                this.emitAttribute("vn", sc.getXPathVersion() + "");
            }
            if (sc.getStaticBaseUri() != null) {
                this.emitAttribute("baseUri", sc.getStaticBaseUriString());
            }
            if (!sc.getDefaultCollationName().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
                this.emitAttribute("defaultCollation", sc.getDefaultCollationName());
            }
            if (!sc.getDefaultElementNamespace().isEmpty()) {
                this.emitAttribute("defaultElementNS", sc.getDefaultElementNamespace());
            }
            if (!"http://www.w3.org/2005/xpath-functions".equals(sc.getDefaultFunctionNamespace())) {
                this.emitAttribute("defaultFunctionNS", sc.getDefaultFunctionNamespace());
            }
            FastStringBuffer fsb = new FastStringBuffer(256);
            Iterator<String> iter = sc.iteratePrefixes();
            while (iter.hasNext()) {
                String p = iter.next();
                fsb.append(p);
                fsb.append("=");
                fsb.append(sc.getURIForPrefix(p, true));
                fsb.append(" ");
            }
            this.emitAttribute("ns", Whitespace.trim(fsb));
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int startElement(String name) {
        this.nameStack.push(name);
        return this._startElement(name);
    }

    private int _startElement(String name) {
        try {
            if (this.inStartTag) {
                this.receiver.startContent();
                this.inStartTag = false;
            }
            NodeName nodeName = this.defaultNamespace == null ? new NoNamespaceName(name) : new FingerprintedQName("", this.defaultNamespace, name);
            this.receiver.startElement(nodeName, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            if (this.nextRole != null) {
                this.emitAttribute("role", this.nextRole);
                this.nextRole = null;
            }
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
        this.inStartTag = true;
        return this.depth++;
    }

    public void setChildRole(String role) {
        this.nextRole = role;
    }

    public void emitAttribute(String name, String value) {
        if (value != null) {
            try {
                this.receiver.attribute(new NoNamespaceName(name), BuiltInAtomicType.UNTYPED_ATOMIC, value, ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
            catch (XPathException err) {
                err.printStackTrace();
                throw new InternalError(err.getMessage());
            }
        }
    }

    public void emitAttribute(String name, StructuredQName value) {
        try {
            if (value.getURI().isEmpty()) {
                this.receiver.attribute(new NoNamespaceName(name), BuiltInAtomicType.UNTYPED_ATOMIC, value.getLocalPart(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            } else if (value.getPrefix().isEmpty()) {
                String prefix = this.config.getNamePool().suggestPrefixForURI(value.getURI());
                if (prefix == null) {
                    prefix = this.allocatePrefix(value.getURI());
                }
                this.receiver.namespace(new NamespaceBinding(prefix, value.getURI()), 0);
                this.receiver.attribute(new NoNamespaceName(name), BuiltInAtomicType.UNTYPED_ATOMIC, prefix + ":" + value.getLocalPart(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            } else {
                this.receiver.namespace(new NamespaceBinding(value.getPrefix(), value.getURI()), 0);
                this.receiver.attribute(new NoNamespaceName(name), BuiltInAtomicType.UNTYPED_ATOMIC, value.getDisplayName(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
    }

    private String allocatePrefix(String uri) {
        String prefix;
        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
            return "xs";
        }
        if (uri.equals("http://www.w3.org/2005/xpath-functions")) {
            return "fn";
        }
        if (uri.equals("http://saxon.sf.net/")) {
            return "saxon";
        }
        int c = uri.lastIndexOf(47);
        if (c == uri.length() - 1) {
            c = uri.substring(0, uri.length() - 1).lastIndexOf(47);
        }
        if (c >= 0 && c + 3 < uri.length() && NameChecker.isValidNCName(prefix = uri.substring(c + 1, c + 3))) {
            return prefix;
        }
        return "p";
    }

    public void namespace(String prefix, String uri) {
        try {
            this.receiver.namespace(new NamespaceBinding(prefix, uri), 0);
        }
        catch (XPathException e) {
            e.printStackTrace();
            throw new InternalError(e.getMessage());
        }
    }

    public int endElement() {
        try {
            if (this.inStartTag) {
                this.receiver.startContent();
                this.inStartTag = false;
            }
            this.receiver.endElement();
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
        String name = this.nameStack.pop();
        if (name.startsWith("*")) {
            this.expressionStack.pop();
        }
        return --this.depth;
    }

    public void startSubsidiaryElement(String name) {
        this.startElement(name);
    }

    public void endSubsidiaryElement() {
        this.endElement();
    }

    public void close() {
        try {
            if (this.receiver instanceof CheckSumFilter) {
                int c = ((CheckSumFilter)this.receiver).getChecksum();
                this.receiver.processingInstruction("\u03a3", Integer.toHexString(c), ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
            this.receiver.endDocument();
            this.receiver.close();
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.config.getTypeHierarchy();
    }
}

