/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParamSetter;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalParamBlock
extends Instruction {
    Operand[] operanda;

    public LocalParamBlock(LocalParamSetter[] params) {
        this.operanda = new Operand[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.operanda[i] = new Operand(this, params[i], OperandRole.NAVIGATE);
        }
    }

    @Override
    public String getExpressionName() {
        return "params";
    }

    @Override
    public Iterable<Operand> operands() {
        return Arrays.asList(this.operanda);
    }

    public int getNumberOfParams() {
        return this.operanda.length;
    }

    @Override
    public int computeSpecialProperties() {
        return 0;
    }

    @Override
    public Expression copy() {
        LocalParamSetter[] c2 = new LocalParamSetter[this.getNumberOfParams()];
        int i = 0;
        for (Operand o : this.operands()) {
            c2[i++] = (LocalParamSetter)o.getChildExpression().copy();
        }
        return new LocalParamBlock(c2);
    }

    @Override
    public final ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public final int getCardinality() {
        return 8192;
    }

    @Override
    protected void promoteChildren(PromotionOffer offer) throws XPathException {
        for (Operand o : this.operands()) {
            LocalParamSetter p = (LocalParamSetter)o.getChildExpression();
            p.getBinding().setSelectExpression(this.doPromotion(p.getBinding().getSelectExpression(), offer));
        }
    }

    @Override
    public void export(ExpressionPresenter out) {
        out.startElement("params", this);
        for (Operand o : this.operands()) {
            o.getChildExpression().export(out);
        }
        out.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        for (Operand o : this.operands()) {
            LocalParamSetter param = (LocalParamSetter)o.getChildExpression();
            try {
                context.setLocalVariable(param.getBinding().getSlotNumber(), param.getBinding().getSelectValue(context));
            }
            catch (XPathException e) {
                e.maybeSetLocation(param.getLocation());
                e.maybeSetContext(context);
                throw e;
            }
        }
        return null;
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }
}

