/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.functions.Abs;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.functions.Adjust_1;
import net.sf.saxon.functions.Adjust_2;
import net.sf.saxon.functions.AnalyzeStringFn;
import net.sf.saxon.functions.AvailableEnvironmentVariables;
import net.sf.saxon.functions.AvailableSystemProperties;
import net.sf.saxon.functions.Average;
import net.sf.saxon.functions.BaseUri_1;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.Ceiling;
import net.sf.saxon.functions.CodepointEqual;
import net.sf.saxon.functions.CodepointsToString;
import net.sf.saxon.functions.CollatingFunctionFree;
import net.sf.saxon.functions.CollationKeyFn;
import net.sf.saxon.functions.CollectionFn;
import net.sf.saxon.functions.Compare;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.ConstantFunction;
import net.sf.saxon.functions.Contains;
import net.sf.saxon.functions.ContainsToken;
import net.sf.saxon.functions.ContextItemAccessorFunction;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.CurrentGroupingKey;
import net.sf.saxon.functions.Data_1;
import net.sf.saxon.functions.DateTimeConstructor;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.functions.DistinctValues;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocAvailable;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.DocumentUri_1;
import net.sf.saxon.functions.DynamicContextAccessor;
import net.sf.saxon.functions.ElementAvailable;
import net.sf.saxon.functions.Empty;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.EndsWith;
import net.sf.saxon.functions.EnvironmentVariable;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.EscapeHtmlUri;
import net.sf.saxon.functions.Exists;
import net.sf.saxon.functions.Floor;
import net.sf.saxon.functions.FormatDate;
import net.sf.saxon.functions.FormatInteger;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.functions.FunctionAvailable;
import net.sf.saxon.functions.GenerateId_1;
import net.sf.saxon.functions.HasChildren_1;
import net.sf.saxon.functions.HeadFn;
import net.sf.saxon.functions.Idref;
import net.sf.saxon.functions.InScopePrefixes;
import net.sf.saxon.functions.IndexOf;
import net.sf.saxon.functions.Innermost;
import net.sf.saxon.functions.InsertBefore;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.Lang;
import net.sf.saxon.functions.LocalName_1;
import net.sf.saxon.functions.LowerCase;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.Minimax;
import net.sf.saxon.functions.Name_1;
import net.sf.saxon.functions.NamespaceForPrefix;
import net.sf.saxon.functions.NamespaceUri_1;
import net.sf.saxon.functions.Nilled_1;
import net.sf.saxon.functions.NodeName_1;
import net.sf.saxon.functions.NormalizeSpace_1;
import net.sf.saxon.functions.NormalizeUnicode;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.Number_1;
import net.sf.saxon.functions.Outermost;
import net.sf.saxon.functions.ParseIetfDate;
import net.sf.saxon.functions.ParseXml;
import net.sf.saxon.functions.ParseXmlFragment;
import net.sf.saxon.functions.Path_1;
import net.sf.saxon.functions.PositionAndLast;
import net.sf.saxon.functions.Put;
import net.sf.saxon.functions.QNameFn;
import net.sf.saxon.functions.RegexFunctionSansFlags;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.Remove;
import net.sf.saxon.functions.Replace;
import net.sf.saxon.functions.ResolveQName;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.Root_1;
import net.sf.saxon.functions.Round;
import net.sf.saxon.functions.RoundHalfToEven;
import net.sf.saxon.functions.Serialize;
import net.sf.saxon.functions.SortOne;
import net.sf.saxon.functions.StartsWith;
import net.sf.saxon.functions.StaticContextAccessor;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.StringLength_1;
import net.sf.saxon.functions.StringToCodepoints;
import net.sf.saxon.functions.String_1;
import net.sf.saxon.functions.Subsequence_2;
import net.sf.saxon.functions.Subsequence_3;
import net.sf.saxon.functions.Substring;
import net.sf.saxon.functions.SubstringAfter;
import net.sf.saxon.functions.SubstringBefore;
import net.sf.saxon.functions.Sum;
import net.sf.saxon.functions.SuperId;
import net.sf.saxon.functions.SystemProperty;
import net.sf.saxon.functions.TailFn;
import net.sf.saxon.functions.Tokenize_1;
import net.sf.saxon.functions.Tokenize_3;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.functions.TransformFn;
import net.sf.saxon.functions.Translate;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.functions.TypeAvailable;
import net.sf.saxon.functions.Unordered;
import net.sf.saxon.functions.UnparsedEntity;
import net.sf.saxon.functions.UnparsedText;
import net.sf.saxon.functions.UnparsedTextAvailable;
import net.sf.saxon.functions.UnparsedTextLines;
import net.sf.saxon.functions.UpperCase;
import net.sf.saxon.functions.UriCollection;
import net.sf.saxon.ma.json.JsonDoc;
import net.sf.saxon.ma.json.JsonToXMLFn;
import net.sf.saxon.ma.json.ParseJsonFn;
import net.sf.saxon.ma.json.XMLToJsonFn;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public abstract class StandardFunction {
    public static Sequence EMPTY = EmptySequence.getInstance();
    public static final int CORE = 1;
    public static final int XSLT = 2;
    public static final int USE_WHEN = 4;
    public static final int XQUPDATE = 8;
    public static final int XPATH30 = 16;
    public static final int INTERNAL = 32;
    public static final int XSLT30 = 64;
    public static final int XPATH31 = 128;
    public static final int HOF = 256;
    public static final int ONE = 16384;
    public static final int OPT = 24576;
    public static final int STAR = 57344;
    public static final int PLUS = 49152;
    public static final int AS_ARG0 = 1;
    public static final int AS_PRIM_ARG0 = 2;
    public static final int CITEM = 4;
    public static final int BASE = 8;
    public static final int NS = 16;
    public static final int DCOLL = 32;
    public static final int DLANG = 64;
    public static final int FILTER = 256;
    public static final int LATE = 512;
    public static final int UO = 1024;
    public static final int POSN = 2048;
    public static final int LAST = 4096;
    public static final int DEPENDS_ON_STATIC_CONTEXT = 56;
    public static final int FOCUS = 6148;
    public static final int INS = 0x1000000;
    public static final int ABS = 0x2000000;
    public static final int TRA = 0x4000000;
    public static final int NAV = 0x8000000;
    private static HashMap<String, Entry> functionTable = new HashMap(200);

    private StandardFunction() {
    }

    public static Entry register(String name, Class implementationClass, int minArguments, int maxArguments, ItemType itemType, int cardinality, int applicability, int properties) {
        Entry e = StandardFunction.makeEntry(name, implementationClass, minArguments, maxArguments, itemType, cardinality, applicability, properties);
        functionTable.put(name, e);
        return e;
    }

    public static Entry makeEntry(String name, Class implementationClass, int minArguments, int maxArguments, ItemType itemType, int cardinality, int applicability, int properties) {
        Entry e = new Entry();
        int hash = name.indexOf(35);
        e.name = hash < 0 ? name : name.substring(0, hash);
        e.implementationClass = implementationClass;
        e.minArguments = minArguments;
        e.maxArguments = maxArguments;
        e.itemType = itemType;
        e.cardinality = cardinality;
        e.applicability = applicability;
        e.properties = properties;
        if (maxArguments > 100) {
            e.argumentTypes = new SequenceType[1];
            e.resultIfEmpty = new AtomicValue[1];
            e.usage = new OperandUsage[1];
        } else {
            e.argumentTypes = new SequenceType[maxArguments];
            e.resultIfEmpty = new Sequence[maxArguments];
            e.usage = new OperandUsage[maxArguments];
        }
        return e;
    }

    public static Entry getFunction(String name, int arity) {
        if (arity == -1) {
            for (int i = 0; i < 10; ++i) {
                Entry e = StandardFunction.getFunction(name, i);
                if (e == null) continue;
                return e;
            }
            return null;
        }
        Entry e = functionTable.get(name + '#' + arity);
        if (e != null) {
            return e;
        }
        e = functionTable.get(name);
        if (e != null && e.minArguments <= arity && e.maxArguments >= arity) {
            return e;
        }
        return null;
    }

    static {
        StandardFunction.register("abs", Abs.class, 1, 1, NumericType.getInstance(), 24576, 1, 2).arg(0, NumericType.getInstance(), 24576, EMPTY);
        StandardFunction.register("adjust-date-to-timezone#1", Adjust_1.class, 1, 1, BuiltInAtomicType.DATE, 24576, 1, 512).arg(0, BuiltInAtomicType.DATE, 24576, EMPTY);
        StandardFunction.register("adjust-date-to-timezone#2", Adjust_2.class, 2, 2, BuiltInAtomicType.DATE, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE, 24576, EMPTY).arg(1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, null);
        StandardFunction.register("adjust-dateTime-to-timezone#1", Adjust_1.class, 1, 1, BuiltInAtomicType.DATE_TIME, 24576, 1, 512).arg(0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        StandardFunction.register("adjust-dateTime-to-timezone#2", Adjust_2.class, 2, 2, BuiltInAtomicType.DATE_TIME, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY).arg(1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, null);
        StandardFunction.register("adjust-time-to-timezone#1", Adjust_1.class, 1, 1, BuiltInAtomicType.TIME, 24576, 1, 512).arg(0, BuiltInAtomicType.TIME, 24576, EMPTY);
        StandardFunction.register("adjust-time-to-timezone#2", Adjust_2.class, 2, 2, BuiltInAtomicType.TIME, 24576, 1, 0).arg(0, BuiltInAtomicType.TIME, 24576, EMPTY).arg(1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, null);
        StandardFunction.register("analyze-string#2", RegexFunctionSansFlags.class, 2, 2, NodeKindTest.ELEMENT, 16384, 16, 512).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("analyze-string#3", AnalyzeStringFn.class, 3, 3, NodeKindTest.ELEMENT, 16384, 16, 512).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("available-environment-variables", AvailableEnvironmentVariables.class, 0, 0, BuiltInAtomicType.STRING, 57344, 20, 512);
        StandardFunction.register("available-system-properties", AvailableSystemProperties.class, 0, 0, BuiltInAtomicType.QNAME, 57344, 68, 512);
        StandardFunction.register("avg", Average.class, 1, 1, BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 1024).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.register("base-uri#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.ANY_URI, 24576, 1, 524);
        StandardFunction.register("base-uri#1", BaseUri_1.class, 1, 1, BuiltInAtomicType.ANY_URI, 24576, 1, 8).arg(0, Type.NODE_TYPE, 0x1006000, EMPTY);
        StandardFunction.register("boolean", BooleanFn.class, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, Type.ITEM_TYPE, 0x100E000, null);
        StandardFunction.register("ceiling", Ceiling.class, 1, 1, NumericType.getInstance(), 24576, 1, 2).arg(0, NumericType.getInstance(), 24576, EMPTY);
        StandardFunction.register("codepoint-equal", CodepointEqual.class, 2, 2, BuiltInAtomicType.BOOLEAN, 24576, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.register("codepoints-to-string", CodepointsToString.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.INTEGER, 57344, null);
        StandardFunction.register("collation-key#1", CollationKeyFn.class, 1, 1, BuiltInAtomicType.ANY_ATOMIC, 24576, 20, 32).arg(0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("collation-key#2", CollatingFunctionFree.class, 2, 2, BuiltInAtomicType.ANY_ATOMIC, 24576, 20, 32).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("collection", CollectionFn.class, 0, 1, Type.ITEM_TYPE, 57344, 1, 520).arg(0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("compare#2", Compare.class, 2, 2, BuiltInAtomicType.INTEGER, 24576, 1, 32).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.register("compare#3", CollatingFunctionFree.class, 3, 3, BuiltInAtomicType.INTEGER, 24576, 1, 8).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, BuiltInAtomicType.STRING, 24576, EMPTY).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("concat", Concat.class, 2, Integer.MAX_VALUE, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.ANY_ATOMIC, 24576, null);
        StandardFunction.register("contains#2", Contains.class, 2, 2, BuiltInAtomicType.BOOLEAN, 16384, 1, 32).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, BooleanValue.TRUE);
        StandardFunction.register("contains#3", CollatingFunctionFree.class, 3, 3, BuiltInAtomicType.BOOLEAN, 16384, 1, 8).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, BooleanValue.TRUE).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("contains-token#2", ContainsToken.class, 2, 2, BuiltInAtomicType.BOOLEAN, 16384, 128, 32).arg(0, BuiltInAtomicType.STRING, 57344, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("contains-token#3", CollatingFunctionFree.class, 3, 3, BuiltInAtomicType.BOOLEAN, 16384, 128, 8).arg(0, BuiltInAtomicType.STRING, 57344, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("count", Count.class, 1, 1, BuiltInAtomicType.INTEGER, 16384, 1, 1024).arg(0, Type.ITEM_TYPE, 0x100E000, Int64Value.ZERO);
        StandardFunction.register("current", Current.class, 0, 0, Type.ITEM_TYPE, 16384, 2, 512);
        StandardFunction.register("current-date", DynamicContextAccessor.CurrentDate.class, 0, 0, BuiltInAtomicType.DATE, 16384, 1, 512);
        StandardFunction.register("current-dateTime", DynamicContextAccessor.CurrentDateTime.class, 0, 0, BuiltInAtomicType.DATE_TIME, 16384, 1, 512);
        StandardFunction.register("current-time", DynamicContextAccessor.CurrentTime.class, 0, 0, BuiltInAtomicType.TIME, 16384, 1, 512);
        StandardFunction.register("current-group", CurrentGroup.class, 0, 0, Type.ITEM_TYPE, 57344, 2, 512);
        StandardFunction.register("current-grouping-key", CurrentGroupingKey.class, 0, 0, BuiltInAtomicType.ANY_ATOMIC, 57344, 2, 512);
        StandardFunction.register("data#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.ANY_ATOMIC, 57344, 16, 516);
        StandardFunction.register("data#1", Data_1.class, 1, 1, BuiltInAtomicType.ANY_ATOMIC, 57344, 1, 0).arg(0, Type.ITEM_TYPE, 0x200E000, EMPTY);
        StandardFunction.register("dateTime", DateTimeConstructor.class, 2, 2, BuiltInAtomicType.DATE_TIME, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE, 24576, EMPTY).arg(1, BuiltInAtomicType.TIME, 24576, EMPTY);
        StandardFunction.register("day-from-date", AccessorFn.DayFromDate.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE, 24576, EMPTY);
        StandardFunction.register("day-from-dateTime", AccessorFn.DayFromDateTime.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        StandardFunction.register("days-from-duration", AccessorFn.DaysFromDuration.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        StandardFunction.register("deep-equal#2", DeepEqual.class, 2, 3, BuiltInAtomicType.BOOLEAN, 16384, 1, 32).arg(0, Type.ITEM_TYPE, 0x200E000, null).arg(1, Type.ITEM_TYPE, 0x200E000, null);
        StandardFunction.register("deep-equal#3", CollatingFunctionFree.class, 2, 3, BuiltInAtomicType.BOOLEAN, 16384, 1, 8).arg(0, Type.ITEM_TYPE, 57344, null).arg(1, Type.ITEM_TYPE, 57344, null).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("default-collation", StaticContextAccessor.DefaultCollation.class, 0, 0, BuiltInAtomicType.STRING, 16384, 1, 32);
        StandardFunction.register("default-language", DynamicContextAccessor.DefaultLanguage.class, 0, 0, BuiltInAtomicType.LANGUAGE, 16384, 1, 64);
        StandardFunction.register("distinct-values#1", DistinctValues.class, 1, 2, BuiltInAtomicType.ANY_ATOMIC, 57344, 1, 1313).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.register("distinct-values#2", CollatingFunctionFree.class, 1, 2, BuiltInAtomicType.ANY_ATOMIC, 57344, 1, 1289).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("doc", Doc.class, 1, 1, NodeKindTest.DOCUMENT, 24576, 1, 520).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.register("doc-available", DocAvailable.class, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1, 520).arg(0, BuiltInAtomicType.STRING, 24576, BooleanValue.FALSE);
        StandardFunction.register("document", DocumentFn.class, 1, 2, Type.NODE_TYPE, 57344, 2, 1544).arg(0, Type.ITEM_TYPE, 57344, null).arg(1, Type.NODE_TYPE, 16384, null);
        StandardFunction.register("document-uri#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.ANY_URI, 24576, 16, 516);
        StandardFunction.register("document-uri#1", DocumentUri_1.class, 1, 1, BuiltInAtomicType.ANY_URI, 24576, 1, 512).arg(0, Type.NODE_TYPE, 0x1006000, EMPTY);
        StandardFunction.register("element-available", ElementAvailable.class, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 6, 16).arg(0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("element-with-id#1", SuperId.ElementWithId.class, 1, 1, NodeKindTest.ELEMENT, 57344, 1, 1540).arg(0, BuiltInAtomicType.STRING, 57344, EMPTY);
        StandardFunction.register("element-with-id#2", SuperId.ElementWithId.class, 2, 2, NodeKindTest.ELEMENT, 57344, 1, 1024).arg(0, BuiltInAtomicType.STRING, 57344, EMPTY).arg(1, Type.NODE_TYPE, 16384, null);
        StandardFunction.register("empty", Empty.class, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1, 1024).arg(0, Type.ITEM_TYPE, 0x100E000, BooleanValue.TRUE);
        StandardFunction.register("encode-for-uri", EncodeForUri.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.register("ends-with#2", EndsWith.class, 2, 2, BuiltInAtomicType.BOOLEAN, 16384, 1, 32).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, BooleanValue.TRUE);
        StandardFunction.register("ends-with#3", CollatingFunctionFree.class, 3, 3, BuiltInAtomicType.BOOLEAN, 16384, 1, 8).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, BooleanValue.TRUE).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("environment-variable", EnvironmentVariable.class, 1, 1, BuiltInAtomicType.STRING, 24576, 20, 512).arg(0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("escape-html-uri", EscapeHtmlUri.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.register("error", Error.class, 0, 3, Type.ITEM_TYPE, 24576, 1, 512).arg(0, BuiltInAtomicType.QNAME, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, Type.ITEM_TYPE, 57344, null);
        StandardFunction.register("exactly-one", TreatFn.ExactlyOne.class, 1, 1, Type.ITEM_TYPE, 16384, 1, 257).arg(0, Type.ITEM_TYPE, 0x400E000, null);
        StandardFunction.register("exists", Exists.class, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1, 1024).arg(0, Type.ITEM_TYPE, 0x100E000, BooleanValue.FALSE);
        StandardFunction.register("false", ConstantFunction.False.class, 0, 0, BuiltInAtomicType.BOOLEAN, 16384, 1, 0);
        StandardFunction.register("floor", Floor.class, 1, 1, NumericType.getInstance(), 24576, 1, 2).arg(0, NumericType.getInstance(), 24576, EMPTY);
        StandardFunction.register("format-date", FormatDate.class, 2, 5, BuiltInAtomicType.STRING, 24576, 18, 0).arg(0, BuiltInAtomicType.DATE, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 24576, null).arg(3, BuiltInAtomicType.STRING, 24576, null).arg(4, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("format-dateTime", FormatDate.class, 2, 5, BuiltInAtomicType.STRING, 24576, 18, 0).arg(0, BuiltInAtomicType.DATE_TIME, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 24576, null).arg(3, BuiltInAtomicType.STRING, 24576, null).arg(4, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("format-integer", FormatInteger.class, 2, 3, AnyItemType.getInstance(), 16384, 16, 0).arg(0, BuiltInAtomicType.INTEGER, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("format-number#2", FormatNumber.class, 2, 2, BuiltInAtomicType.STRING, 16384, 18, 512).arg(0, NumericType.getInstance(), 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("format-number#3", FormatNumber.class, 3, 3, BuiltInAtomicType.STRING, 16384, 18, 528).arg(0, NumericType.getInstance(), 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("format-time", FormatDate.class, 2, 5, BuiltInAtomicType.STRING, 24576, 18, 0).arg(0, BuiltInAtomicType.TIME, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 24576, null).arg(3, BuiltInAtomicType.STRING, 24576, null).arg(4, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("function-available", FunctionAvailable.class, 1, 2, BuiltInAtomicType.BOOLEAN, 16384, 6, 528).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null);
        StandardFunction.register("generate-id#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.STRING, 16384, 18, 516);
        StandardFunction.register("generate-id#1", GenerateId_1.class, 1, 1, BuiltInAtomicType.STRING, 16384, 18, 0).arg(0, Type.NODE_TYPE, 0x1006000, StringValue.EMPTY_STRING);
        StandardFunction.register("has-children#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.BOOLEAN, 16384, 16, 516);
        StandardFunction.register("has-children#1", HasChildren_1.class, 1, 1, BuiltInAtomicType.BOOLEAN, 24576, 16, 0).arg(0, AnyNodeTest.getInstance(), 0x1006000, null);
        StandardFunction.register("head", HeadFn.class, 1, 1, AnyItemType.getInstance(), 24576, 16, 256).arg(0, AnyItemType.getInstance(), 0x400E000, null);
        StandardFunction.register("hours-from-dateTime", AccessorFn.HoursFromDateTime.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        StandardFunction.register("hours-from-duration", AccessorFn.HoursFromDuration.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        StandardFunction.register("hours-from-time", AccessorFn.HoursFromTime.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.TIME, 24576, EMPTY);
        StandardFunction.register("id#1", SuperId.Id.class, 1, 1, NodeKindTest.ELEMENT, 57344, 1, 1540).arg(0, BuiltInAtomicType.STRING, 57344, EMPTY);
        StandardFunction.register("id#2", SuperId.Id.class, 2, 2, NodeKindTest.ELEMENT, 57344, 1, 1536).arg(0, BuiltInAtomicType.STRING, 57344, EMPTY).arg(1, Type.NODE_TYPE, 0x8004000, null);
        StandardFunction.register("idref#1", Idref.class, 1, 1, Type.NODE_TYPE, 57344, 1, 516).arg(0, BuiltInAtomicType.STRING, 57344, EMPTY);
        StandardFunction.register("idref#2", Idref.class, 2, 2, Type.NODE_TYPE, 57344, 1, 512).arg(0, BuiltInAtomicType.STRING, 57344, EMPTY).arg(1, Type.NODE_TYPE, 0x8004000, null);
        StandardFunction.register("implicit-timezone", DynamicContextAccessor.ImplicitTimezone.class, 0, 0, BuiltInAtomicType.DAY_TIME_DURATION, 16384, 1, 512);
        StandardFunction.register("in-scope-prefixes", InScopePrefixes.class, 1, 1, BuiltInAtomicType.STRING, 57344, 1, 0).arg(0, NodeKindTest.ELEMENT, 0x1004000, null);
        StandardFunction.register("index-of#2", IndexOf.class, 2, 2, BuiltInAtomicType.INTEGER, 57344, 1, 32).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, BuiltInAtomicType.ANY_ATOMIC, 16384, null);
        StandardFunction.register("index-of#3", CollatingFunctionFree.class, 3, 3, BuiltInAtomicType.INTEGER, 57344, 1, 8).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, BuiltInAtomicType.ANY_ATOMIC, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("innermost", Innermost.class, 1, 1, AnyNodeTest.getInstance(), 57344, 16, 0).arg(0, AnyNodeTest.getInstance(), 0x800E000, null);
        StandardFunction.register("insert-before", InsertBefore.class, 3, 3, Type.ITEM_TYPE, 57344, 1, 0).arg(0, Type.ITEM_TYPE, 0x400E000, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, Type.ITEM_TYPE, 0x400E000, null);
        StandardFunction.register("iri-to-uri", IriToUri.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.register("json-doc", JsonDoc.class, 1, 2, AnyItemType.getInstance(), 24576, 16, 512).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, MapType.ANY_MAP_TYPE, 16384, null);
        StandardFunction.register("json-to-xml", JsonToXMLFn.class, 1, 2, AnyItemType.getInstance(), 24576, 16, 512).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, MapType.ANY_MAP_TYPE, 16384, null);
        StandardFunction.register("key#2", KeyFn.class, 2, 2, Type.NODE_TYPE, 57344, 2, 532).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.register("key#3", KeyFn.class, 3, 3, Type.NODE_TYPE, 57344, 2, 528).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(2, Type.NODE_TYPE, 16384, null);
        StandardFunction.register("lang#1", Lang.class, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1, 516).arg(0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("lang#2", Lang.class, 2, 2, BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, Type.NODE_TYPE, 0x1004000, null);
        StandardFunction.register("last", PositionAndLast.Last.class, 0, 0, BuiltInAtomicType.INTEGER, 16384, 1, 4608);
        StandardFunction.register("local-name#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.STRING, 16384, 1, 516);
        StandardFunction.register("local-name#1", LocalName_1.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, StringValue.EMPTY_STRING);
        StandardFunction.register("local-name-from-QName", AccessorFn.LocalNameFromQName.class, 1, 1, BuiltInAtomicType.NCNAME, 24576, 1, 0).arg(0, BuiltInAtomicType.QNAME, 24576, EMPTY);
        StandardFunction.register("lower-case", LowerCase.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.register("matches#2", RegexFunctionSansFlags.class, 2, 2, BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("matches#3", Matches.class, 3, 3, BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("max#1", Minimax.Max.class, 1, 1, BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 1056).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.register("max#2", CollatingFunctionFree.class, 2, 2, BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 1032).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("min#1", Minimax.Min.class, 1, 1, BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 1056).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY);
        StandardFunction.register("min#2", CollatingFunctionFree.class, 2, 2, BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 1032).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("minutes-from-dateTime", AccessorFn.MinutesFromDuration.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        StandardFunction.register("minutes-from-duration", AccessorFn.MinutesFromDuration.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        StandardFunction.register("minutes-from-time", AccessorFn.MinutesFromTime.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.TIME, 24576, EMPTY);
        StandardFunction.register("month-from-date", AccessorFn.MonthFromDate.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE, 24576, EMPTY);
        StandardFunction.register("month-from-dateTime", AccessorFn.MonthFromDateTime.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        StandardFunction.register("months-from-duration", AccessorFn.MonthsFromDuration.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        StandardFunction.register("name#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.STRING, 16384, 1, 516);
        StandardFunction.register("name#1", Name_1.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, StringValue.EMPTY_STRING);
        StandardFunction.register("namespace-uri#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.ANY_URI, 16384, 1, 516);
        StandardFunction.register("namespace-uri#1", NamespaceUri_1.class, 1, 1, BuiltInAtomicType.ANY_URI, 16384, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, StringValue.EMPTY_STRING);
        StandardFunction.register("namespace-uri-for-prefix", NamespaceForPrefix.class, 2, 2, BuiltInAtomicType.ANY_URI, 24576, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, NodeKindTest.ELEMENT, 0x1004000, null);
        StandardFunction.register("namespace-uri-from-QName", AccessorFn.NamespaceUriFromQName.class, 1, 1, BuiltInAtomicType.ANY_URI, 24576, 1, 0).arg(0, BuiltInAtomicType.QNAME, 24576, EMPTY);
        StandardFunction.register("nilled#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.BOOLEAN, 24576, 16, 516);
        StandardFunction.register("nilled#1", Nilled_1.class, 1, 1, BuiltInAtomicType.BOOLEAN, 24576, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, EMPTY);
        StandardFunction.register("node-name#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.QNAME, 24576, 16, 516);
        StandardFunction.register("node-name#1", NodeName_1.class, 1, 1, BuiltInAtomicType.QNAME, 24576, 1, 0).arg(0, Type.NODE_TYPE, 0x1006000, EMPTY);
        StandardFunction.register("not", NotFn.class, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 1, 0).arg(0, Type.ITEM_TYPE, 0x100E000, BooleanValue.TRUE);
        StandardFunction.register("normalize-space#0", ContextItemAccessorFunction.StringAccessor.class, 0, 0, BuiltInAtomicType.STRING, 16384, 1, 516);
        StandardFunction.register("normalize-space#1", NormalizeSpace_1.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("normalize-unicode", NormalizeUnicode.class, 1, 2, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("number#0", ContextItemAccessorFunction.Number_0.class, 0, 0, BuiltInAtomicType.DOUBLE, 16384, 1, 516);
        StandardFunction.register("number#1", Number_1.class, 1, 1, BuiltInAtomicType.DOUBLE, 16384, 1, 0).arg(0, BuiltInAtomicType.ANY_ATOMIC, 24576, DoubleValue.NaN);
        StandardFunction.register("one-or-more", TreatFn.OneOrMore.class, 1, 1, Type.ITEM_TYPE, 49152, 1, 257).arg(0, Type.ITEM_TYPE, 0x400E000, null);
        StandardFunction.register("outermost", Outermost.class, 1, 1, AnyNodeTest.getInstance(), 57344, 16, 257).arg(0, AnyNodeTest.getInstance(), 0x400E000, null);
        StandardFunction.register("parse-ietf-date", ParseIetfDate.class, 1, 1, BuiltInAtomicType.DATE_TIME, 24576, 128, 0).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.register("parse-json", ParseJsonFn.class, 1, 2, AnyItemType.getInstance(), 24576, 16, 0).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, MapType.ANY_MAP_TYPE, 16384, null);
        StandardFunction.register("parse-xml", ParseXml.class, 1, 1, NodeKindTest.DOCUMENT, 16384, 16, 512).arg(0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("parse-xml-fragment", ParseXmlFragment.class, 1, 1, NodeKindTest.DOCUMENT, 16384, 16, 512).arg(0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("path#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.STRING, 24576, 16, 516);
        StandardFunction.register("path#1", Path_1.class, 1, 1, BuiltInAtomicType.STRING, 24576, 16, 0).arg(0, AnyNodeTest.getInstance(), 0x1006000, null);
        StandardFunction.register("position", PositionAndLast.Position.class, 0, 0, BuiltInAtomicType.INTEGER, 16384, 1, 2560);
        StandardFunction.register("prefix-from-QName", AccessorFn.PrefixFromQName.class, 1, 1, BuiltInAtomicType.NCNAME, 24576, 1, 0).arg(0, BuiltInAtomicType.QNAME, 24576, EMPTY);
        StandardFunction.register("put", Put.class, 2, 2, AnyItemType.getInstance(), 24576, 8, 512).arg(0, Type.NODE_TYPE, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("QName", QNameFn.class, 2, 2, BuiltInAtomicType.QNAME, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("regex-group", RegexGroup.class, 1, 1, BuiltInAtomicType.STRING, 16384, 2, 512).arg(0, BuiltInAtomicType.INTEGER, 16384, null);
        StandardFunction.register("remove", Remove.class, 2, 2, Type.ITEM_TYPE, 57344, 1, 257).arg(0, Type.ITEM_TYPE, 0x400E000, EMPTY).arg(1, BuiltInAtomicType.INTEGER, 16384, null);
        StandardFunction.register("replace#3", RegexFunctionSansFlags.class, 3, 3, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("replace#4", Replace.class, 4, 4, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null).arg(3, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("resolve-QName", ResolveQName.class, 2, 2, BuiltInAtomicType.QNAME, 24576, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, NodeKindTest.ELEMENT, 0x1004000, null);
        StandardFunction.register("resolve-uri#1", ResolveURI.class, 1, 1, BuiltInAtomicType.ANY_URI, 24576, 1, 8).arg(0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("resolve-uri#2", ResolveURI.class, 2, 2, BuiltInAtomicType.ANY_URI, 24576, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("reverse", Reverse.class, 1, 1, Type.ITEM_TYPE, 57344, 1, 257).arg(0, Type.ITEM_TYPE, 0x800E000, EMPTY);
        StandardFunction.register("root#0", ContextItemAccessorFunction.class, 0, 0, Type.NODE_TYPE, 24576, 1, 516);
        StandardFunction.register("root#1", Root_1.class, 1, 1, Type.NODE_TYPE, 24576, 1, 0).arg(0, Type.NODE_TYPE, 0x8006000, EMPTY);
        StandardFunction.register("round#1", Round.class, 1, 1, NumericType.getInstance(), 24576, 1, 2).arg(0, NumericType.getInstance(), 24576, EMPTY);
        StandardFunction.register("round#2", Round.class, 2, 2, NumericType.getInstance(), 24576, 16, 2).arg(0, NumericType.getInstance(), 24576, EMPTY).arg(1, BuiltInAtomicType.INTEGER, 16384, null);
        StandardFunction.register("round-half-to-even", RoundHalfToEven.class, 1, 2, NumericType.getInstance(), 24576, 1, 2).arg(0, NumericType.getInstance(), 24576, EMPTY).arg(1, BuiltInAtomicType.INTEGER, 16384, null);
        StandardFunction.register("seconds-from-dateTime", AccessorFn.SecondsFromDateTime.class, 1, 1, BuiltInAtomicType.DECIMAL, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        StandardFunction.register("seconds-from-duration", AccessorFn.SecondsFromDuration.class, 1, 1, BuiltInAtomicType.DECIMAL, 24576, 1, 0).arg(0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        StandardFunction.register("seconds-from-time", AccessorFn.SecondsFromTime.class, 1, 1, BuiltInAtomicType.DECIMAL, 24576, 1, 0).arg(0, BuiltInAtomicType.TIME, 24576, EMPTY);
        StandardFunction.register("serialize", Serialize.class, 1, 2, BuiltInAtomicType.STRING, 16384, 16, 0).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, Type.ITEM_TYPE, 24576, null);
        StandardFunction.register("sort#1", SortOne.class, 1, 1, AnyItemType.getInstance(), 57344, 128, 0).arg(0, AnyItemType.getInstance(), 57344, null);
        StandardFunction.register("starts-with#2", StartsWith.class, 2, 2, BuiltInAtomicType.BOOLEAN, 16384, 1, 32).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, BooleanValue.TRUE);
        StandardFunction.register("starts-with#3", CollatingFunctionFree.class, 3, 3, BuiltInAtomicType.BOOLEAN, 16384, 1, 8).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, BooleanValue.TRUE).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("static-base-uri", StaticContextAccessor.StaticBaseUri.class, 0, 0, BuiltInAtomicType.ANY_URI, 24576, 1, 8);
        StandardFunction.register("string#0", ContextItemAccessorFunction.class, 0, 0, BuiltInAtomicType.STRING, 16384, 1, 516);
        StandardFunction.register("string#1", String_1.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, Type.ITEM_TYPE, 0x2006000, StringValue.EMPTY_STRING);
        StandardFunction.register("string-length#0", ContextItemAccessorFunction.StringAccessor.class, 0, 0, BuiltInAtomicType.INTEGER, 16384, 1, 516);
        StandardFunction.register("string-length#1", StringLength_1.class, 1, 1, BuiltInAtomicType.INTEGER, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("string-join#1", StringJoin.class, 1, 1, BuiltInAtomicType.STRING, 16384, 16, 0).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, StringValue.EMPTY_STRING);
        StandardFunction.register("string-join#2", StringJoin.class, 2, 2, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, StringValue.EMPTY_STRING).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("string-to-codepoints", StringToCodepoints.class, 1, 1, BuiltInAtomicType.INTEGER, 57344, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.register("subsequence#2", Subsequence_2.class, 2, 2, Type.ITEM_TYPE, 57344, 1, 257).arg(0, Type.ITEM_TYPE, 0x400E000, EMPTY).arg(1, NumericType.getInstance(), 16384, null);
        StandardFunction.register("subsequence#3", Subsequence_3.class, 3, 3, Type.ITEM_TYPE, 57344, 1, 257).arg(0, Type.ITEM_TYPE, 0x400E000, EMPTY).arg(1, NumericType.getInstance(), 16384, null).arg(2, NumericType.getInstance(), 16384, null);
        StandardFunction.register("substring", Substring.class, 2, 3, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING).arg(1, NumericType.getInstance(), 16384, null).arg(2, NumericType.getInstance(), 16384, null);
        StandardFunction.register("substring-after#2", SubstringAfter.class, 2, 2, BuiltInAtomicType.STRING, 16384, 1, 32).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("substring-after#3", CollatingFunctionFree.class, 3, 3, BuiltInAtomicType.STRING, 16384, 1, 8).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, null).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("substring-before#2", SubstringBefore.class, 2, 2, BuiltInAtomicType.STRING, 16384, 1, 32).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.register("substring-before#3", CollatingFunctionFree.class, 3, 3, BuiltInAtomicType.STRING, 16384, 1, 8).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("sum", Sum.class, 1, 2, BuiltInAtomicType.ANY_ATOMIC, 24576, 1, 1024).arg(0, BuiltInAtomicType.ANY_ATOMIC, 57344, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 24576, null);
        StandardFunction.register("system-property", SystemProperty.class, 1, 1, BuiltInAtomicType.STRING, 16384, 6, 16).arg(0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("tail", TailFn.class, 1, 1, AnyItemType.getInstance(), 57344, 16, 257).arg(0, AnyItemType.getInstance(), 0x400E000, null);
        StandardFunction.register("timezone-from-date", AccessorFn.TimezoneFromDate.class, 1, 1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE, 24576, EMPTY);
        StandardFunction.register("timezone-from-dateTime", AccessorFn.TimezoneFromDateTime.class, 1, 1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        StandardFunction.register("timezone-from-time", AccessorFn.TimezoneFromTime.class, 1, 1, BuiltInAtomicType.DAY_TIME_DURATION, 24576, 1, 0).arg(0, BuiltInAtomicType.TIME, 24576, EMPTY);
        StandardFunction.register("trace#1", Trace.class, 1, 1, Type.ITEM_TYPE, 57344, 128, 513).arg(0, Type.ITEM_TYPE, 0x400E000, null);
        StandardFunction.register("trace#2", Trace.class, 2, 2, Type.ITEM_TYPE, 57344, 1, 513).arg(0, Type.ITEM_TYPE, 0x400E000, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("transform", TransformFn.class, 0, 1, MapType.ANY_MAP_TYPE, 16384, 128, 0).arg(0, MapType.ANY_MAP_TYPE, 24576, EMPTY);
        StandardFunction.register("translate", Translate.class, 3, 3, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("true", ConstantFunction.True.class, 0, 0, BuiltInAtomicType.BOOLEAN, 16384, 1, 0);
        StandardFunction.register("tokenize#1", Tokenize_1.class, 1, 1, BuiltInAtomicType.STRING, 57344, 128, 0).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY);
        StandardFunction.register("tokenize#2", RegexFunctionSansFlags.class, 2, 2, BuiltInAtomicType.STRING, 57344, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("tokenize#3", Tokenize_3.class, 3, 3, BuiltInAtomicType.STRING, 57344, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, EMPTY).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("type-available", TypeAvailable.class, 1, 1, BuiltInAtomicType.BOOLEAN, 16384, 6, 16).arg(0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("unordered", Unordered.class, 1, 1, Type.ITEM_TYPE, 57344, 1, 1281).arg(0, Type.ITEM_TYPE, 0x400E000, EMPTY);
        StandardFunction.register("upper-case", UpperCase.class, 1, 1, BuiltInAtomicType.STRING, 16384, 1, 0).arg(0, BuiltInAtomicType.STRING, 24576, StringValue.EMPTY_STRING);
        StandardFunction.register("unparsed-entity-uri#1", UnparsedEntity.UnparsedEntityUri.class, 1, 2, BuiltInAtomicType.ANY_URI, 16384, 2, 516).arg(0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("unparsed-entity-uri#2", UnparsedEntity.UnparsedEntityUri.class, 1, 2, BuiltInAtomicType.ANY_URI, 16384, 2, 0).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, Type.NODE_TYPE, 16384, null);
        StandardFunction.register("unparsed-entity-public-id#1", UnparsedEntity.UnparsedEntityPublicId.class, 1, 2, BuiltInAtomicType.STRING, 16384, 2, 516).arg(0, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("unparsed-entity-public-id#2", UnparsedEntity.UnparsedEntityPublicId.class, 1, 2, BuiltInAtomicType.STRING, 16384, 2, 0).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, Type.NODE_TYPE, 16384, null);
        StandardFunction.register("unparsed-text", UnparsedText.class, 1, 2, BuiltInAtomicType.STRING, 24576, 18, 520).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("unparsed-text-available", UnparsedTextAvailable.class, 1, 2, BuiltInAtomicType.BOOLEAN, 16384, 18, 520).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("unparsed-text-lines", UnparsedTextLines.class, 1, 2, BuiltInAtomicType.STRING, 57344, 16, 520).arg(0, BuiltInAtomicType.STRING, 24576, null).arg(1, BuiltInAtomicType.STRING, 16384, null);
        StandardFunction.register("uri-collection", UriCollection.class, 0, 1, BuiltInAtomicType.ANY_URI, 57344, 16, 512).arg(0, BuiltInAtomicType.STRING, 24576, null);
        StandardFunction.register("xml-to-json", XMLToJsonFn.class, 1, 2, AnyItemType.getInstance(), 24576, 16, 512).arg(0, AnyNodeTest.getInstance(), 24576, null).arg(1, MapType.ANY_MAP_TYPE, 16384, null);
        StandardFunction.register("year-from-date", AccessorFn.YearFromDate.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE, 24576, EMPTY);
        StandardFunction.register("year-from-dateTime", AccessorFn.YearFromDateTime.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DATE_TIME, 24576, EMPTY);
        StandardFunction.register("years-from-duration", AccessorFn.YearsFromDuration.class, 1, 1, BuiltInAtomicType.INTEGER, 24576, 1, 0).arg(0, BuiltInAtomicType.DURATION, 24576, EMPTY);
        StandardFunction.register("zero-or-one", TreatFn.ZeroOrOne.class, 1, 1, Type.ITEM_TYPE, 24576, 1, 257).arg(0, Type.ITEM_TYPE, 0x400E000, null);
    }

    public static class Entry
    implements Serializable {
        public String name;
        public Class implementationClass;
        public int minArguments;
        public int maxArguments;
        public ItemType itemType;
        public int cardinality;
        public int applicability;
        public OperandUsage[] usage;
        public SequenceType[] argumentTypes;
        public Sequence[] resultIfEmpty;
        public int properties;

        public Entry arg(int a, ItemType type, int options, Sequence resultIfEmpty) {
            int cardinality = options & 0xE000;
            OperandUsage usage = OperandUsage.NAVIGATION;
            if ((options & 0x2000000) != 0) {
                usage = OperandUsage.ABSORPTION;
            } else if ((options & 0x4000000) != 0) {
                usage = OperandUsage.TRANSMISSION;
            } else if ((options & 0x1000000) != 0) {
                usage = OperandUsage.INSPECTION;
            } else if (type instanceof PlainType) {
                usage = OperandUsage.ABSORPTION;
            }
            try {
                this.argumentTypes[a] = SequenceType.makeSequenceType(type, cardinality);
                this.resultIfEmpty[a] = resultIfEmpty;
                this.usage[a] = usage;
            }
            catch (ArrayIndexOutOfBoundsException err) {
                System.err.println("Internal Saxon error: Can't set argument " + a + " of " + this.name);
            }
            return this;
        }
    }
}

