/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.SAXParseException;

public class IdentityTransformer
extends Transformer {
    private Configuration configuration;
    private Properties localOutputProperties;
    private URIResolver uriResolver;
    private ErrorListener errorListener;

    protected IdentityTransformer(Configuration config) {
        this.configuration = config;
    }

    public void reset() {
        this.localOutputProperties = null;
        this.uriResolver = null;
        this.errorListener = null;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        if (this.errorListener instanceof DelegatingErrorListener) {
            return ((DelegatingErrorListener)this.errorListener).getBaseErrorListener();
        }
        return this.errorListener;
    }

    public void setOutputProperties(Properties properties) {
        if (properties == null) {
            this.localOutputProperties = null;
        } else {
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.setOutputProperty(key, properties.getProperty(key));
            }
        }
    }

    public Properties getOutputProperties() {
        if (this.localOutputProperties == null) {
            this.localOutputProperties = new Properties(this.getStylesheetOutputProperties());
        }
        Properties newProps = new Properties();
        Enumeration<?> keys = this.localOutputProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            newProps.setProperty(key, this.localOutputProperties.getProperty(key));
        }
        return newProps;
    }

    protected Properties getStylesheetOutputProperties() {
        return new Properties();
    }

    protected Properties getLocalOutputProperties() {
        if (this.localOutputProperties == null) {
            this.localOutputProperties = new Properties();
        }
        return this.localOutputProperties;
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        try {
            SaxonOutputKeys.checkOutputProperty(name, null, this.getConfiguration(), true);
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
        if (this.localOutputProperties == null) {
            this.localOutputProperties = this.getStylesheetOutputProperties();
        }
        return this.localOutputProperties.getProperty(name);
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        if (this.localOutputProperties == null) {
            this.localOutputProperties = this.getOutputProperties();
        }
        try {
            value = SaxonOutputKeys.checkOutputProperty(name, value, this.getConfiguration(), true);
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
        this.localOutputProperties.setProperty(name, value);
    }

    public void setParameter(String name, Object value) {
    }

    public Object getParameter(String name) {
        return null;
    }

    public void clearParameters() {
    }

    public void transform(Source source, Result result) throws TransformerException {
        try {
            PipelineConfiguration pipe = this.getConfiguration().makePipelineConfiguration();
            SerializerFactory sf = this.getConfiguration().getSerializerFactory();
            SequenceReceiver receiver = sf.getReceiver(result, pipe, this.getOutputProperties());
            ParseOptions options = pipe.getParseOptions();
            options.setContinueAfterValidationErrors(true);
            Sender.send(source, receiver, options);
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    this.reportFatalError(err);
                }
            } else {
                this.reportFatalError(err);
            }
            throw err;
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void reportFatalError(XPathException err) {
        try {
            if (this.errorListener != null) {
                this.errorListener.error(err);
            } else {
                this.getConfiguration().getErrorListener().error(err);
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }
}

