/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.Invalidity;
import net.sf.saxon.om.AbsolutePath;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;

public class ValidationFailure
implements Location,
ConversionResult,
Invalidity {
    private String message;
    private String systemId;
    private String publicId;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private AbsolutePath path;
    private AbsolutePath contextPath;
    private NodeInfo invalidNode;
    private int schemaPart = -1;
    private String constraintName;
    private String clause;
    private SchemaType schemaType;
    private StructuredQName errorCode;
    private ValidationException exception;
    private boolean hasBeenReported;

    public ValidationFailure(String message) {
        this.message = message;
        this.setErrorCode("FORG0001");
    }

    public ValidationFailure(Exception exception) {
        this.message = exception.getMessage();
        if (exception instanceof XPathException) {
            this.errorCode = ((XPathException)exception).getErrorCodeQName();
        } else {
            this.setErrorCode("FORG0001");
        }
        if (exception instanceof ValidationException) {
            ValidationException ve;
            this.exception = ve = (ValidationException)exception;
            this.message = ve.getMessage();
            this.errorCode = ve.getErrorCodeQName();
            this.systemId = ve.getSystemId();
            this.publicId = ve.getPublicId();
            this.lineNumber = ve.getLineNumber();
            this.columnNumber = ve.getColumnNumber();
            this.constraintName = ve.getConstraintName();
            this.clause = ve.getConstraintClauseNumber();
            this.schemaType = ve.getSchemaType();
            this.hasBeenReported = ve.hasBeenReported();
        }
    }

    public void setConstraintReference(int schemaPart, String constraintName, String clause) {
        this.schemaPart = schemaPart;
        this.constraintName = constraintName;
        this.clause = clause;
    }

    public void setConstraintReference(ValidationFailure e) {
        this.schemaPart = e.schemaPart;
        this.constraintName = e.constraintName;
        this.clause = e.clause;
    }

    public int getSchemaPart() {
        return this.schemaPart;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getConstraintClauseNumber() {
        return this.clause;
    }

    public String getConstraintReference() {
        return this.constraintName + '.' + this.clause;
    }

    public AbsolutePath getPath() {
        return this.path;
    }

    public void setPath(AbsolutePath path) {
        this.path = path;
    }

    public AbsolutePath getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(AbsolutePath contextPath) {
        this.contextPath = contextPath;
    }

    public NodeInfo getInvalidNode() {
        return this.invalidNode;
    }

    public void setInvalidNode(NodeInfo invalidNode) {
        this.invalidNode = invalidNode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        FastStringBuffer sb = new FastStringBuffer("ValidationException: ");
        String message = this.getMessage();
        if (message != null) {
            sb.append(message);
        }
        return sb.toString();
    }

    public String getPublicId() {
        Location loc = this.getLocator();
        if (this.publicId == null && loc != null && loc != this) {
            return loc.getPublicId();
        }
        return this.publicId;
    }

    public String getSystemId() {
        Location loc = this.getLocator();
        if (this.systemId == null && loc != null && loc != this) {
            return loc.getSystemId();
        }
        return this.systemId;
    }

    public int getLineNumber() {
        Location loc = this.getLocator();
        if (this.lineNumber == -1 && loc != null && loc != this) {
            return loc.getLineNumber();
        }
        return this.lineNumber;
    }

    public int getColumnNumber() {
        Location loc = this.getLocator();
        if (this.columnNumber == -1 && loc != null && loc != this) {
            return loc.getColumnNumber();
        }
        return this.columnNumber;
    }

    public Location saveLocation() {
        return new ExplicitLocation(this);
    }

    public void setPublicId(String id) {
        this.publicId = id;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    public void setColumnNumber(int column) {
        this.columnNumber = column;
    }

    public void setLocator(SourceLocator locator) {
        if (locator != null) {
            this.setPublicId(locator.getPublicId());
            this.setSystemId(locator.getSystemId());
            this.setLineNumber(locator.getLineNumber());
            this.setColumnNumber(locator.getColumnNumber());
        }
    }

    public void setSourceLocator(SourceLocator locator) {
        if (locator != null) {
            this.setPublicId(locator.getPublicId());
            this.setSystemId(locator.getSystemId());
            this.setLineNumber(locator.getLineNumber());
            this.setColumnNumber(locator.getColumnNumber());
        }
    }

    public Location getLocator() {
        return this;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode == null ? null : new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", errorCode);
    }

    public void setErrorCodeQName(StructuredQName errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        if (this.errorCode == null) {
            return null;
        }
        if (this.errorCode.hasURI("http://www.w3.org/2005/xqt-errors")) {
            return this.errorCode.getLocalPart();
        }
        return this.errorCode.getEQName();
    }

    public StructuredQName getErrorCodeQName() {
        return this.errorCode;
    }

    public void setSchemaType(SchemaType type) {
        this.schemaType = type;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public ValidationException makeException() {
        if (this.exception != null) {
            this.exception.maybeSetLocation(this);
            return this.exception;
        }
        ValidationException ve = new ValidationException(this.message, this.getLocator());
        ve.setConstraintReference(this.schemaPart, this.constraintName, this.clause);
        if (this.errorCode == null) {
            ve.setErrorCode("FORG0001");
        } else {
            ve.setErrorCodeQName(this.errorCode);
        }
        ve.setHasBeenReported(this.hasBeenReported);
        this.exception = ve;
        return ve;
    }

    public ValidationException makeException(String contextMessage) {
        ValidationException ve = new ValidationException(contextMessage == null ? this.message : contextMessage + this.message);
        ve.setConstraintReference(this.schemaPart, this.constraintName, this.clause);
        if (this.errorCode == null) {
            ve.setErrorCode("FORG0001");
        } else {
            ve.setErrorCodeQName(this.errorCode);
        }
        return ve;
    }

    public AtomicValue asAtomic() throws ValidationException {
        throw this.makeException();
    }

    public boolean hasBeenReported() {
        return this.hasBeenReported;
    }

    public void setHasBeenReported(boolean reported) {
        this.hasBeenReported = reported;
        if (this.exception != null) {
            this.exception.setHasBeenReported(reported);
        }
    }

    public String getValidationLocationText() {
        FastStringBuffer fsb = new FastStringBuffer(256);
        AbsolutePath valPath = this.getAbsolutePath();
        if (valPath != null) {
            fsb.append("Validating ");
            fsb.append(valPath.getPathUsingPrefixes());
            if (valPath.getSystemId() != null) {
                fsb.append(" in ");
                fsb.append(valPath.getSystemId());
            }
        }
        return fsb.toString();
    }

    public String getContextLocationText() {
        FastStringBuffer fsb = new FastStringBuffer(256);
        AbsolutePath contextPath = this.getContextPath();
        if (contextPath != null) {
            fsb.append("Currently processing ");
            fsb.append(contextPath.getPathUsingPrefixes());
            if (contextPath.getSystemId() != null) {
                fsb.append(" in ");
                fsb.append(contextPath.getSystemId());
            }
        }
        return fsb.toString();
    }

    public AbsolutePath getAbsolutePath() {
        if (this.path != null) {
            return this.path;
        }
        return null;
    }
}

