/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;

public class TailExpression
extends UnaryExpression {
    int start;

    public TailExpression(Expression base, int start) {
        super(base);
        this.start = start;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        if (this.getBaseExpression() instanceof Literal) {
            GroundedValue value = SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()));
            return Literal.makeLiteral(value);
        }
        return this;
    }

    public Expression copy() {
        TailExpression exp = new TailExpression(this.getBaseExpression().copy(), this.start);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    public int computeCardinality() {
        return this.getBaseExpression().getCardinality() | 0x2000;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public int getStart() {
        return this.start;
    }

    public boolean equals(Object other) {
        return other instanceof TailExpression && super.equals(other) && this.start == ((TailExpression)other).start;
    }

    public int hashCode() {
        return super.hashCode() ^ this.start;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator baseIter = this.getBaseExpression().iterate(context);
        return TailIterator.make(baseIter, this.start);
    }

    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("tail", this);
        destination.emitAttribute("start", this.start + "");
        this.getBaseExpression().export(destination);
        destination.endElement();
    }

    public String toString() {
        if (this.start == 2) {
            return "tail(" + this.getBaseExpression().toString() + ")";
        }
        return ExpressionTool.parenthesize(this.getBaseExpression()) + "[position() ge " + this.start + "]";
    }

    public String toShortString() {
        if (this.start == 2) {
            return "tail(" + this.getBaseExpression().toShortString() + ")";
        }
        return this.getBaseExpression().toShortString() + "[position() ge " + this.start + "]";
    }
}

