/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringReader;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.value.StringValue;
import org.xml.sax.InputSource;

public class ParseXml
extends SystemFunction
implements Callable {
    public NodeInfo call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.evalParseXml((StringValue)arguments[0].head(), context);
    }

    private NodeInfo evalParseXml(StringValue inputArg, XPathContext context) throws XPathException {
        String baseURI = this.getRetainedStaticContext().getStaticBaseUriString();
        try {
            Builder b;
            Controller controller = context.getController();
            if (controller == null) {
                throw new XPathException("parse-xml() function is not available in this environment");
            }
            Configuration configuration = controller.getConfiguration();
            StringReader sr = new StringReader(inputArg.getStringValue());
            InputSource is = new InputSource(sr);
            is.setSystemId(baseURI);
            SAXSource source = new SAXSource(is);
            source.setSystemId(baseURI);
            Receiver s = b = TreeModel.TINY_TREE.makeBuilder(controller.makePipelineConfiguration());
            ParseOptions options = new ParseOptions();
            options.setStripSpace(4);
            options.setErrorListener(context.getConfiguration().getErrorListener());
            if (controller.getExecutable().stripsInputTypeAnnotations()) {
                s = configuration.getAnnotationStripper(s);
            }
            s.setPipelineConfiguration(b.getPipelineConfiguration());
            Sender.send(source, s, options);
            TinyDocumentImpl node = (TinyDocumentImpl)b.getCurrentRoot();
            node.setBaseURI(baseURI);
            node.setSystemId(null);
            b.reset();
            return node;
        }
        catch (XPathException err) {
            throw new XPathException("First argument to parse-xml() is not a well-formed and namespace-well-formed XML document. XML parser reported: " + err.getMessage(), "FODC0006");
        }
    }
}

